/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.voc;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ecat.voc.KnownTerm;
import org.gbif.ecat.voc.TermType;

public enum IdentifierType implements KnownTerm
{
    URL,
    LSID,
    DOI,
    Handler,
    UUID,
    FTP,
    URI,
    SourceID,
    Unknown;

    private static final int ID_BASE = 2000;

    public static IdentifierType guessType(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return null;
        }
        if ((identifier = identifier.toLowerCase()).startsWith("doi:10") || identifier.startsWith("urn:doi:") || identifier.startsWith("http://dx.doi.org/10.")) {
            return DOI;
        }
        if (identifier.startsWith("http:") || identifier.startsWith("https:") || identifier.startsWith("www.")) {
            return URL;
        }
        if (identifier.startsWith("ftp:")) {
            return FTP;
        }
        if (identifier.startsWith("urn:lsid:") || identifier.startsWith("lsid:")) {
            return LSID;
        }
        if (identifier.startsWith("urn:uuid:") || identifier.startsWith("uuid:")) {
            return UUID;
        }
        try {
            UUID uuid = java.util.UUID.fromString(identifier);
            return UUID;
        }
        catch (Exception exception) {
            return Unknown;
        }
    }

    @Deprecated
    public static IdentifierType valueOf(int termID) {
        return IdentifierType.valueOfTermID(termID);
    }

    public static IdentifierType valueOfTermID(Integer termID) {
        for (IdentifierType term : IdentifierType.values()) {
            if (termID == null || term.termID() != termID.intValue()) continue;
            return term;
        }
        return null;
    }

    @Override
    public int termID() {
        return 2000 + this.ordinal();
    }

    @Override
    public TermType type() {
        return TermType.IDENTIFIER_TYPE;
    }
}

