/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.WordUtils;

public class StringUtils {
    static final int LINNEAN_YEAR = 1751;
    static final String CONS = "BCDFGHJKLMNPQRSTVWXYZ";
    private static final Pattern OCT = Pattern.compile("^[0-7]+$");
    private static final Pattern HEX = Pattern.compile("^[0-9abcdefABCDEF]+$");
    static final String VOC = "AEIOU";
    static Random rnd = new Random();

    public static String emptyLowerCase(String x) {
        if (x == null) {
            return "";
        }
        return x.trim().toLowerCase();
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static String increase(String x) {
        if (x == null) {
            return null;
        }
        if (x.equals("")) {
            return x;
        }
        char lastChar = x.charAt(x.length() - 1);
        if (lastChar == 'z' && x.length() > 1) {
            return StringUtils.increase(x.substring(0, x.length() - 1)) + "a";
        }
        if (lastChar == 'Z' && x.length() > 1) {
            return StringUtils.increase(x.substring(0, x.length() - 1)) + "A";
        }
        lastChar = (char)(lastChar + '\u0001');
        return x.substring(0, x.length() - 1) + lastChar;
    }

    public static String joinIfNotNull(String delimiter, Object ... values) {
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        for (Object obj : values) {
            if (obj == null) continue;
            if (comma) {
                sb.append(delimiter);
            } else {
                comma = true;
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.increase("Carla"));
        System.out.println(StringUtils.increase("Holz"));
        System.out.println(StringUtils.increase("Atz"));
    }

    public static Boolean parseBoolean(String x) {
        if ((x = org.apache.commons.lang3.StringUtils.trimToEmpty((String)x).toLowerCase()).equals("true") || x.equals("t") || x.equals("1") || x.equals("yes") || x.equals("y")) {
            return true;
        }
        if (x.equals("false") || x.equals("f") || x.equals("0") || x.equals("no") || x.equals("n")) {
            return false;
        }
        return null;
    }

    public static String randomSpecies() {
        return WordUtils.capitalize((String)StringUtils.randomString(rnd.nextInt(9) + 3)) + " " + StringUtils.randomString(rnd.nextInt(11) + 4).toLowerCase();
    }

    public static String randomString(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            if (rnd.nextInt(3) > 1) {
                sb.append(CONS.charAt(rnd.nextInt(CONS.length())));
                continue;
            }
            sb.append(VOC.charAt(rnd.nextInt(VOC.length())));
        }
        return sb.toString();
    }

    public static String randomSpeciesYear() {
        int maxYear = Calendar.getInstance().get(1);
        return String.valueOf(1751 + rnd.nextInt(maxYear - 1751 + 1));
    }

    public static Integer toInteger(String x) {
        try {
            return Integer.valueOf(x);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String toStringBuilder(boolean withLabels, Object ... prop) {
        if (withLabels) {
            ArrayList<String> result = new ArrayList<String>();
            int idx = 0;
            while (idx + 1 < prop.length) {
                String attr = (prop[idx] == null ? "?" : prop[idx].toString()) + ":" + (prop[idx + 1] == null ? "---" : prop[idx + 1].toString());
                result.add(attr);
                ++idx;
                ++idx;
            }
            return org.apache.commons.lang3.StringUtils.join(result, (String)" ");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object p : prop) {
            result.add(p == null ? "---" : p.toString());
        }
        return org.apache.commons.lang3.StringUtils.join(result, (String)" ");
    }

    public static String unescapeUnicodeChars(String text) {
        if (text == null) {
            return null;
        }
        int i = 0;
        int len = text.length();
        StringBuffer sb = new StringBuffer(len);
        while (i < len) {
            int c;
            block13: {
                if ((c = text.charAt(i++)) == 92 && i < len) {
                    c = text.charAt(i++);
                    try {
                        String hex;
                        if (c == 117 && text.length() >= i + 4) {
                            hex = text.substring(i, i + 4);
                            if (HEX.matcher(hex).find()) {
                                c = (char)Integer.parseInt(hex, 16);
                                i += 4;
                                break block13;
                            }
                            throw new NumberFormatException("No hex value: " + hex);
                        }
                        if (c == 110 && text.length() >= i + 2) {
                            String oct = text.substring(i, i + 2);
                            if (OCT.matcher(oct).find()) {
                                c = (char)Integer.parseInt(oct, 8);
                                i += 2;
                                break block13;
                            }
                            throw new NumberFormatException("No octal value: " + oct);
                        }
                        if (c == 120 && text.length() >= i + 2) {
                            hex = text.substring(i, i + 2);
                            if (HEX.matcher(hex).find()) {
                                c = (char)Integer.parseInt(hex, 16);
                                i += 2;
                                break block13;
                            }
                            throw new NumberFormatException("No hex value: " + hex);
                        }
                        if (c == 114 || c == 110 || c == 116) {
                            c = 32;
                            break block13;
                        }
                        throw new NumberFormatException("No char escape");
                    }
                    catch (NumberFormatException e) {
                        if (c == 110) {
                            c = 32;
                        }
                        c = 92;
                        --i;
                    }
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static Map<String, String> upper(Map<String, String> map) {
        HashMap<String, String> upperMap = new HashMap<String, String>();
        for (String k : map.keySet()) {
            String v = map.get(k);
            if (v != null) {
                v = v.trim().toUpperCase();
            }
            upperMap.put(k.toUpperCase(), v);
        }
        return upperMap;
    }
}

