/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class NormalizeUtils {
    private static final Pattern NORM_PUNCTUATION = Pattern.compile("[-_\\.;!\"]+");
    private static final Pattern NORM_WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern NORM_TERM = Pattern.compile("[-_\\.\\s]+");
    private static final Pattern NORM_CITATION_PUNCT = Pattern.compile("\\. *");
    private static final Pattern NORM_CITATION_WHITE = Pattern.compile("[_\\s]+");
    private static final Pattern XML_ENTITIES_DEC = Pattern.compile("&#([0-9]{2,});");
    private static final Pattern XML_ENTITIES_HEX = Pattern.compile("&#x([0-9abcdefABCDEF]{2,});");
    private static final Pattern UNICODE_HEX = Pattern.compile("\\\\u([0-9abcdefABCDEF]{4});");

    public static String normalizeCitation(String citation) {
        return NormalizeUtils.trimToNull(NORM_CITATION_WHITE.matcher(NORM_CITATION_PUNCT.matcher(citation).replaceAll(". ")).replaceAll(" "));
    }

    public static String normalizeTerm(String term) {
        return NormalizeUtils.trimToNull(NORM_TERM.matcher(term).replaceAll(" ").toLowerCase());
    }

    public static String normalizeVernacular(String name) {
        if (name == null) {
            return name;
        }
        return NormalizeUtils.trimToNull(NORM_WHITESPACE.matcher(NORM_PUNCTUATION.matcher(NormalizeUtils.replaceUnicodeEntities(name)).replaceAll(" ")).replaceAll(" "));
    }

    public static String normalizeWhitespace(String x) {
        return NormalizeUtils.trimToNull(NORM_WHITESPACE.matcher(x).replaceAll(" "));
    }

    public static String replaceUnicodeEntities(String x) {
        Character uc;
        StringBuffer sb;
        if (x == null) {
            return x;
        }
        Matcher m = XML_ENTITIES_DEC.matcher(x);
        if (m.find()) {
            m.reset();
            sb = new StringBuffer();
            while (m.find()) {
                try {
                    uc = Character.valueOf((char)Integer.parseInt(m.group(1)));
                    m.appendReplacement(sb, uc.toString());
                }
                catch (NumberFormatException e) {
                    m.appendReplacement(sb, m.group());
                }
            }
            m.appendTail(sb);
            x = sb.toString();
        }
        if ((m = XML_ENTITIES_HEX.matcher(x)).find()) {
            m.reset();
            sb = new StringBuffer();
            while (m.find()) {
                try {
                    uc = Character.valueOf((char)Integer.parseInt(m.group(1), 16));
                    m.appendReplacement(sb, uc.toString());
                }
                catch (NumberFormatException e) {
                    m.appendReplacement(sb, m.group());
                }
            }
            m.appendTail(sb);
            x = sb.toString();
        }
        if ((m = UNICODE_HEX.matcher(x)).find()) {
            m.reset();
            sb = new StringBuffer();
            while (m.find()) {
                try {
                    uc = Character.valueOf((char)Integer.parseInt(m.group(1), 16));
                    m.appendReplacement(sb, uc.toString());
                }
                catch (NumberFormatException e) {
                    m.appendReplacement(sb, m.group());
                }
            }
            m.appendTail(sb);
            x = sb.toString();
        }
        return x;
    }

    public static String trimToNull(String x) {
        if ((x = StringUtils.trimToNull((String)x)) != null && (x.equals("\\N") || x.equalsIgnoreCase("NULL"))) {
            x = null;
        }
        return x;
    }
}

