/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DwcDateUtil {
    private static final Pattern YEAR_PARSER = Pattern.compile("^([0-9]{4})(?:-[^/]+)?(?:/([0-9]{4})(-[^/]+)?)?$");

    public static YearRange parseDwcDate(String eventDate) {
        Matcher matcher;
        YearRange range = new YearRange();
        if (eventDate != null && (matcher = YEAR_PARSER.matcher(eventDate)).find()) {
            range.startYear = Integer.valueOf(matcher.group(1));
            try {
                range.endYear = Integer.valueOf(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return range;
    }

    public static class YearRange {
        public Integer startYear;
        public Integer endYear;
    }
}

