/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.model;

import com.google.common.base.Objects;
import org.gbif.ecat.model.Identifiable;
import org.gbif.ecat.utils.RankUtil;
import org.gbif.ecat.voc.NameType;
import org.gbif.ecat.voc.NomenclaturalCode;
import org.gbif.ecat.voc.NothoRank;
import org.gbif.ecat.voc.Rank;

public class ParsedName<T>
implements Identifiable<T> {
    private static final long serialVersionUID = 1071086667632376735L;
    public static final Character HYBRID_MARKER = Character.valueOf('\u00d7');
    public T id;
    public boolean authorsParsed = true;
    public NomenclaturalCode code;
    public NameType type;
    public String genusOrAbove;
    public String infraGeneric;
    public String specificEpithet;
    public String infraSpecificEpithet;
    public NothoRank notho;
    public String rank;
    public String authorship;
    public String year;
    public String bracketAuthorship;
    public String bracketYear;
    public String cultivar;
    public String sensu;
    public String nomStatus;
    public String remarks;

    public ParsedName() {
    }

    public ParsedName(T id, NomenclaturalCode code, NameType type, String genusOrAbove, String infraGeneric, String specificEpithet, String infraSpecificEpithet, NothoRank notho, String rank, String authorship, String year, String bracketAuthorship, String bracketYear, String cultivar, String sensu, String nomStatus, String remarks) {
        this.id = id;
        this.code = code;
        this.type = type;
        this.genusOrAbove = genusOrAbove;
        this.infraGeneric = infraGeneric;
        this.specificEpithet = specificEpithet;
        this.infraSpecificEpithet = infraSpecificEpithet;
        this.notho = notho;
        this.rank = rank;
        this.authorship = authorship;
        this.year = year;
        this.bracketAuthorship = bracketAuthorship;
        this.bracketYear = bracketYear;
        this.cultivar = cultivar;
        this.sensu = sensu;
        this.nomStatus = nomStatus;
        this.remarks = remarks;
    }

    public static String decompose(String x) {
        if (x == null) {
            return x;
        }
        return x.replaceAll("\u00e6", "ae").replaceAll("\u00c6", "Ae").replaceAll("\u0153", "oe").replaceAll("\u0152", "Oe").replaceAll("\u0132", "Ij").replaceAll("\u0133", "ij").replaceAll("\u01c8", "Lj").replaceAll("\u01c9", "lj").replaceAll("\u0238", "db").replaceAll("\u0239", "qp").replaceAll("\u00df", "ss").replaceAll("\ufb06", "st").replaceAll("\ufb00", "ff").replaceAll("\ufb01", "fi").replaceAll("\ufb02", "fl").replaceAll("\ufb03", "ffi").replaceAll("\ufb04", "ffl");
    }

    public static void main(String[] args) {
        String test = "\u00e1\u00e9\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153 \u00e4\u00e6\u00c4\u00c6Ae\u00f6\u0153oe\u00d6\u0152Oe\u00fcue\u00dcUe\u0132Ij\u0133ij\u01c8Lj\u01c9lj\u0238db\u0239qp\u00dfss\ufb06st\ufb00ff\ufb01fi\ufb02fl\ufb03ffi\ufb04ffl";
        System.out.println(test);
        System.out.println(ParsedName.decompose(test));
    }

    private void appendAuthorship(StringBuffer sb) {
        if (this.bracketAuthorship != null) {
            sb.append(" (");
            sb.append(this.bracketAuthorship);
            if (this.bracketYear != null) {
                sb.append(", ");
                sb.append(this.bracketYear);
            }
            sb.append(")");
        } else if (this.bracketYear != null) {
            sb.append(" (");
            sb.append(this.bracketYear);
            sb.append(")");
        }
        if (this.authorship != null) {
            sb.append(" ").append(this.authorship);
        }
        if (this.year != null) {
            sb.append(", ");
            sb.append(this.year);
        }
    }

    private void appendIndet(StringBuffer sb) {
        Rank rank = this.getRank();
        sb.append(' ');
        if (rank != null) {
            switch (rank) {
                case SPECIES: {
                    sb.append("spec.");
                    break;
                }
                case SUBSPECIES: {
                    sb.append("ssp.");
                    break;
                }
                case VARIETY: {
                    sb.append("var.");
                    break;
                }
                case Form: {
                    sb.append("f.");
                    break;
                }
                default: {
                    sb.append(rank.name().toLowerCase());
                    break;
                }
            }
        } else {
            sb.append(this.rank);
        }
    }

    public String authorshipComplete() {
        StringBuffer sb = new StringBuffer();
        this.appendAuthorship(sb);
        return sb.toString().trim();
    }

    public String buildName(boolean hybridMarker, boolean rankMarker, boolean authorship, boolean subgenus, boolean abbreviateGenus, boolean decomposition, boolean showIndet, boolean nomNote, boolean remarks, boolean showSensu, boolean showCultivar) {
        StringBuffer sb = new StringBuffer();
        Rank rnk = this.getRank();
        if (this.genusOrAbove != null) {
            if (hybridMarker && NothoRank.Generic == this.notho) {
                sb.append(HYBRID_MARKER);
            }
            if (abbreviateGenus) {
                sb.append(this.genusOrAbove.substring(0, 1)).append('.');
            } else {
                sb.append(this.genusOrAbove);
            }
        }
        if (this.specificEpithet == null) {
            if (Rank.SPECIES == rnk) {
                if (showIndet) {
                    sb.append(" spec.");
                }
            } else if (RankUtil.isLowerRank(rnk, Rank.SPECIES)) {
                if (showIndet) {
                    sb.append(' ');
                    sb.append(rnk.marker);
                }
            } else if (this.infraGeneric != null) {
                if (rankMarker) {
                    if (this.rank != null) {
                        sb.append(' ').append(this.rank);
                    } else {
                        sb.append(' ').append(Rank.SUBGENUS.marker);
                    }
                }
                sb.append(' ').append(this.infraGeneric);
            }
            if (authorship) {
                this.appendAuthorship(sb);
            }
        } else {
            if (subgenus && this.infraGeneric != null && (this.rank == null || this.getRank() == Rank.GENUS)) {
                sb.append(" (");
                sb.append(this.infraGeneric);
                sb.append(')');
            }
            sb.append(' ');
            if (hybridMarker && NothoRank.Specific == this.notho) {
                sb.append(HYBRID_MARKER);
            }
            String epi = this.specificEpithet.replaceAll("[ _-]", "-");
            sb.append(epi);
            if (this.infraSpecificEpithet == null) {
                if (showIndet && RankUtil.isLowerRank(rnk, Rank.SPECIES) && (Rank.Cultivar != rnk || this.cultivar == null)) {
                    sb.append(' ');
                    sb.append(rnk.marker);
                }
                if (authorship) {
                    this.appendAuthorship(sb);
                }
            } else {
                String rm;
                if (authorship && this.isAutonym()) {
                    this.appendAuthorship(sb);
                }
                sb.append(' ');
                if (hybridMarker && NothoRank.Infraspecific == this.notho) {
                    if (rankMarker) {
                        sb.append("notho");
                    } else {
                        sb.append(HYBRID_MARKER);
                    }
                }
                if (rankMarker && (rm = this.getInfraspecificRankMarker()) != null) {
                    sb.append(rm);
                    sb.append(' ');
                }
                epi = this.infraSpecificEpithet.replaceAll("[ _-]", "-");
                sb.append(epi);
                if (authorship && !this.isAutonym()) {
                    this.appendAuthorship(sb);
                }
            }
        }
        if (showCultivar && this.cultivar != null) {
            sb.append(" '");
            sb.append(this.cultivar);
            sb.append("'");
        }
        if (showSensu && this.sensu != null) {
            sb.append(" ");
            sb.append(this.sensu);
        }
        if (nomNote && this.nomStatus != null) {
            sb.append(", ");
            sb.append(this.nomStatus);
        }
        if (remarks && this.remarks != null) {
            sb.append(" [");
            sb.append(this.remarks);
            sb.append("]");
        }
        if (decomposition) {
            return ParsedName.decompose(sb.toString().trim());
        }
        return sb.toString().trim();
    }

    public String canonicalName() {
        return this.buildName(false, false, false, false, false, true, true, false, false, false, false);
    }

    public String canonicalNameWithAuthorship() {
        return this.buildName(true, true, true, true, false, true, true, false, false, false, true);
    }

    public String canonicalNameWithMarker() {
        return this.buildName(true, true, false, false, false, true, true, false, false, false, true);
    }

    public String canonicalSpeciesName() {
        if (this.genusOrAbove != null && this.specificEpithet != null) {
            StringBuilder sb = new StringBuilder();
            if (this.genusOrAbove != null) {
                sb.append(this.genusOrAbove);
            }
            if (this.specificEpithet != null) {
                sb.append(' ');
                sb.append(this.specificEpithet);
            }
            return sb.toString();
        }
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParsedName)) {
            return false;
        }
        ParsedName o = (ParsedName)other;
        return Objects.equal((Object)this.authorship, (Object)o.authorship) && Objects.equal((Object)this.year, (Object)o.year) && Objects.equal((Object)this.bracketAuthorship, (Object)o.bracketAuthorship) && Objects.equal((Object)this.bracketYear, (Object)o.bracketYear) && Objects.equal((Object)this.cultivar, (Object)o.cultivar) && Objects.equal((Object)this.genusOrAbove, (Object)o.genusOrAbove) && Objects.equal((Object)this.infraGeneric, (Object)o.infraGeneric) && Objects.equal((Object)this.specificEpithet, (Object)o.specificEpithet) && Objects.equal((Object)this.infraSpecificEpithet, (Object)o.infraSpecificEpithet) && Objects.equal((Object)this.rank, (Object)o.rank) && Objects.equal((Object)this.code, (Object)o.code) && Objects.equal((Object)((Object)this.type), (Object)((Object)o.type));
    }

    public String fullName() {
        return this.buildName(true, true, true, true, false, false, true, true, true, true, true);
    }

    public String getAuthorship() {
        return this.authorship;
    }

    public String getBracketAuthorship() {
        return this.bracketAuthorship;
    }

    public String getBracketYear() {
        return this.bracketYear;
    }

    public Integer getBracketYearInt() {
        try {
            return Integer.parseInt(this.bracketYear);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public NomenclaturalCode getCode() {
        return this.code;
    }

    public String getCultivar() {
        return this.cultivar;
    }

    public String getGenusOrAbove() {
        return this.genusOrAbove;
    }

    @Override
    public T getId() {
        return this.id;
    }

    public String getInfraGeneric() {
        return this.infraGeneric;
    }

    public String getInfraSpecificEpithet() {
        return this.infraSpecificEpithet;
    }

    protected String getInfraspecificRankMarker() {
        if (this.getRank() == Rank.SUBSPECIES && NomenclaturalCode.Zoological == this.code) {
            return null;
        }
        return this.rank;
    }

    public String getNomStatus() {
        return this.nomStatus;
    }

    public NothoRank getNotho() {
        return this.notho;
    }

    public Rank getRank() {
        Rank rankEnum = Rank.inferRank(this.genusOrAbove, this.infraGeneric, this.specificEpithet, this.rank, this.infraSpecificEpithet);
        return Rank.Unranked == rankEnum ? null : rankEnum;
    }

    public String getRankMarker() {
        return this.rank;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getSensu() {
        return this.sensu;
    }

    public String getSpecificEpithet() {
        return this.specificEpithet;
    }

    public NameType getType() {
        return this.type;
    }

    public String getYear() {
        return this.year;
    }

    public Integer getYearInt() {
        try {
            return Integer.parseInt(this.year);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.genusOrAbove, this.infraGeneric, this.specificEpithet, this.infraSpecificEpithet, this.rank, this.code, this.type, this.authorship, this.year, this.bracketAuthorship, this.bracketYear});
    }

    public boolean isAutonym() {
        return NomenclaturalCode.Botanical == this.code && this.specificEpithet != null && this.infraSpecificEpithet != null && this.specificEpithet.equals(this.infraSpecificEpithet);
    }

    public boolean isBinomial() {
        return this.genusOrAbove != null && this.specificEpithet != null;
    }

    public boolean isHybridFormula() {
        return NameType.hybrid == this.type;
    }

    public boolean isIndetermined() {
        return this.rank != null && this.infraSpecificEpithet == null && (this.specificEpithet != null || this.infraGeneric == null);
    }

    public boolean isParsableType() {
        return this.type != null && this.type.isParsable();
    }

    public boolean isQualified() {
        return this.authorship != null && !this.authorship.isEmpty() || this.year != null && !this.year.isEmpty() || this.bracketAuthorship != null && !this.bracketAuthorship.isEmpty() || this.bracketYear != null && !this.bracketYear.isEmpty();
    }

    public void setAuthorship(String authorship) {
        this.authorship = authorship;
    }

    public void setBracketAuthorship(String bracketAuthorship) {
        this.bracketAuthorship = bracketAuthorship;
    }

    public void setBracketYear(String bracketYear) {
        this.bracketYear = bracketYear;
    }

    public void setCode(NomenclaturalCode code) {
        this.code = code;
    }

    public void setCultivar(String cultivar) {
        this.cultivar = cultivar;
    }

    public void setGenusOrAbove(String genusOrAbove) {
        if (genusOrAbove != null && genusOrAbove.startsWith("\u00d7")) {
            this.genusOrAbove = genusOrAbove.substring(1);
            this.notho = NothoRank.Generic;
        } else {
            this.genusOrAbove = genusOrAbove;
        }
    }

    public void setHybridFormula(boolean hybrid) {
        if (hybrid) {
            this.type = NameType.hybrid;
        } else if (NameType.hybrid == this.type) {
            this.type = null;
        }
    }

    @Override
    public void setId(T id) {
        this.id = id;
    }

    public void setInfraGeneric(String infraGeneric) {
        if (infraGeneric != null && infraGeneric.startsWith("\u00d7")) {
            this.infraGeneric = infraGeneric.substring(1);
            this.notho = NothoRank.Infrageneric;
        } else {
            this.infraGeneric = infraGeneric;
        }
    }

    public void setInfraSpecificEpithet(String infraSpecies) {
        if (infraSpecies != null && infraSpecies.startsWith("\u00d7")) {
            this.infraSpecificEpithet = infraSpecies.substring(1);
            this.notho = NothoRank.Infraspecific;
        } else {
            this.infraSpecificEpithet = infraSpecies;
        }
    }

    @Deprecated
    public void setMonomial(String monomial) {
        this.genusOrAbove = monomial;
    }

    public void setNomStatus(String nomStatus) {
        this.nomStatus = nomStatus;
    }

    public void setNotho(NothoRank notho) {
        this.notho = notho;
    }

    public void setRank(Rank rank) {
        this.rank = rank == null ? null : rank.marker;
    }

    @Deprecated
    public void setRankAndRankMarker(String rankMarker) {
        this.setRankMarker(rankMarker);
    }

    public void setRankMarker(String rankMarker) {
        if (rankMarker == null) {
            this.rank = null;
        } else {
            Rank r;
            if ((rankMarker = rankMarker.trim().toLowerCase()).startsWith("notho")) {
                rankMarker = rankMarker.substring(5);
                this.notho = NothoRank.Infraspecific;
            }
            this.rank = (r = Rank.inferRankMarker(rankMarker)) != null && !Rank.UNCOMPARABLE_RANKS.contains(r) ? r.marker : rankMarker;
        }
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setSensu(String sensu) {
        this.sensu = sensu;
    }

    public void setSpecificEpithet(String species) {
        if (species != null && species.startsWith("\u00d7")) {
            this.specificEpithet = species.substring(1);
            this.notho = NothoRank.Specific;
        } else {
            this.specificEpithet = species;
        }
    }

    public void setType(NameType type) {
        this.type = type;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.id != null) {
            sb.append("{").append(this.id).append("}");
        }
        if (this.genusOrAbove != null) {
            sb.append(" G:").append(this.genusOrAbove);
        }
        if (this.infraGeneric != null) {
            sb.append(" IG:").append(this.infraGeneric);
        }
        if (this.specificEpithet != null) {
            sb.append(" S:").append(this.specificEpithet);
        }
        if (this.rank != null) {
            sb.append(" R:").append(this.rank);
        }
        if (this.infraSpecificEpithet != null) {
            sb.append(" IS:").append(this.infraSpecificEpithet);
        }
        if (this.authorship != null) {
            sb.append(" A:").append(this.authorship);
        }
        if (this.year != null) {
            sb.append(" Y:").append(this.year);
        }
        if (this.bracketAuthorship != null) {
            sb.append(" BA:").append(this.bracketAuthorship);
        }
        if (this.bracketYear != null) {
            sb.append(" BY:").append(this.bracketYear);
        }
        if (this.cultivar != null) {
            sb.append(" CV:").append(this.cultivar);
        }
        if (this.type != null || this.code != null) {
            sb.append(" [");
            if (this.type != null) {
                sb.append((Object)this.type);
            }
            if (this.type != null && this.code != null) {
                sb.append(", ");
            }
            if (this.code != null) {
                sb.append(this.code);
            }
            sb.append("]");
        }
        return this.isHybridFormula() ? " [hybrid]" : sb.toString();
    }
}

