/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.fuzzy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.io.LineIterator;
import org.gbif.ecat.fuzzy.FuzzyNameMatch;
import org.gbif.ecat.fuzzy.FuzzyNameMatcher;
import org.gbif.ecat.fuzzy.FuzzyNameMatcherLucene;
import org.gbif.ecat.fuzzy.FuzzyNameMatcherLuceneCompleteName;
import org.gbif.ecat.utils.StringUtils;

public class FuzzyNameMatcherBenchmark {
    private static final Pattern TAB_DELIMITED = Pattern.compile("\t");
    private final String[] realTestNames = new String[]{"Abies alba", "Chorites", "Acantophora", "Zenionidae", "Chordata", "Danaus plexippus", "Festuca vulgaris", "Puma concolor", "Oenanthe linearis sinensis", "Oenanthe thomsonii"};

    private void benchmarkLuceneStandard(List<FuzzyNameMatch> names, int topDocs, int ... prefixes) {
        long start = System.currentTimeMillis();
        System.out.println("\n\nInitializing new lucene fuzzy matcher with standard analyzer ...");
        FuzzyNameMatcherLucene ml = new FuzzyNameMatcherLucene(names);
        long end = System.currentTimeMillis();
        System.out.println(" Initialized in " + (end - start) + "ms\n");
        for (int p : prefixes) {
            System.out.println(String.format("Benchmarking with prefix=%d, topDocs=%d", p, topDocs));
            ml.setPrefixLength(p);
            ml.setTopDocs(topDocs);
            this.benchmarkOne(ml);
        }
    }

    private void benchmarkLuceneKeyword(List<FuzzyNameMatch> names, int topDocs, int ... prefixes) {
        long start = System.currentTimeMillis();
        System.out.println("\n\nInitializing new lucene fuzzy matcher with keyword analyzer ...");
        FuzzyNameMatcherLuceneCompleteName mlc = new FuzzyNameMatcherLuceneCompleteName(names);
        long end = System.currentTimeMillis();
        System.out.println(" Initialized in " + (end - start) + "ms\n");
        for (int p : prefixes) {
            System.out.println(String.format("Benchmarking with prefix=%d, topDocs=%d", p, topDocs));
            mlc.setPrefixLength(p);
            mlc.setTopDocs(topDocs);
            this.benchmarkOne(mlc);
        }
    }

    private void benchmark(File nubNames) throws IOException {
        int x;
        boolean repeat = true;
        List<FuzzyNameMatch> names = this.readNubNames(nubNames);
        for (x = 0; x < 1; ++x) {
            this.benchmarkLuceneStandard(names, 100, 3, 2, 1);
        }
        for (x = 0; x < 1; ++x) {
            this.benchmarkLuceneStandard(names, 25, 3, 2, 1);
        }
        for (x = 0; x < 1; ++x) {
            this.benchmarkLuceneKeyword(names, 100, 3, 2, 1);
        }
        for (x = 0; x < 1; ++x) {
            this.benchmarkLuceneKeyword(names, 25, 3, 2, 1);
        }
        System.out.println("\n\n\nDONE");
    }

    private void benchmarkOne(FuzzyNameMatcher m) {
        System.out.println(" querying with 10 real names");
        this.benchmarkOneWithTestName(m, this.realTestNames, 100);
        System.out.println(" querying with 1000 random names");
        this.benchmarkOneWithTestName(m, this.randomTestNames(1000), 1);
    }

    private void benchmarkOneWithTestName(FuzzyNameMatcher m, String[] testNames, int loop) {
        List<FuzzyNameMatch> matches;
        int i;
        long start = System.currentTimeMillis();
        int runs = loop * testNames.length;
        for (int i2 = 0; i2 < loop; ++i2) {
            for (String n : testNames) {
                List<FuzzyNameMatch> matches2 = m.straightMatch(n);
                m.straightMatch(n);
            }
        }
        long end = System.currentTimeMillis();
        System.out.println(String.format("  %dx%d straight matches took %dms, average=%d", loop, testNames.length, end - start, (end - start) / (long)runs));
        start = System.currentTimeMillis();
        for (i = 0; i < loop; ++i) {
            for (String n : testNames) {
                matches = m.fuzzyMatch(n, 0.9f);
                m.straightMatch(n);
            }
        }
        end = System.currentTimeMillis();
        System.out.println(String.format("  %dx%d fuzzy 0.9 matches took %dms, average=%d", loop, testNames.length, end - start, (end - start) / (long)runs));
        start = System.currentTimeMillis();
        for (i = 0; i < loop; ++i) {
            for (String n : testNames) {
                matches = m.fuzzyMatch(n, 0.8f);
                m.straightMatch(n);
            }
        }
        end = System.currentTimeMillis();
        System.out.println(String.format("  %dx%d fuzzy 0.8 matches took %dms, average=%d", loop, testNames.length, end - start, (end - start) / (long)runs));
    }

    private List<FuzzyNameMatch> readNubNames(File nubNames) throws IOException {
        System.out.println("Reading nub names from " + nubNames.getAbsolutePath() + " ...");
        FileInputStream source = new FileInputStream(nubNames);
        ArrayList<FuzzyNameMatch> names = new ArrayList<FuzzyNameMatch>();
        LineIterator lines = new LineIterator((Reader)new BufferedReader(new InputStreamReader((InputStream)source, "UTF-8")));
        while (lines.hasNext()) {
            String line = lines.nextLine();
            String[] parts = TAB_DELIMITED.split(line);
            names.add(new FuzzyNameMatch(Integer.parseInt(parts[0]), parts[1]));
        }
        lines.close();
        ((InputStream)source).close();
        System.out.println("Read " + names.size() + " nub names");
        return names;
    }

    public static void main(String[] args) throws IOException {
        FuzzyNameMatcherBenchmark bench = new FuzzyNameMatcherBenchmark();
        bench.benchmark(new File(args[0]));
    }

    private String[] randomTestNames(int number) {
        String[] names = new String[number];
        Random rnd = new Random();
        while (number > 0) {
            String name = StringUtils.randomString(rnd.nextInt(10) + 2);
            if (number % 50 != 0) {
                name = name + " " + StringUtils.randomString(rnd.nextInt(10) + 4);
                if (number % 3 == 0) {
                    name = name + " " + StringUtils.randomString(rnd.nextInt(10) + 4);
                }
            }
            names[number - 1] = name;
            --number;
        }
        return names;
    }
}

