/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class ValidatorFactory {
    public static final String EML_SCHEMA_URL = "https://code.ecoinformatics.org/code/eml/tags/RELEASE_EML_2_1_1/eml.xsd";
    public static final String EML_GBIF_PROFILE_SCHEMA_URL = "http://rs.gbif.org/schema/eml-gbif-profile/1.0.2/eml.xsd";

    public static Validator getEmlValidator() throws MalformedURLException, SAXException {
        return ValidatorFactory.getValidator(EML_SCHEMA_URL);
    }

    public static Validator getGbifValidator() throws MalformedURLException, SAXException {
        return ValidatorFactory.getValidator(EML_GBIF_PROFILE_SCHEMA_URL);
    }

    private static Validator getValidator(String schemaUrl) throws MalformedURLException, SAXException {
        String schemaLang = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
        Schema schema = factory.newSchema(new URL(schemaUrl));
        return schema.newValidator();
    }
}

