/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum StudyAreaDescriptor implements Serializable
{
    THEMATIC("thematic"),
    GEOGRAPHIC("geographic"),
    GENERIC("generic");

    public static final Map<String, String> HTML_SELECT_MAP;
    private final String name;

    public static StudyAreaDescriptor fromString(String studyAreaDescriptor) {
        if (studyAreaDescriptor == null) {
            return null;
        }
        studyAreaDescriptor = studyAreaDescriptor.trim();
        for (StudyAreaDescriptor s : StudyAreaDescriptor.values()) {
            if (!s.name.equalsIgnoreCase(studyAreaDescriptor)) continue;
            return s;
        }
        return null;
    }

    private StudyAreaDescriptor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    static {
        HashMap map = Maps.newHashMap();
        for (StudyAreaDescriptor sad : StudyAreaDescriptor.values()) {
            map.put(sad.name(), "studyAreaDescriptorType." + sad.name());
        }
        HTML_SELECT_MAP = Collections.unmodifiableMap(map);
    }
}

