/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.Objects;
import java.io.Serializable;

public class Point
implements Serializable {
    public static final Double MAX_LONGITUDE = 180.0;
    public static final Double MIN_LONGITUDE = -180.0;
    public static final Double MAX_LATITUDE = 90.0;
    public static final Double MIN_LATITUDE = -90.0;
    private Double longitude;
    private Double latitude;

    public Point() {
    }

    public Point(Point p) {
        this.setLatitude(p.latitude);
        this.setLongitude(p.longitude);
    }

    public Point(Double latitude, Double longitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public int compareTo(Object o) {
        Point other = (Point)o;
        if (this.longitude < other.longitude) {
            return -1;
        }
        if (this.longitude > other.longitude) {
            return 1;
        }
        if (this.latitude < other.latitude) {
            return -1;
        }
        if (this.latitude > other.latitude) {
            return 1;
        }
        return 0;
    }

    public double distance(Point p) {
        return Math.sqrt(this.getX() * this.getX() + this.getY() * this.getY());
    }

    public double distanceX(Point p) {
        return Math.abs(this.getX() - p.getX());
    }

    public double distanceY(Point p) {
        return Math.abs(this.getY() - p.getY());
    }

    public Double getLatitude() {
        return this.latitude == null ? null : this.latitude;
    }

    public Double getLongitude() {
        return this.longitude == null ? null : this.longitude;
    }

    public Double getX() {
        return this.getLongitude();
    }

    public Double getY() {
        return this.getLatitude();
    }

    public boolean isValid() {
        return this.latitude != null && this.longitude != null;
    }

    public void setX(Double x) {
        this.setLongitude(x);
    }

    public void setLongitude(Double longitude) {
        if (longitude != null && (longitude < MIN_LONGITUDE || longitude > MAX_LONGITUDE)) {
            throw new IllegalArgumentException();
        }
        this.longitude = longitude == null ? null : longitude;
    }

    public void setY(Double y) {
        this.setLatitude(y);
    }

    public void setLatitude(Double latitude) {
        if (latitude != null && (latitude < MIN_LATITUDE || latitude > MAX_LATITUDE)) {
            throw new IllegalArgumentException();
        }
        this.latitude = latitude == null ? null : latitude;
    }

    public String toStringShort(int decimals) {
        return String.format("%." + decimals + "f,%." + decimals + "f", this.latitude, this.longitude);
    }

    public String toStringSpace() {
        return String.format("%s %s", this.latitude, this.longitude);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        return Objects.equal((Object)this.longitude, (Object)other.longitude) && Objects.equal((Object)this.latitude, (Object)other.latitude);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.longitude, this.latitude});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("longitude", (Object)this.longitude).add("latitude", (Object)this.latitude).toString();
    }
}

