/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Locale;

public class LocaleBundle
implements Serializable {
    private static final long serialVersionUID = 4602721372582246629L;
    private final Locale locale;
    private final Charset charset;

    public static LocaleBundle create(String language, String country, Charset charset) {
        Preconditions.checkNotNull((Object)language, (Object)"Language was null");
        Preconditions.checkArgument((!language.trim().isEmpty() ? 1 : 0) != 0, (Object)"Language was empty");
        Preconditions.checkNotNull((Object)country, (Object)"Country was null");
        Preconditions.checkArgument((!country.trim().isEmpty() ? 1 : 0) != 0, (Object)"Country was empty");
        Preconditions.checkNotNull((Object)charset, (Object)"Charset was null");
        return new LocaleBundle(language, country, charset);
    }

    private LocaleBundle(String language, String country, Charset charset) {
        this.locale = new Locale(language, country);
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset.displayName();
    }

    public String getCountry() {
        return this.locale.getCountry();
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocaleBundle other = (LocaleBundle)obj;
        return Objects.equal((Object)this.locale, (Object)other.locale) && Objects.equal((Object)this.charset, (Object)other.charset);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.locale, this.charset});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("country", (Object)this.getCountry()).add("language", (Object)this.getLanguage()).add("charset", (Object)this.charset).toString();
    }
}

