/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

public class KeywordSet
implements Serializable {
    private static final long serialVersionUID = -421915165032215809L;
    private String keywordThesaurus;
    private List<String> keywords = Lists.newArrayList();

    public KeywordSet() {
    }

    public KeywordSet(List<String> keywords) {
        this.keywords = keywords;
    }

    public KeywordSet(List<String> keywords, String thesaurus) {
        this.keywords = keywords;
        this.keywordThesaurus = thesaurus;
    }

    public void add(String keyword) {
        this.keywords.add(keyword);
    }

    public String getKeywordThesaurus() {
        return this.keywordThesaurus;
    }

    public void setKeywordThesaurus(String keywordThesaurus) {
        this.keywordThesaurus = keywordThesaurus;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void setKeywordsString(String keywords) {
        this.setKeywordsString(keywords, ",");
    }

    public void setKeywordsString(String keywords, String seperator) {
        this.keywords.clear();
        for (String k : Splitter.on((String)seperator).split((CharSequence)keywords)) {
            k = Strings.emptyToNull((String)k.trim());
            this.keywords.add(k);
        }
    }

    public String getKeywordsString() {
        return this.getKeywordsString(", ");
    }

    public String getKeywordsString(String seperator) {
        StringBuilder sb = new StringBuilder();
        boolean b = false;
        for (String keyword : this.keywords) {
            if (b && seperator != null) {
                sb.append(seperator).append(keyword);
                continue;
            }
            sb.append(keyword);
            b = true;
        }
        return sb.toString();
    }
}

