/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester.Digester;
import org.gbif.metadata.eml.Address;
import org.gbif.metadata.eml.Agent;
import org.gbif.metadata.eml.BBox;
import org.gbif.metadata.eml.BibliographicCitationSet;
import org.gbif.metadata.eml.Eml;
import org.gbif.metadata.eml.GeospatialCoverage;
import org.gbif.metadata.eml.JGTICuratorialUnit;
import org.gbif.metadata.eml.KeywordSet;
import org.gbif.metadata.eml.PhysicalData;
import org.gbif.metadata.eml.Project;
import org.gbif.metadata.eml.StudyAreaDescription;
import org.gbif.metadata.eml.TaxonKeyword;
import org.gbif.metadata.eml.TaxonomicCoverage;
import org.gbif.metadata.eml.TemporalCoverage;
import org.xml.sax.SAXException;

public class EmlFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Eml build(InputStream xml) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        Eml eml = new Eml();
        digester.push(eml);
        digester.addCallMethod("eml", "setMetadataLanguage", 1);
        digester.addCallParam("eml", 0, "xml:lang");
        digester.addCallMethod("eml", "setPackageId", 1);
        digester.addCallParam("eml", 0, "packageId");
        digester.addCallMethod("eml/dataset/alternateIdentifier", "addAlternateIdentifier", 1);
        digester.addCallParam("eml/dataset/alternateIdentifier", 0);
        digester.addCallMethod("eml/dataset/title", "setTitle", 2);
        digester.addCallParam("eml/dataset/title", 0);
        digester.addCallParam("eml/dataset/title", 1, "xml:lang");
        digester.addBeanPropertySetter("eml/dataset/language", "language");
        digester.addBeanPropertySetter("eml/dataset/abstract/para", "abstract");
        digester.addBeanPropertySetter("eml/dataset/additionalInfo/para", "additionalInfo");
        digester.addBeanPropertySetter("eml/dataset/intellectualRights/para", "intellectualRights");
        digester.addCallMethod("eml/dataset/methods/methodStep/description/para", "addMethodStep", 1);
        digester.addCallParam("eml/dataset/methods/methodStep/description/para", 0);
        digester.addBeanPropertySetter("eml/dataset/methods/sampling/studyExtent/description/para", "studyExtent");
        digester.addBeanPropertySetter("eml/dataset/methods/sampling/samplingDescription/para", "sampleDescription");
        digester.addBeanPropertySetter("eml/dataset/methods/qualityControl/description/para", "qualityControl");
        digester.addBeanPropertySetter("eml/dataset/distribution/online/url", "distributionUrl");
        digester.addBeanPropertySetter("eml/dataset/purpose/para", "purpose");
        digester.addCallMethod("eml/additionalMetadata/metadata/gbif/citation", "setCitation", 2);
        digester.addCallParam("eml/additionalMetadata/metadata/gbif/citation", 0);
        digester.addCallParam("eml/additionalMetadata/metadata/gbif/citation", 1, "identifier");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/specimenPreservationMethod", "specimenPreservationMethod");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/resourceLogoUrl", "logoUrl");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/hierarchyLevel", "hierarchyLevel");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/collection/parentCollectionIdentifier", "parentCollectionId");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/collection/collectionIdentifier", "collectionId");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/collection/collectionName", "collectionName");
        digester.addCallMethod("eml/dataset/pubDate", "setPubDateAsString", 1);
        digester.addCallParam("eml/dataset/pubDate", 0);
        digester.addCallMethod("eml/additionalMetadata/metadata/gbif/dateStamp", "setDateStamp", 1);
        digester.addCallParam("eml/additionalMetadata/metadata/gbif/dateStamp", 0);
        EmlFactory.addAgentRules(digester, "eml/dataset/creator", "setResourceCreator");
        EmlFactory.addAgentRules(digester, "eml/dataset/metadataProvider", "setMetadataProvider");
        EmlFactory.addAgentRules(digester, "eml/dataset/contact", "setContact");
        EmlFactory.addAgentRules(digester, "eml/dataset/associatedParty", "addAssociatedParty");
        EmlFactory.addKeywordRules(digester);
        EmlFactory.addBibliographicCitations(digester);
        EmlFactory.addGeographicCoverageRules(digester);
        EmlFactory.addTemporalCoverageRules(digester);
        EmlFactory.addLivingTimePeriodRules(digester);
        EmlFactory.addFormationPeriodRules(digester);
        EmlFactory.addTaxonomicCoverageRules(digester);
        EmlFactory.addProjectRules(digester);
        EmlFactory.addPhysicalDataRules(digester);
        EmlFactory.addJGTICuratorialIUnit(digester);
        try {
            digester.parse(xml);
        }
        finally {
            xml.close();
        }
        return eml;
    }

    private static void addAgentRules(Digester digester, String prefix, String parentMethod) {
        digester.addObjectCreate(prefix, Agent.class);
        digester.addBeanPropertySetter(prefix + "/individualName/givenName", "firstName");
        digester.addBeanPropertySetter(prefix + "/individualName/surName", "lastName");
        digester.addBeanPropertySetter(prefix + "/organizationName", "organisation");
        digester.addBeanPropertySetter(prefix + "/positionName", "position");
        digester.addBeanPropertySetter(prefix + "/phone", "phone");
        digester.addBeanPropertySetter(prefix + "/electronicMailAddress", "email");
        digester.addBeanPropertySetter(prefix + "/onlineUrl", "homepage");
        digester.addBeanPropertySetter(prefix + "/role", "role");
        digester.addObjectCreate(prefix + "/address", Address.class);
        digester.addBeanPropertySetter(prefix + "/address/city", "city");
        digester.addBeanPropertySetter(prefix + "/address/administrativeArea", "province");
        digester.addBeanPropertySetter(prefix + "/address/postalCode", "postalCode");
        digester.addBeanPropertySetter(prefix + "/address/country", "country");
        digester.addBeanPropertySetter(prefix + "/address/deliveryPoint", "address");
        digester.addSetNext(prefix + "/address", "setAddress");
        digester.addSetNext(prefix, parentMethod);
    }

    private static void addKeywordRules(Digester digester) {
        digester.addObjectCreate("eml/dataset/keywordSet", KeywordSet.class);
        digester.addCallMethod("eml/dataset/keywordSet/keyword", "add", 1);
        digester.addCallParam("eml/dataset/keywordSet/keyword", 0);
        digester.addBeanPropertySetter("eml/dataset/keywordSet/keywordThesaurus", "keywordThesaurus");
        digester.addSetNext("eml/dataset/keywordSet", "addKeywordSet");
    }

    private static void addBibliographicCitations(Digester digester) {
        digester.addObjectCreate("eml/additionalMetadata/metadata/gbif/bibliography", BibliographicCitationSet.class);
        digester.addCallMethod("eml/additionalMetadata/metadata/gbif/bibliography/citation", "add", 2);
        digester.addCallParam("eml/additionalMetadata/metadata/gbif/bibliography/citation", 0);
        digester.addCallParam("eml/additionalMetadata/metadata/gbif/bibliography/citation", 1, "identifier");
        digester.addSetNext("eml/additionalMetadata/metadata/gbif/bibliography", "setBibliographicCitationSet");
    }

    private static void addGeographicCoverageRules(Digester digester) {
        digester.addObjectCreate("eml/dataset/coverage/geographicCoverage", GeospatialCoverage.class);
        digester.addBeanPropertySetter("eml/dataset/coverage/geographicCoverage/geographicDescription", "description");
        digester.addObjectCreate("eml/dataset/coverage/geographicCoverage/boundingCoordinates", BBox.class);
        digester.addBeanPropertySetter("eml/dataset/coverage/geographicCoverage/boundingCoordinates/westBoundingCoordinate", "minX");
        digester.addBeanPropertySetter("eml/dataset/coverage/geographicCoverage/boundingCoordinates/eastBoundingCoordinate", "maxX");
        digester.addBeanPropertySetter("eml/dataset/coverage/geographicCoverage/boundingCoordinates/northBoundingCoordinate", "maxY");
        digester.addBeanPropertySetter("eml/dataset/coverage/geographicCoverage/boundingCoordinates/southBoundingCoordinate", "minY");
        digester.addSetNext("eml/dataset/coverage/geographicCoverage/boundingCoordinates", "setBoundingCoordinates");
        digester.addSetNext("eml/dataset/coverage/geographicCoverage", "addGeospatialCoverage");
    }

    private static void addTemporalCoverageRules(Digester digester) {
        digester.addObjectCreate("eml/dataset/coverage/temporalCoverage", TemporalCoverage.class);
        digester.addCallMethod("eml/dataset/coverage/temporalCoverage/singleDateTime/calendarDate", "setStart", 1);
        digester.addCallParam("eml/dataset/coverage/temporalCoverage/singleDateTime/calendarDate", 0);
        digester.addCallMethod("eml/dataset/coverage/temporalCoverage/singleDateTime/calendarDate", "setEnd", 1);
        digester.addCallParam("eml/dataset/coverage/temporalCoverage/singleDateTime/calendarDate", 0);
        digester.addCallMethod("eml/dataset/coverage/temporalCoverage/rangeOfDates/beginDate/calendarDate", "setStart", 1);
        digester.addCallParam("eml/dataset/coverage/temporalCoverage/rangeOfDates/beginDate/calendarDate", 0);
        digester.addCallMethod("eml/dataset/coverage/temporalCoverage/rangeOfDates/endDate/calendarDate", "setEnd", 1);
        digester.addCallParam("eml/dataset/coverage/temporalCoverage/rangeOfDates/endDate/calendarDate", 0);
        digester.addSetNext("eml/dataset/coverage/temporalCoverage", "addTemporalCoverage");
    }

    private static void addLivingTimePeriodRules(Digester digester) {
        digester.addObjectCreate("eml/additionalMetadata/metadata/gbif/livingTimePeriod", TemporalCoverage.class);
        digester.addCallMethod("eml/additionalMetadata/metadata/gbif/livingTimePeriod", "setLivingTimePeriod", 1);
        digester.addCallParam("eml/additionalMetadata/metadata/gbif/livingTimePeriod", 0);
        digester.addSetNext("eml/additionalMetadata/metadata/gbif/livingTimePeriod", "addTemporalCoverage");
    }

    private static void addFormationPeriodRules(Digester digester) {
        digester.addObjectCreate("eml/additionalMetadata/metadata/gbif/formationPeriod", TemporalCoverage.class);
        digester.addCallMethod("eml/additionalMetadata/metadata/gbif/formationPeriod", "setFormationPeriod", 1);
        digester.addCallParam("eml/additionalMetadata/metadata/gbif/formationPeriod", 0);
        digester.addSetNext("eml/additionalMetadata/metadata/gbif/formationPeriod", "addTemporalCoverage");
    }

    private static void addTaxonomicCoverageRules(Digester digester) {
        digester.addObjectCreate("eml/dataset/coverage/taxonomicCoverage", TaxonomicCoverage.class);
        digester.addBeanPropertySetter("eml/dataset/coverage/taxonomicCoverage/generalTaxonomicCoverage", "description");
        digester.addObjectCreate("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification", TaxonKeyword.class);
        digester.addBeanPropertySetter("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification/taxonRankName", "rank");
        digester.addBeanPropertySetter("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification/taxonRankValue", "scientificName");
        digester.addBeanPropertySetter("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification/commonName", "commonName");
        digester.addSetNext("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification", "addTaxonKeyword");
        digester.addSetNext("eml/dataset/coverage/taxonomicCoverage", "addTaxonomicCoverage");
    }

    private static void addProjectRules(Digester digester) {
        digester.addObjectCreate("eml/dataset/project", Project.class);
        digester.addBeanPropertySetter("eml/dataset/project/title", "title");
        EmlFactory.addAgentRules(digester, "eml/dataset/project/personnel", "setPersonnel");
        digester.addBeanPropertySetter("eml/dataset/project/funding/para", "funding");
        EmlFactory.addStudyAreaDescriptionRules(digester);
        digester.addBeanPropertySetter("eml/dataset/project/designDescription/description/para", "designDescription");
        digester.addSetNext("eml/dataset/project", "setProject");
    }

    private static void addStudyAreaDescriptionRules(Digester digester) {
        digester.addObjectCreate("eml/dataset/project/studyAreaDescription", StudyAreaDescription.class);
        digester.addCallMethod("eml/dataset/project/studyAreaDescription/descriptor", "setName", 1);
        digester.addCallParam("eml/dataset/project/studyAreaDescription/descriptor", 0, "name");
        digester.addCallMethod("eml/dataset/project/studyAreaDescription/descriptor", "setCitableClassificationSystem", 1);
        digester.addCallParam("eml/dataset/project/studyAreaDescription/descriptor", 0, "citableClassificationSystem");
        digester.addBeanPropertySetter("eml/dataset/project/studyAreaDescription/descriptor/descriptorValue", "descriptorValue");
        digester.addSetNext("eml/dataset/project/studyAreaDescription", "setStudyAreaDescription");
    }

    private static void addPhysicalDataRules(Digester digester) {
        digester.addObjectCreate("eml/additionalMetadata/metadata/gbif/physical", PhysicalData.class);
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/physical/objectName", "name");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/physical/characterEncoding", "charset");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/physical/dataFormat/externallyDefinedFormat/formatName", "format");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/physical/dataFormat/externallyDefinedFormat/formatVersion", "formatVersion");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/physical/distribution/online/url", "distributionUrl");
        digester.addSetNext("eml/additionalMetadata/metadata/gbif/physical", "addPhysicalData");
    }

    private static void addJGTICuratorialIUnit(Digester digester) {
        digester.addObjectCreate("eml/additionalMetadata/metadata/gbif/jgtiCuratorialUnit", JGTICuratorialUnit.class);
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/jgtiCuratorialUnit/jgtiUnitType", "unitType");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/jgtiCuratorialUnit/jgtiUnitRange/beginRange", "rangeStart");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/jgtiCuratorialUnit/jgtiUnitRange/endRange", "rangeEnd");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/jgtiCuratorialUnit/jgtiUnits", "rangeMean");
        digester.addSetProperties("eml/additionalMetadata/metadata/gbif/jgtiCuratorialUnit/jgtiUnits");
        digester.addSetNext("eml/additionalMetadata/metadata/gbif/jgtiCuratorialUnit", "addJgtiCuratorialUnit");
    }
}

