/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gbif.metadata.BasicMetadata;
import org.gbif.metadata.DateUtils;
import org.gbif.metadata.eml.Agent;
import org.gbif.metadata.eml.BibliographicCitationSet;
import org.gbif.metadata.eml.Citation;
import org.gbif.metadata.eml.GeospatialCoverage;
import org.gbif.metadata.eml.JGTICuratorialUnit;
import org.gbif.metadata.eml.KeywordSet;
import org.gbif.metadata.eml.LocaleBundle;
import org.gbif.metadata.eml.PhysicalData;
import org.gbif.metadata.eml.Project;
import org.gbif.metadata.eml.TaxonomicCoverage;
import org.gbif.metadata.eml.TemporalCoverage;

public class Eml
implements Serializable,
BasicMetadata {
    private static final Pattern PACKAGED_ID_PATTERN = Pattern.compile("/v([0-9]+)$");
    private static final Joiner JOINER = Joiner.on((String)"; ").useForNull("");
    private static final Splitter SEMICOLON_SPLITTER = Splitter.on((char)';');
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter PIPE_SPLITTER = Splitter.on((char)'|');
    private static final long serialVersionUID = 770733523572837495L;
    private String description;
    private String additionalInfo;
    private List<String> alternateIdentifiers = Lists.newArrayList();
    private List<Agent> associatedParties = Lists.newArrayList();
    private BibliographicCitationSet bibliographicCitationSet = new BibliographicCitationSet();
    private Citation citation;
    private String collectionId;
    private String collectionName;
    private Agent contact = new Agent();
    private Date dateStamp = new Date();
    private String distributionUrl;
    private int emlVersion = 0;
    private List<GeospatialCoverage> geospatialCoverages = Lists.newArrayList();
    private String hierarchyLevel = "dataset";
    private String intellectualRights;
    private List<JGTICuratorialUnit> jgtiCuratorialUnits = Lists.newArrayList();
    private List<KeywordSet> keywords = Lists.newArrayList();
    private String language = "en";
    private String logoUrl;
    private String metadataLanguage = "en";
    private LocaleBundle metadataLocale;
    private Agent metadataProvider = new Agent();
    private String parentCollectionId;
    private List<PhysicalData> physicalData = Lists.newArrayList();
    private Project project = new Project();
    private Date pubDate;
    private String purpose;
    private Agent resourceCreator = new Agent();
    private String specimenPreservationMethod;
    private List<TaxonomicCoverage> taxonomicCoverages = Lists.newArrayList();
    private List<TemporalCoverage> temporalCoverages = Lists.newArrayList();
    private String link;
    private String guid;
    private String title;
    private String studyExtent;
    private String sampleDescription;
    private String qualityControl;
    private List<String> methodSteps = Lists.newArrayList();

    public Eml() {
        this.pubDate = new Date();
        this.resourceCreator.setRole("Originator");
        this.metadataProvider.setRole("MetadataProvider");
        this.contact.setRole("PointOfContact");
    }

    public String getAdditionalInfo() {
        if (this.additionalInfo == null || this.additionalInfo.isEmpty()) {
            return null;
        }
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public List<String> getAlternateIdentifiers() {
        return this.alternateIdentifiers;
    }

    public void setAlternateIdentifiers(List<String> alternateIdentifiers) {
        this.alternateIdentifiers = alternateIdentifiers;
    }

    public List<Agent> getAssociatedParties() {
        return this.associatedParties;
    }

    public void setAssociatedParties(List<Agent> associatedParties) {
        this.associatedParties = associatedParties;
    }

    public BibliographicCitationSet getBibliographicCitationSet() {
        return this.bibliographicCitationSet;
    }

    public void setBibliographicCitationSet(BibliographicCitationSet val) {
        this.bibliographicCitationSet = val;
    }

    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation citation) {
        this.citation = citation;
    }

    public String getCollectionId() {
        if (this.collectionId == null || this.collectionId.isEmpty()) {
            return null;
        }
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public String getCollectionName() {
        if (this.collectionName == null || this.collectionName.isEmpty()) {
            return null;
        }
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public Agent getContact() {
        return this.contact;
    }

    public void setContact(Agent contact) {
        this.contact = contact;
    }

    private Agent getCreator() {
        Agent creator = this.getResourceCreator();
        if (creator == null) {
            creator = this.getContact();
        }
        return creator;
    }

    public Date getDateStamp() {
        return this.dateStamp;
    }

    public void setDateStamp(Date dateStamp) {
        this.dateStamp = dateStamp;
    }

    public void setDateStamp(String dateString) throws ParseException {
        this.dateStamp = DateUtils.schemaDateTime(dateString);
    }

    public String getDistributionUrl() {
        if (this.distributionUrl == null || this.distributionUrl.isEmpty()) {
            return null;
        }
        return this.distributionUrl;
    }

    public void setDistributionUrl(String distributionUrl) {
        this.distributionUrl = distributionUrl;
    }

    public int getEmlVersion() {
        return this.emlVersion;
    }

    public void setEmlVersion(int emlVersion) {
        this.emlVersion = emlVersion;
    }

    public List<GeospatialCoverage> getGeospatialCoverages() {
        return this.geospatialCoverages;
    }

    public void setGeospatialCoverages(List<GeospatialCoverage> geospatialCoverages) {
        this.geospatialCoverages = geospatialCoverages;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getHierarchyLevel() {
        if (this.hierarchyLevel == null || this.hierarchyLevel.isEmpty()) {
            return null;
        }
        return this.hierarchyLevel;
    }

    public void setHierarchyLevel(String hierarchyLevel) {
        this.hierarchyLevel = hierarchyLevel;
    }

    public String getIntellectualRights() {
        if (this.intellectualRights == null || this.intellectualRights.isEmpty()) {
            return null;
        }
        return this.intellectualRights;
    }

    public void setIntellectualRights(String intellectualRights) {
        this.intellectualRights = intellectualRights;
    }

    public List<JGTICuratorialUnit> getJgtiCuratorialUnits() {
        return this.jgtiCuratorialUnits;
    }

    public void setJgtiCuratorialUnits(List<JGTICuratorialUnit> jgtiCuratorialUnit) {
        this.jgtiCuratorialUnits = jgtiCuratorialUnit;
    }

    public List<KeywordSet> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<KeywordSet> keywords) {
        this.keywords = keywords;
    }

    public String getLanguage() {
        if (this.language == null || this.language.isEmpty()) {
            return null;
        }
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public String getLogoUrl() {
        if (this.logoUrl == null || this.logoUrl.isEmpty()) {
            return null;
        }
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getMetadataLanguage() {
        if (this.metadataLanguage == null || this.metadataLanguage.isEmpty()) {
            return null;
        }
        return this.metadataLanguage;
    }

    public void setMetadataLanguage(String language) {
        this.metadataLanguage = language;
    }

    public LocaleBundle getMetadataLocale() {
        return this.metadataLocale;
    }

    public void setMetadataLocale(LocaleBundle metadataLocale) {
        this.metadataLocale = metadataLocale;
    }

    public Agent getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(Agent metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public List<String> getMethodSteps() {
        return this.methodSteps;
    }

    public void setMethodSteps(List<String> methodSteps) {
        this.methodSteps = methodSteps;
    }

    public String getParentCollectionId() {
        if (this.parentCollectionId == null || this.parentCollectionId.isEmpty()) {
            return null;
        }
        return this.parentCollectionId;
    }

    public void setParentCollectionId(String parentCollectionId) {
        this.parentCollectionId = parentCollectionId;
    }

    public List<PhysicalData> getPhysicalData() {
        return this.physicalData;
    }

    public void setPhysicalData(List<PhysicalData> physicalData) {
        this.physicalData = physicalData;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Date getPubDate() {
        return this.pubDate;
    }

    public void setPubDate(Date pubDate) {
        this.pubDate = pubDate;
    }

    public String getPurpose() {
        if (this.purpose == null || this.purpose.isEmpty()) {
            return null;
        }
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getQualityControl() {
        return this.qualityControl;
    }

    public void setQualityControl(String qualityControl) {
        this.qualityControl = qualityControl;
    }

    public Agent getResourceCreator() {
        return this.resourceCreator;
    }

    public void setResourceCreator(Agent resourceCreator) {
        this.resourceCreator = resourceCreator;
    }

    public String getSampleDescription() {
        return this.sampleDescription;
    }

    public void setSampleDescription(String sampleDescription) {
        this.sampleDescription = sampleDescription;
    }

    public String getSpecimenPreservationMethod() {
        if (this.specimenPreservationMethod == null || this.specimenPreservationMethod.isEmpty()) {
            return null;
        }
        return this.specimenPreservationMethod;
    }

    public void setSpecimenPreservationMethod(String specimenPreservationMethod) {
        this.specimenPreservationMethod = specimenPreservationMethod;
    }

    public String getStudyExtent() {
        return this.studyExtent;
    }

    public void setStudyExtent(String studyExtent) {
        this.studyExtent = studyExtent;
    }

    public List<TaxonomicCoverage> getTaxonomicCoverages() {
        return this.taxonomicCoverages;
    }

    public void setTaxonomicCoverages(List<TaxonomicCoverage> taxonomicCoverages) {
        this.taxonomicCoverages = taxonomicCoverages;
    }

    public List<TemporalCoverage> getTemporalCoverages() {
        return this.temporalCoverages;
    }

    public void setTemporalCoverages(List<TemporalCoverage> temporalCoverages) {
        this.temporalCoverages = temporalCoverages;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getCitationString() {
        if (this.citation != null) {
            return this.citation.getCitation();
        }
        return null;
    }

    @Override
    public String getCreatorEmail() {
        Agent creator = this.getCreator();
        if (creator != null) {
            return creator.getEmail();
        }
        return null;
    }

    @Override
    public String getCreatorName() {
        Agent creator = this.getCreator();
        if (creator != null) {
            return creator.getFullName();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.getAbstract();
    }

    @Override
    public String getHomepageUrl() {
        return this.resourceCreator.getHomepage();
    }

    @Override
    public String getIdentifier() {
        return this.guid;
    }

    @Override
    public Date getPublished() {
        return this.pubDate;
    }

    @Override
    public String getPublisherEmail() {
        Agent creator = this.metadataProvider;
        if (creator != null) {
            return creator.getEmail();
        }
        return null;
    }

    @Override
    public String getPublisherName() {
        Agent creator = this.metadataProvider;
        if (creator != null) {
            return creator.getFullName();
        }
        return null;
    }

    @Override
    public String getRights() {
        return this.intellectualRights;
    }

    @Override
    public String getSubject() {
        ArrayList<String> subjects = new ArrayList<String>();
        for (KeywordSet ks : this.keywords) {
            subjects.add(JOINER.join(ks.getKeywords()));
        }
        return JOINER.join(subjects);
    }

    public void addAlternateIdentifier(String alternateIdentifier) {
        this.alternateIdentifiers.add(alternateIdentifier);
    }

    public void addAssociatedParty(Agent agent) {
        if (agent.getRole() == null) {
            agent.setRole("AssociatedParty");
        }
        this.associatedParties.add(agent);
    }

    public void addBibliographicCitations(List<Citation> citations) {
        this.bibliographicCitationSet.getBibliographicCitations().addAll(citations);
    }

    public void addGeospatialCoverage(GeospatialCoverage geospatialCoverage) {
        this.geospatialCoverages.add(geospatialCoverage);
    }

    public void addJgtiCuratorialUnit(JGTICuratorialUnit unit) {
        this.jgtiCuratorialUnits.add(unit);
    }

    public void addKeywordSet(KeywordSet keywordSet) {
        this.keywords.add(keywordSet);
    }

    public void addMethodStep(String step) {
        this.methodSteps.add(step);
    }

    public void addPhysicalData(PhysicalData physicalData) {
        this.physicalData.add(physicalData);
    }

    public void addTaxonomicCoverage(TaxonomicCoverage coverage) {
        this.taxonomicCoverages.add(coverage);
    }

    public void addTemporalCoverage(TemporalCoverage coverage) {
        this.temporalCoverages.add(coverage);
    }

    public String getAbstract() {
        return this.description;
    }

    public List<Citation> getBibliographicCitations() {
        return this.bibliographicCitationSet.getBibliographicCitations();
    }

    public String getPackageId() {
        return this.guid + "/v" + this.emlVersion;
    }

    public int increaseEmlVersion() {
        ++this.emlVersion;
        return this.emlVersion;
    }

    public Agent resourceCreator() {
        return this.resourceCreator;
    }

    public void setAbstract(String description) {
        this.description = description;
    }

    public void setBibliographicCitations(List<Citation> val) {
        this.bibliographicCitationSet.setBibliographicCitations(val);
    }

    public void setCitation(String citation, String identifier) {
        this.citation = new Citation(citation, identifier);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHomepageUrl(String homepageUrl) {
        this.resourceCreator.setHomepage(homepageUrl);
    }

    public void setKeywordSet(List<KeywordSet> keywords) {
        this.keywords = keywords;
    }

    public void setPackageId(String packageId) {
        Matcher m = PACKAGED_ID_PATTERN.matcher(packageId);
        if (m.find()) {
            this.emlVersion = Integer.valueOf(m.group(1));
            packageId = m.replaceAll("");
        }
        this.guid = packageId;
    }

    public void setPubDateAsString(String dateString) throws ParseException {
        this.pubDate = DateUtils.calendarDate(dateString);
    }

    public void setPublished(Date published) {
        this.pubDate = published;
    }

    public void setSubject(List<String> keywords) {
        KeywordSet ks = new KeywordSet(keywords);
        ArrayList<KeywordSet> list = new ArrayList<KeywordSet>();
        list.add(ks);
        this.keywords = list;
    }

    public void setSubject(String keywords) {
        if (keywords != null) {
            int commas = CharMatcher.is((char)',').countIn((CharSequence)keywords);
            int semicolon = CharMatcher.is((char)';').countIn((CharSequence)keywords);
            int pipes = CharMatcher.is((char)'|').countIn((CharSequence)keywords);
            Iterable tokens = semicolon >= commas && semicolon >= pipes ? SEMICOLON_SPLITTER.split((CharSequence)keywords) : (pipes >= semicolon && pipes >= commas ? PIPE_SPLITTER.split((CharSequence)keywords) : COMMA_SPLITTER.split((CharSequence)keywords));
            ArrayList<String> keyList = new ArrayList<String>();
            for (String kw : tokens) {
                String k = Strings.emptyToNull((String)kw.trim());
                keyList.add(k);
            }
            this.setSubject(keyList);
        }
    }

    public void setTitle(String title, String language) {
        if (this.title == null || "en".equalsIgnoreCase(language) || "eng".equalsIgnoreCase(language)) {
            this.title = title;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Eml other = (Eml)obj;
        return Objects.equal((Object)this.description, (Object)other.description) && Objects.equal((Object)this.additionalInfo, (Object)other.additionalInfo) && Objects.equal(this.alternateIdentifiers, other.alternateIdentifiers) && Objects.equal(this.associatedParties, other.associatedParties) && Objects.equal((Object)this.bibliographicCitationSet, (Object)other.bibliographicCitationSet) && Objects.equal((Object)this.citation, (Object)other.citation) && Objects.equal((Object)this.collectionId, (Object)other.collectionId) && Objects.equal((Object)this.collectionName, (Object)other.collectionName) && Objects.equal((Object)this.contact, (Object)other.contact) && Objects.equal((Object)this.dateStamp, (Object)other.dateStamp) && Objects.equal((Object)this.distributionUrl, (Object)other.distributionUrl) && Objects.equal((Object)this.emlVersion, (Object)other.emlVersion) && Objects.equal(this.geospatialCoverages, other.geospatialCoverages) && Objects.equal((Object)this.hierarchyLevel, (Object)other.hierarchyLevel) && Objects.equal((Object)this.intellectualRights, (Object)other.intellectualRights) && Objects.equal(this.jgtiCuratorialUnits, other.jgtiCuratorialUnits) && Objects.equal(this.keywords, other.keywords) && Objects.equal((Object)this.language, (Object)other.language) && Objects.equal((Object)this.logoUrl, (Object)other.logoUrl) && Objects.equal((Object)this.metadataLanguage, (Object)other.metadataLanguage) && Objects.equal((Object)this.metadataLocale, (Object)other.metadataLocale) && Objects.equal((Object)this.metadataProvider, (Object)other.metadataProvider) && Objects.equal((Object)this.parentCollectionId, (Object)other.parentCollectionId) && Objects.equal(this.physicalData, other.physicalData) && Objects.equal((Object)this.project, (Object)other.project) && Objects.equal((Object)this.pubDate, (Object)other.pubDate) && Objects.equal((Object)this.purpose, (Object)other.purpose) && Objects.equal((Object)this.resourceCreator, (Object)other.resourceCreator) && Objects.equal((Object)this.specimenPreservationMethod, (Object)other.specimenPreservationMethod) && Objects.equal(this.taxonomicCoverages, other.taxonomicCoverages) && Objects.equal(this.temporalCoverages, other.temporalCoverages) && Objects.equal((Object)this.link, (Object)other.link) && Objects.equal((Object)this.guid, (Object)other.guid) && Objects.equal((Object)this.title, (Object)other.title) && Objects.equal((Object)this.studyExtent, (Object)other.studyExtent) && Objects.equal((Object)this.sampleDescription, (Object)other.sampleDescription) && Objects.equal((Object)this.qualityControl, (Object)other.qualityControl) && Objects.equal(this.methodSteps, other.methodSteps);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description, this.additionalInfo, this.alternateIdentifiers, this.associatedParties, this.bibliographicCitationSet, this.citation, this.collectionId, this.collectionName, this.contact, this.dateStamp, this.distributionUrl, this.emlVersion, this.geospatialCoverages, this.hierarchyLevel, this.intellectualRights, this.jgtiCuratorialUnits, this.keywords, this.language, this.logoUrl, this.metadataLanguage, this.metadataLocale, this.metadataProvider, this.parentCollectionId, this.physicalData, this.project, this.pubDate, this.purpose, this.resourceCreator, this.specimenPreservationMethod, this.taxonomicCoverages, this.temporalCoverages, this.link, this.guid, this.title, this.studyExtent, this.sampleDescription, this.qualityControl, this.methodSteps});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("description", (Object)this.description).add("additionalInfo", (Object)this.additionalInfo).add("alternateIdentifiers", this.alternateIdentifiers).add("associatedParties", this.associatedParties).add("bibliographicCitationSet", (Object)this.bibliographicCitationSet).add("citation", (Object)this.citation).add("collectionId", (Object)this.collectionId).add("collectionName", (Object)this.collectionName).add("contact", (Object)this.contact).add("dateStamp", (Object)this.dateStamp).add("distributionUrl", (Object)this.distributionUrl).add("emlVersion", this.emlVersion).add("geospatialCoverages", this.geospatialCoverages).add("hierarchyLevel", (Object)this.hierarchyLevel).add("intellectualRights", (Object)this.intellectualRights).add("jgtiCuratorialUnits", this.jgtiCuratorialUnits).add("keywords", this.keywords).add("language", (Object)this.language).add("logoUrl", (Object)this.logoUrl).add("metadataLanguage", (Object)this.metadataLanguage).add("metadataLocale", (Object)this.metadataLocale).add("metadataProvider", (Object)this.metadataProvider).add("parentCollectionId", (Object)this.parentCollectionId).add("physicalData", this.physicalData).add("project", (Object)this.project).add("pubDate", (Object)this.pubDate).add("purpose", (Object)this.purpose).add("resourceCreator", (Object)this.resourceCreator).add("specimenPreservationMethod", (Object)this.specimenPreservationMethod).add("taxonomicCoverages", this.taxonomicCoverages).add("temporalCoverages", this.temporalCoverages).add("link", (Object)this.link).add("guid", (Object)this.guid).add("title", (Object)this.title).add("studyExtent", (Object)this.studyExtent).add("sampleDescription", (Object)this.sampleDescription).add("qualityControl", (Object)this.qualityControl).add("methodSteps", this.methodSteps).toString();
    }
}

