/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Arrays;
import org.gbif.metadata.eml.Point;

public class BBox
implements Serializable {
    private Point max;
    private Point min;

    public static BBox newWorldInstance() {
        return new BBox(new Point(-90.0, -180.0), new Point(90.0, 180.0));
    }

    public BBox() {
        this(-90.0, -180.0, 90.0, 180.0);
    }

    public BBox(Point min, Point max) {
        this.min = new Point(min);
        this.max = new Point(max);
        this.setOrderedBounds(min.getLatitude(), min.getLongitude(), max.getLatitude(), max.getLongitude());
    }

    public BBox(Double minY, Double minX, Double maxY, Double maxX) {
        minY = minY == null ? -90.0 : minY;
        minX = minX == null ? -180.0 : minX;
        maxY = maxY == null ? 90.0 : maxY;
        maxX = maxX == null ? 180.0 : maxX;
        this.min = new Point(minY, minX);
        this.max = new Point(maxY, maxX);
        this.setOrderedBounds(minY, minX, maxY, maxX);
    }

    public Point getMax() {
        return this.max;
    }

    public Point getMin() {
        return this.min;
    }

    public Point centre() {
        if (this.max == null || this.min == null) {
            return null;
        }
        return new Point(this.min.getLatitude() + this.height() / 2.0, this.min.getLongitude() + this.width() / 2.0);
    }

    public boolean contains(Point p) {
        return p != null && p.isValid() && this.isValid() && p.getLatitude() <= this.max.getLatitude() && p.getLatitude() >= this.min.getLatitude() && p.getLongitude() <= this.max.getLongitude() && p.getLongitude() >= this.min.getLongitude();
    }

    public void expandBox(Point p) {
        if (p != null && p.isValid() && !this.contains(p)) {
            if (this.isValid()) {
                if (p.getLatitude() > this.max.getLatitude()) {
                    this.max.setLatitude(p.getLatitude());
                }
                if (p.getLatitude() < this.min.getLatitude()) {
                    this.min.setLatitude(p.getLatitude());
                }
                if (p.getLongitude() > this.max.getLongitude()) {
                    this.max.setLongitude(p.getLongitude());
                }
                if (p.getLongitude() < this.min.getLongitude()) {
                    this.min.setLongitude(p.getLongitude());
                }
            } else {
                this.setMin(p);
                this.setMax(p);
            }
        }
    }

    public void expandToMapRatio() {
        this.expandToMapRatio(2.0);
    }

    public void expandToMapRatio(double mapRatio) {
        if (this.isValid()) {
            double height;
            double width = this.max.getLongitude() - this.min.getLongitude();
            double ratio = width / (height = this.max.getLatitude() - this.min.getLatitude());
            if (mapRatio > ratio) {
                double equalWidthIncrease = (height * mapRatio - width) / 2.0;
                double minX = this.min.getLongitude();
                double maxX = this.max.getLongitude();
                if (minX - equalWidthIncrease < Point.MIN_LONGITUDE) {
                    minX = Point.MIN_LONGITUDE;
                    maxX = width * mapRatio;
                } else if (maxX + equalWidthIncrease > Point.MAX_LONGITUDE) {
                    minX = Point.MAX_LONGITUDE - width * mapRatio;
                    maxX = Point.MAX_LONGITUDE;
                } else {
                    minX -= equalWidthIncrease;
                    maxX += equalWidthIncrease;
                }
                this.min.setLongitude(minX);
                this.max.setLongitude(maxX);
            } else if (mapRatio < ratio) {
                double equalHeightIncrease = (width / mapRatio - height) / 2.0;
                double minY = this.min.getLatitude();
                double maxY = this.max.getLatitude();
                if (minY - equalHeightIncrease < Point.MIN_LATITUDE) {
                    minY = Point.MIN_LATITUDE;
                    maxY = width * mapRatio;
                } else if (maxY + equalHeightIncrease > Point.MAX_LATITUDE) {
                    minY = Point.MAX_LATITUDE - width * mapRatio;
                    maxY = Point.MAX_LATITUDE;
                } else {
                    minY -= equalHeightIncrease;
                    maxY += equalHeightIncrease;
                }
                this.min.setLatitude(minY);
                this.max.setLatitude(maxY);
            }
        }
    }

    public double height() {
        if (this.max == null || this.min == null) {
            return 0.0;
        }
        return this.max.getY() - this.min.getY();
    }

    public boolean isValid() {
        return this.min != null && this.max != null && this.min.isValid() && this.max.isValid();
    }

    public boolean overlaps(BBox bbox) {
        Point c2;
        if (bbox == null || !bbox.isValid()) {
            throw new IllegalArgumentException();
        }
        Point c1 = this.centre();
        return c1.distanceX(c2 = bbox.centre()) < this.width() / 2.0 + bbox.width() / 2.0 && c1.distanceY(c2) < this.height() / 2.0 + bbox.height() / 2.0;
    }

    public void resize(double factor) {
        if (factor < 0.0) {
            throw new IllegalArgumentException("Factor must be larger than 0");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("BBox is not valid");
        }
        double minX = this.min.getLongitude();
        double minY = this.min.getLatitude();
        double maxX = this.max.getLongitude();
        double maxY = this.max.getLatitude();
        double width = maxX - minX;
        double height = maxY - minY;
        double[] maxFactors = new double[]{(factor - 1.0) / 2.0, (Point.MAX_LATITUDE - maxY) / height, (Point.MAX_LATITUDE + minY) / height, (Point.MAX_LONGITUDE - maxX) / width, (Point.MAX_LONGITUDE + minX) / width};
        Arrays.sort(maxFactors);
        double expandFactor = maxFactors[0];
        this.min.setLongitude(minX -= expandFactor * width);
        this.min.setLatitude(minY -= expandFactor * height);
        this.max.setLongitude(maxX += expandFactor * width);
        this.max.setLatitude(maxY += expandFactor * height);
    }

    public void setMax(Point max) {
        if (max == null) {
            this.max = null;
        } else {
            if (this.min == null) {
                this.min = new Point(max.getX(), max.getY());
            }
            this.setOrderedX(this.min.getX(), max.getX());
            this.setOrderedY(this.min.getY(), max.getY());
        }
    }

    public void setMaxX(String s) {
        try {
            this.setOrderedX(this.max.getLongitude(), Double.parseDouble(s));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setMaxY(String s) {
        try {
            this.setOrderedY(this.max.getLatitude(), Double.parseDouble(s));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setMin(Point min) {
        if (min == null) {
            this.min = null;
        } else {
            if (this.max == null) {
                this.max = new Point(min.getX(), min.getY());
            }
            this.setOrderedX(this.min.getX(), this.max.getX());
            this.setOrderedY(this.min.getY(), this.max.getY());
        }
    }

    public void setMinX(String s) {
        try {
            this.setOrderedX(this.min.getLongitude(), Double.parseDouble(s));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setMinY(String s) {
        try {
            this.setOrderedY(this.min.getLatitude(), Double.parseDouble(s));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setOrderedBounds(Double minY, Double minX, Double maxY, Double maxX) {
        this.setOrderedX(minX, maxX);
        this.setOrderedY(minY, maxY);
    }

    public void setOrderedX(Double x1, Double x2) {
        if (this.max == null) {
            this.max = new Point(x2, 0.0);
        }
        if (this.min == null) {
            this.min = new Point(x1, 0.0);
        }
        if (x1 > x2) {
            this.min.setLongitude(x2);
            this.max.setLongitude(x1);
        } else {
            this.min.setLongitude(x1);
            this.max.setLongitude(x2);
        }
    }

    public void setOrderedY(Double y1, Double y2) {
        if (this.max == null) {
            this.max = new Point(0.0, y2);
        }
        if (this.min == null) {
            this.min = new Point(0.0, y1);
        }
        if (y1 > y2) {
            this.min.setLatitude(y2);
            this.max.setLatitude(y1);
        } else {
            this.min.setLatitude(y1);
            this.max.setLatitude(y2);
        }
    }

    public double surface() {
        return this.width() * this.height();
    }

    public String toStringGeoRSS() {
        return String.format("%s   %s %s   %s   %s %s", this.min.toStringSpace(), this.max.getLongitude(), this.min.getLatitude(), this.max.toStringSpace(), this.min.getLongitude(), this.max.getLatitude());
    }

    public String toStringShort(int decimals) {
        return String.format("%s %s", this.min.toStringShort(decimals), this.max.toStringShort(decimals));
    }

    public String toStringWMS() {
        return String.format("%s,%s,%s,%s", this.min.getLongitude(), this.min.getLatitude(), this.max.getLongitude(), this.max.getLatitude());
    }

    public double width() {
        if (this.max == null || this.min == null) {
            return 0.0;
        }
        return this.max.getX() - this.min.getX();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.max, this.min});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BBox other = (BBox)obj;
        return Objects.equal((Object)this.max, (Object)other.max) && Objects.equal((Object)this.min, (Object)other.min);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("max", (Object)this.max).add("min", (Object)this.min).toString();
    }
}

