/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata.eml;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.gbif.metadata.eml.LocaleBundle;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 8805087340650428951L;
    private final String category;
    private final LocaleBundle localeBundle;
    private final String name;
    private final String value;

    public static Attribute create(String category, LocaleBundle localeBundle, String name, String value) {
        Preconditions.checkNotNull((Object)category, (Object)"Category was null");
        Preconditions.checkArgument((category.trim().length() != 0 ? 1 : 0) != 0, (Object)"Category was empty");
        Preconditions.checkNotNull((Object)localeBundle, (Object)"LocaleBundle was null");
        Preconditions.checkNotNull((Object)name, (Object)"Name was null");
        Preconditions.checkArgument((name.trim().length() != 0 ? 1 : 0) != 0, (Object)"Name was empty");
        Preconditions.checkNotNull((Object)value, (Object)"Value was null");
        Preconditions.checkArgument((value.trim().length() != 0 ? 1 : 0) != 0, (Object)"Value was empty");
        return new Attribute(category, localeBundle, name, value);
    }

    private Attribute(String category, LocaleBundle localeBundle, String name, String value) {
        this.category = category;
        this.localeBundle = localeBundle;
        this.name = name;
        this.value = value;
    }

    public String getCategory() {
        return this.category;
    }

    public LocaleBundle getLocaleBundle() {
        return this.localeBundle;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        return Objects.equal((Object)this.category, (Object)other.category) && Objects.equal((Object)this.localeBundle, (Object)other.localeBundle) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.value, (Object)other.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.category, this.localeBundle, this.name, this.value});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("category", (Object)this.category).add("localeBundle", (Object)this.localeBundle).add("name", (Object)this.name).add("value", (Object)this.value).toString();
    }
}

