/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata;

import com.google.common.base.Strings;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.gbif.metadata.ThreadSafeSimpleDateFormat;

public class DateUtils {
    public static final ThreadSafeSimpleDateFormat ISO_DATE_FORMAT = new ThreadSafeSimpleDateFormat("yyyy-MM-dd");
    public static final List<ThreadSafeSimpleDateFormat> ALL_DATE_FORMATS = new ArrayList<ThreadSafeSimpleDateFormat>(10);

    public static Date calendarDate(String dateString) throws ParseException {
        Date date;
        if (dateString == null || Strings.isNullOrEmpty((String)dateString.trim())) {
            return null;
        }
        dateString = dateString.replaceAll("\\s", "");
        dateString = dateString.replaceAll("[\\,._#//]", "-");
        try {
            ThreadSafeSimpleDateFormat sdf = new ThreadSafeSimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse(dateString);
        }
        catch (ParseException e) {
            if (dateString.length() == 4) {
                ThreadSafeSimpleDateFormat sdf = new ThreadSafeSimpleDateFormat("yyyy");
                date = sdf.parse(dateString);
                date = new Date(date.getTime() + 1L);
            }
            throw e;
        }
        return date;
    }

    public static Date parse(String x) {
        if (x == null || Strings.isNullOrEmpty((String)x.trim())) {
            return null;
        }
        Date date = null;
        for (ThreadSafeSimpleDateFormat df : ALL_DATE_FORMATS) {
            try {
                date = df.parse(x);
                break;
            }
            catch (ParseException ignored) {
            }
        }
        if (date == null) {
            try {
                date = DateUtils.schemaDateTime(x);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date parse(String x, ThreadSafeSimpleDateFormat preferredFormat) {
        Date date = null;
        try {
            date = preferredFormat.parse(x);
        }
        catch (ParseException ignored) {
            date = DateUtils.parse(x);
        }
        return date;
    }

    public static Date parseIso(String x) {
        return DateUtils.parse(x, ISO_DATE_FORMAT);
    }

    public static Date schemaDateTime(String dateString) throws ParseException {
        Date date;
        dateString = Strings.nullToEmpty((String)dateString).trim();
        try {
            Pattern timezone = Pattern.compile("([+-]\\d\\d:\\d\\d)$");
            dateString = timezone.matcher(dateString).replaceAll("GMT$1");
            ThreadSafeSimpleDateFormat sdf = new ThreadSafeSimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
            date = sdf.parse(dateString);
        }
        catch (ParseException ignored) {
            try {
                ThreadSafeSimpleDateFormat sdf = new ThreadSafeSimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                date = sdf.parse(dateString);
            }
            catch (ParseException e1) {
                date = DateUtils.calendarDate(dateString);
            }
        }
        return date;
    }

    private DateUtils() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    static {
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ"));
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z"));
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("EEE, d MMM yyyy HH:mm:ss"));
        ALL_DATE_FORMATS.add(ISO_DATE_FORMAT);
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("yyyy.MM.dd"));
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("dd.MM.yyyy"));
        ALL_DATE_FORMATS.add(new ThreadSafeSimpleDateFormat("yyyy/MM/dd"));
    }
}

