/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.metadata;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gbif.metadata.BasicMetadata;

public class BasicMetadataImpl
implements Serializable,
BasicMetadata {
    private static final long serialVersionUID = 12073642352837495L;
    private static final Joiner SUBJECT_JOINER = Joiner.on((String)"; ").useForNull("");
    private String title;
    private String sourceId;
    private String description;
    private String homepageUrl;
    private String logoUrl;
    private String subject;
    private String rights;
    private String citation;
    private String creatorName;
    private String creatorEmail;
    private String publisherName;
    private String publisherEmail;
    private Date published;
    private Map<String, String> additionalMetadata = new HashMap<String, String>();

    public Map<String, String> getAdditionalMetadata() {
        return this.additionalMetadata;
    }

    public void setAdditionalMetadata(Map<String, String> additionalMetadata) {
        this.additionalMetadata = additionalMetadata;
    }

    @Override
    public String getCreatorEmail() {
        return this.creatorEmail;
    }

    public void setCreatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
    }

    @Override
    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    @Override
    public Date getPublished() {
        return this.published;
    }

    public void setPublished(Date published) {
        this.published = published;
    }

    @Override
    public String getPublisherEmail() {
        return this.publisherEmail;
    }

    public void setPublisherEmail(String publisherEmail) {
        this.publisherEmail = publisherEmail;
    }

    @Override
    public String getPublisherName() {
        return this.publisherName;
    }

    public void setPublisherName(String publisherName) {
        this.publisherName = publisherName;
    }

    @Override
    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getCitationString() {
        return this.citation;
    }

    @Override
    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    @Override
    public String getIdentifier() {
        return this.sourceId;
    }

    public void addAdditionalMetadata(String key, String value) {
        this.additionalMetadata.put(key, value);
    }

    public void addSubject(String newSubject) {
        this.subject = Strings.isNullOrEmpty((String)this.subject) ? newSubject : this.subject + "; " + newSubject.trim();
    }

    public String getAdditionalMetadata(String key) {
        return this.additionalMetadata.get(key);
    }

    public void getCitationString(String citation) {
        this.citation = citation;
    }

    public void setCitationString(String citation) {
        this.citation = citation;
    }

    public void setHomepageUrl(String hohomepageUrl) {
        this.homepageUrl = hohomepageUrl;
    }

    public void setSubject(List<String> keywords) {
        this.subject = SUBJECT_JOINER.join(keywords);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicMetadataImpl other = (BasicMetadataImpl)obj;
        return Objects.equal((Object)this.title, (Object)other.title) && Objects.equal((Object)this.sourceId, (Object)other.sourceId) && Objects.equal((Object)this.description, (Object)other.description) && Objects.equal((Object)this.homepageUrl, (Object)other.homepageUrl) && Objects.equal((Object)this.logoUrl, (Object)other.logoUrl) && Objects.equal((Object)this.subject, (Object)other.subject) && Objects.equal((Object)this.rights, (Object)other.rights) && Objects.equal((Object)this.citation, (Object)other.citation) && Objects.equal((Object)this.creatorName, (Object)other.creatorName) && Objects.equal((Object)this.creatorEmail, (Object)other.creatorEmail) && Objects.equal((Object)this.publisherName, (Object)other.publisherName) && Objects.equal((Object)this.publisherEmail, (Object)other.publisherEmail) && Objects.equal((Object)this.published, (Object)other.published) && Objects.equal(this.additionalMetadata, other.additionalMetadata);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.title, this.sourceId, this.description, this.homepageUrl, this.logoUrl, this.subject, this.rights, this.citation, this.creatorName, this.creatorEmail, this.publisherName, this.publisherEmail, this.published, this.additionalMetadata});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("title", (Object)this.title).add("sourceId", (Object)this.sourceId).add("description", (Object)this.description).add("homepageUrl", (Object)this.homepageUrl).add("logoUrl", (Object)this.logoUrl).add("subject", (Object)this.subject).add("rights", (Object)this.rights).add("citation", (Object)this.citation).add("creatorName", (Object)this.creatorName).add("creatorEmail", (Object)this.creatorEmail).add("publisherName", (Object)this.publisherName).add("publisherEmail", (Object)this.publisherEmail).add("published", (Object)this.published).add("additionalMetadata", this.additionalMetadata).toString();
    }
}

