/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.file;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.gbif.utils.file.FileUtils;

public class FreemarkerWriter {
    protected static final Configuration FTL = FreemarkerWriter.provideFreemarker();

    private static String processTemplateIntoString(Template template, Object model) throws IOException, TemplateException {
        StringWriter result = new StringWriter();
        template.process(model, (Writer)result);
        return result.toString();
    }

    private static Configuration provideFreemarker() {
        ClassTemplateLoader tl = new ClassTemplateLoader(FreemarkerWriter.class, "/templates");
        Configuration fm = new Configuration();
        fm.setDefaultEncoding("utf8");
        fm.setTemplateLoader((TemplateLoader)tl);
        return fm;
    }

    public static void writeFile(File f, String template, Object data) throws IOException, TemplateException {
        String result = FreemarkerWriter.processTemplateIntoString(FTL.getTemplate(template), data);
        Writer out = FileUtils.startNewUtf8File((File)f);
        out.write(result);
        out.close();
    }
}

