/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.parser;

import au.org.ala.names.model.ALAParsedName;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.gbif.ecat.model.ParsedName;
import org.gbif.ecat.parser.NameParser;
import org.gbif.ecat.parser.UnparsableException;
import org.gbif.ecat.voc.NameType;
import org.gbif.ecat.voc.Rank;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhraseNameParser
extends NameParser {
    public static final HashMap<String, Rank> VALID_PHRASE_RANKS;
    protected static final String LOCATION_OR_DESCR = "(?:[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u01520-9 -'\"_\\.]+|\\.)";
    protected static final String VOUCHER = "(\\([a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u01520-9- \\./&,']+\\))";
    protected static final String SOURCE_AUTHORITY = "([a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u01520-9\\[\\]'\" -,\\.]+|\\.)";
    protected static final String PHRASE = "";
    protected static final String PHRASE_RANKS;
    private static final String RANK_MARKER_ALL;
    public static final Pattern RANK_MARKER;
    protected static final Pattern SPECIES_PATTERN;
    protected static final Pattern POTENTIAL_SPECIES_PATTERN;
    protected static final Pattern PHRASE_PATTERN;
    protected static final Pattern WRONG_CASE_INFRAGENERIC;
    protected static final Pattern IGNORE_MARKERS;

    public <T> ParsedName<T> parse(String scientificName) throws UnparsableException {
        ParsedName pn = super.parse(scientificName);
        if (pn.getType() != NameType.wellformed && this.isPhraseRank(pn.rank) && (!pn.authorsParsed || pn.specificEpithet == null || SPECIES_PATTERN.matcher(pn.specificEpithet).matches())) {
            String newName;
            Matcher m1;
            if (SPECIES_PATTERN.matcher(pn.rank).matches() && (m1 = POTENTIAL_SPECIES_PATTERN.matcher(scientificName)).find() && (pn = super.parse(newName = m1.group(1) + m1.group(3) + StringUtils.defaultString((String)m1.group(4), (String)PHRASE))).getType() == NameType.wellformed) {
                return pn;
            }
            Matcher m = PHRASE_PATTERN.matcher(scientificName);
            if (m.find()) {
                ALAParsedName alapn = new ALAParsedName(pn);
                alapn.setLocationPhraseDescription(StringUtils.trimToNull((String)m.group(3)));
                alapn.setPhraseVoucher(StringUtils.trimToNull((String)m.group(4)));
                alapn.setPhraseNominatingParty(StringUtils.trimToNull((String)m.group(5)));
                return alapn;
            }
        } else {
            Matcher m = WRONG_CASE_INFRAGENERIC.matcher(scientificName);
            if (m.find()) {
                scientificName = WordUtils.capitalize((String)scientificName, (char[])new char[]{'('});
                pn = super.parse(scientificName);
            }
        }
        return pn;
    }

    private boolean isPhraseRank(String rank) {
        if (rank == null) {
            return false;
        }
        return VALID_PHRASE_RANKS.containsKey(rank.replaceAll("\\.", PHRASE));
    }

    static {
        HashMap<String, Rank> ranks = new HashMap<String, Rank>();
        ranks.put("subsp", Rank.SUBSPECIES);
        ranks.put("ssp", Rank.SUBSPECIES);
        ranks.put("var", Rank.VARIETY);
        ranks.put("sp", Rank.SPECIES);
        ranks.put("cv", Rank.SPECIES);
        VALID_PHRASE_RANKS = ranks;
        PHRASE_RANKS = "(?:" + StringUtils.join(VALID_PHRASE_RANKS.keySet(), (String)"|") + ")\\.? ";
        RANK_MARKER_ALL = "(notho)? *(" + StringUtils.join(Rank.RANK_MARKER_MAP.keySet(), (String)"|") + ")\\.?";
        RANK_MARKER = Pattern.compile("^" + RANK_MARKER_ALL + "$");
        SPECIES_PATTERN = Pattern.compile("sp\\.?");
        POTENTIAL_SPECIES_PATTERN = Pattern.compile("^([\\x00-\\x7F\\s]*)(" + SPECIES_PATTERN.pattern() + " )" + "([" + "a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153" + "]{3,})(?: *)" + "([\\x00-\\x7F\\s]*)");
        PHRASE_PATTERN = Pattern.compile("^([\\x00-\\x7F\\s]*)(?: *)(" + PHRASE_RANKS + ")(?: *)" + "(" + LOCATION_OR_DESCR + ")" + VOUCHER + "?" + SOURCE_AUTHORITY + "?$");
        WRONG_CASE_INFRAGENERIC = Pattern.compile("(?:\\( ?([a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153-]+) ?\\)|(" + StringUtils.join(Rank.RANK_MARKER_MAP_INFRAGENERIC.keySet(), (String)"|") + ")\\.? ?([" + "A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152" + "][" + "a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153" + "-]+)" + ")");
        IGNORE_MARKERS = Pattern.compile("s[\\.| ]+str[\\. ]+");
    }
}

