/*
 * Copyright (C) 2014 Atlas of Living Australia
 * All Rights Reserved.
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 */

package au.org.ala.names.search;

/**
 * The exception to be thrown when a Genus spp. scientific name is supplied
 *
 * @author Natasha Carter
 */
public class SPPException extends SearchResultException {
    public SPPException() {
        super("Unable to perform search. Can not match to a subset of species within a genus.");
        errorType = au.org.ala.names.model.ErrorType.SPECIES_PLURAL;
    }
}
