/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.search;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.names.lucene.analyzer.LowerCaseKeywordAnalyzer;
import au.org.ala.names.model.ALAParsedName;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.NameIndexField;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.SynonymType;
import au.org.ala.names.parser.PhraseNameParser;
import au.org.ala.names.search.ALANameSearcher;
import au.org.ala.names.util.TaxonNameSoundEx;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.gbif.dwc.record.DarwinCoreRecord;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveFactory;
import org.gbif.ecat.model.ParsedName;
import org.gbif.ecat.parser.NameParser;
import org.gbif.ecat.parser.UnparsableException;
import org.gbif.ecat.voc.NameType;
import org.gbif.utils.file.ClosableIterator;

public class ALANameIndexer {
    private String colFile = "/data/bie-staging/ala-names/col_common_names.txt";
    private String extraALAConcepts = "/data/bie-staging/ala-names/ala-extra.txt";
    private String alaConcepts = "/data/bie-staging/ala-names/ala_accepted_concepts_dump.txt";
    private String alaSynonyms = "/data/bie-staging/ala-names/ala_synonyms_dump.txt";
    private String irmngDwcaDirectory = "/data/bie-staging/irmng/IRMNG_DWC_HOMONYMS";
    private String afdFile = "/data/bie-staging/anbg/AFD-common-names.csv";
    private String apniFile = "/data/bie-staging/anbg/APNI-common-names.csv";
    private Log log = LogFactory.getLog(ALANameIndexer.class);
    private IndexSearcher idSearcher;
    private final int POS_ID = 0;
    private final int POS_PARENT_ID = 1;
    private final int POS_LSID = 2;
    private final int POS_PARETN_LSID = 3;
    private final int POS_ACC_LSID = 4;
    private final int POS_NAME_LSID = 5;
    private final int POS_SCI_NAME = 6;
    private final int POS_GENUS_OR_HIGHER = 7;
    private final int POS_SP_EPITHET = 8;
    private final int POS_INFRA_EPITHET = 9;
    private final int POS_AUTHOR = 10;
    private final int POS_AUTHOR_YEAR = 11;
    private final int POS_RANK_ID = 12;
    private final int POS_RANK = 13;
    private final int POS_LFT = 14;
    private final int POS_RGT = 15;
    private final int POS_KID = 16;
    private final int POS_K = 17;
    private final int POS_PID = 18;
    private final int POS_P = 19;
    private final int POS_CID = 20;
    private final int POS_C = 21;
    private final int POS_OID = 22;
    private final int POS_O = 23;
    private final int POS_FID = 24;
    private final int POS_F = 25;
    private final int POS_GID = 26;
    private final int POS_G = 27;
    private final int POS_SID = 28;
    private final int POS_S = 29;
    private final int POS_SRC = 30;
    private final int POS_EXCLUDED = 36;
    private String indexDirectory;
    private IndexWriter cbIndexWriter;
    NameParser parser = new PhraseNameParser();
    Set<String> knownHomonyms = new HashSet<String>();
    Set<String> blacklist = new HashSet<String>();
    private TaxonNameSoundEx tnse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        this.tnse = new TaxonNameSoundEx();
        LineIterator lines = new LineIterator((Reader)new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResource("au/org/ala/propertystore/known_homonyms.txt").openStream(), "ISO-8859-1")));
        LineIterator blines = new LineIterator((Reader)new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResource("blacklist.txt").openStream())));
        try {
            String line;
            while (lines.hasNext()) {
                line = lines.nextLine().trim();
                this.knownHomonyms.add(line.toUpperCase());
            }
            while (blines.hasNext()) {
                line = blines.nextLine().trim();
                if (line.startsWith("#") || !StringUtils.isNotBlank((String)line)) continue;
                this.blacklist.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            lines.close();
            blines.close();
        }
    }

    public void createIndex(String exportsDir, String indexDir, boolean generateSciNames, boolean generateCommonNames) throws Exception {
        this.createIndex(exportsDir, indexDir, this.alaConcepts, this.alaSynonyms, this.irmngDwcaDirectory, generateSciNames, generateCommonNames);
    }

    public void createIrmngIndex(String exportsDir, String indexDir) throws Exception {
        LowerCaseKeywordAnalyzer analyzer = new LowerCaseKeywordAnalyzer();
        IndexWriter irmngWriter = this.createIndexWriter(new File(indexDir + File.separator + "irmng"), analyzer, true);
        this.indexIrmngDwcA(irmngWriter, this.irmngDwcaDirectory);
        this.indexIRMNG(irmngWriter, exportsDir + File.separator + "ala-species-homonyms.txt", RankType.SPECIES);
        irmngWriter.forceMerge(1);
        irmngWriter.close();
    }

    public void createIndex(String exportsDir, String indexDir, String acceptedFile, String synonymFile, String irmngDwca, boolean generateSciNames, boolean generateCommonNames) throws Exception {
        LowerCaseKeywordAnalyzer analyzer = new LowerCaseKeywordAnalyzer();
        this.createExtraIdIndex(indexDir + File.separator + "id", new File(exportsDir + File.separator + "identifiers.txt"));
        if (generateSciNames) {
            this.indexALA(this.createIndexWriter(new File(indexDir + File.separator + "cb"), analyzer, true), acceptedFile, synonymFile);
            IndexWriter irmngWriter = this.createIndexWriter(new File(indexDir + File.separator + "irmng"), analyzer, true);
            this.indexIrmngDwcA(irmngWriter, irmngDwca);
            this.indexIRMNG(irmngWriter, exportsDir + File.separator + "ala-species-homonyms.txt", RankType.SPECIES);
            irmngWriter.forceMerge(1);
            irmngWriter.close();
        }
        if (generateCommonNames) {
            this.indexCommonNames(this.createIndexWriter(new File(indexDir + File.separator + "vernacular"), (Analyzer)new KeywordAnalyzer(), true), exportsDir, indexDir);
        }
    }

    private IndexSearcher createTmpGuidIndex(String cbExportFile) throws Exception {
        System.out.println("Starting to create the tmp guid index...");
        IndexWriter iw = this.createIndexWriter(new File("/data/tmp/guid"), (Analyzer)new KeywordAnalyzer(), true);
        CSVReader cbreader = new CSVReader((Reader)new FileReader(cbExportFile), '\t', '\"', '/', 1);
        String[] values = cbreader.readNext();
        while (values != null) {
            Document doc = new Document();
            String id = values[0];
            String guid = values[2];
            doc.add((IndexableField)new StringField("id", id, Field.Store.YES));
            if (StringUtils.isEmpty((String)id)) {
                guid = id;
            }
            doc.add((IndexableField)new StoredField("guid", guid));
            iw.addDocument((Iterable)doc);
            values = cbreader.readNext();
        }
        System.out.println("Finished writing the tmp guid index...");
        iw.commit();
        iw.forceMerge(1);
        iw.close();
        return new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)new File("/data/tmp/guid"))));
    }

    protected IndexWriter createIndexWriter(File directory, Analyzer analyzer, boolean replace) throws Exception {
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_34, analyzer);
        if (replace) {
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        if (directory.exists() && replace) {
            FileUtils.forceDelete((File)directory);
        }
        FileUtils.forceMkdir((File)directory);
        IndexWriter iw = new IndexWriter((Directory)FSDirectory.open((File)directory), conf);
        return iw;
    }

    private String getValueFromIndex(IndexSearcher is, String searchField, String value, String retField) {
        TermQuery tq = new TermQuery(new Term(searchField, value));
        try {
            TopDocs results = is.search((Query)tq, 1);
            if (results.totalHits > 0) {
                return is.doc(results.scoreDocs[0].doc).get(retField);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return value;
    }

    private void addExtraALAConcept(IndexWriter iw, String file) throws Exception {
        if (new File(file).exists()) {
            CSVReader reader = new CSVReader((Reader)new FileReader(file), ',', '\"', '\\', 1);
            String[] values = reader.readNext();
            while (values != null) {
                String lsid = values[0];
                String scientificName = values[1];
                String authority = values[2];
                Document doc = this.createALAIndexDocument(scientificName, "-1", lsid, authority, null);
                iw.addDocument((Iterable)doc);
                values = reader.readNext();
            }
        }
    }

    private void addALASyonyms(IndexWriter iw, String file) throws Exception {
        CSVReader reader = new CSVReader((Reader)new FileReader(file), '\t', '\"', '\\', 1);
        String[] values = reader.readNext();
        while (values != null) {
            String source = values[11];
            float boost = source.trim().equals("") || source.equalsIgnoreCase("CoL") ? 0.75f : 1.0f;
            Document doc = this.createALASynonymDocument(values[5], values[6], values[0], values[1], values[2], values[3], values[4], boost, values[9]);
            if (doc != null) {
                iw.addDocument((Iterable)doc);
            }
            values = reader.readNext();
        }
    }

    private void indexALA(IndexWriter iw, String file, String synonymFile) throws Exception {
        int records = 0;
        long time = System.currentTimeMillis();
        CSVReader reader = new CSVReader((Reader)new FileReader(file), '\t', '\"', '\\', 1);
        String[] values = reader.readNext();
        while (values != null) {
            String source;
            String lsid = values[2];
            String id = values[0];
            String rank = values[13];
            int rankId = -1;
            try {
                rankId = Integer.parseInt(values[12]);
            }
            catch (Exception e) {
                // empty catch block
            }
            String acceptedValues = values[4];
            float boost = 1.0f;
            if (rankId % 1000 == 0) {
                boost = 5.0f;
            }
            if (!(source = values[30]).trim().equals("") && !source.equalsIgnoreCase("CoL")) {
                boost *= 2.0f;
            }
            Document doc = this.createALAIndexDocument(values[6], id, lsid, values[12], values[13], values[17], values[16], values[19], values[18], values[21], values[20], values[23], values[22], values[25], values[24], values[27], values[26], values[29], values[28], values[14], values[15], acceptedValues, values[8], values[9], values[10], boost);
            if ("T".equals(values[36]) || "Y".equals(values[36])) {
                doc.add((IndexableField)new TextField(NameIndexField.SYNONYM_TYPE.toString(), SynonymType.EXCLUDES.getId().toString(), Field.Store.YES));
            }
            if (doc != null) {
                iw.addDocument((Iterable)doc);
                if (++records % 100000 == 0) {
                    this.log.info((Object)("Processed " + records + " in " + (System.currentTimeMillis() - time) + " msecs"));
                }
            }
            values = reader.readNext();
        }
        this.addExtraALAConcept(iw, this.extraALAConcepts);
        this.addALASyonyms(iw, synonymFile);
        iw.commit();
        iw.forceMerge(1);
        iw.close();
        this.log.info((Object)("Lucene index created - processed a total of " + records + " records in " + (System.currentTimeMillis() - time) + " msecs "));
    }

    public void addAdditionalName(String lsid, String scientificName, String author, LinnaeanRankClassification cl) throws Exception {
        if (this.cbIndexWriter == null) {
            this.cbIndexWriter = this.createIndexWriter(new File(this.indexDirectory + File.separator + "cb"), new LowerCaseKeywordAnalyzer(), false);
        }
        Document doc = this.createALAIndexDocument(scientificName, "-1", lsid, author, cl);
        this.cbIndexWriter.addDocument((Iterable)doc);
    }

    public void deleteName(String lsid) throws Exception {
        if (this.cbIndexWriter == null) {
            this.cbIndexWriter = this.createIndexWriter(new File(this.indexDirectory + File.separator + "cb"), new LowerCaseKeywordAnalyzer(), false);
        }
        Term term = new Term("lsid", lsid);
        this.cbIndexWriter.deleteDocuments((Query)new TermQuery(term));
        term = new Term("accepted_lsid", lsid);
        this.cbIndexWriter.deleteDocuments((Query)new TermQuery(term));
    }

    public void commit() throws Exception {
        this.commit(false, false);
    }

    public void commit(boolean close, boolean merge) throws Exception {
        if (this.cbIndexWriter != null) {
            this.cbIndexWriter.commit();
            if (merge) {
                this.cbIndexWriter.forceMerge(1);
            }
            if (close) {
                this.cbIndexWriter.close();
            }
        }
    }

    protected void indexIrmngDwcA(IndexWriter iw, String archiveDirectory) throws Exception {
        this.log.info((Object)("Creating the IRMNG index from the DWCA " + archiveDirectory));
        Archive archive = ArchiveFactory.openArchive((File)new File(archiveDirectory));
        ClosableIterator it = archive.iteratorDwc();
        while (it.hasNext()) {
            String family;
            String order;
            String classs;
            String phylum;
            Document doc = new Document();
            DarwinCoreRecord dwcr = (DarwinCoreRecord)it.next();
            String kingdom = dwcr.getKingdom();
            if (StringUtils.isNotEmpty((String)kingdom)) {
                doc.add((IndexableField)new TextField(RankType.KINGDOM.getRank(), kingdom, Field.Store.YES));
            }
            if (StringUtils.isNotEmpty((String)(phylum = dwcr.getPhylum()))) {
                doc.add((IndexableField)new TextField(RankType.PHYLUM.getRank(), phylum, Field.Store.YES));
            }
            if (StringUtils.isNotEmpty((String)(classs = dwcr.getClasss()))) {
                doc.add((IndexableField)new TextField(RankType.CLASS.getRank(), classs, Field.Store.YES));
            }
            if (StringUtils.isNotEmpty((String)(order = dwcr.getOrder()))) {
                doc.add((IndexableField)new TextField(RankType.ORDER.getRank(), order, Field.Store.YES));
            }
            if (StringUtils.isNotEmpty((String)(family = dwcr.getFamily()))) {
                doc.add((IndexableField)new TextField(RankType.FAMILY.getRank(), family, Field.Store.YES));
            }
            String genus = dwcr.getGenus();
            String calculatedRank = "genus";
            if (StringUtils.isNotEmpty((String)genus)) {
                doc.add((IndexableField)new TextField(RankType.GENUS.getRank(), genus, Field.Store.YES));
                String specificEpithet = dwcr.getSpecificEpithet();
                if (StringUtils.isNotEmpty((String)specificEpithet)) {
                    calculatedRank = "species";
                    doc.add((IndexableField)new TextField(RankType.SPECIES.getRank(), genus + " " + specificEpithet, Field.Store.YES));
                }
            }
            String rank = dwcr.getTaxonRank() != null ? dwcr.getTaxonRank() : calculatedRank;
            doc.add((IndexableField)new TextField(IndexField.RANK.toString(), rank, Field.Store.YES));
            String author = dwcr.getScientificNameAuthorship();
            if (StringUtils.isNotEmpty((String)author)) {
                doc.add((IndexableField)new TextField(NameIndexField.AUTHOR.toString(), author, Field.Store.YES));
            }
            iw.addDocument((Iterable)doc);
        }
    }

    void indexIRMNG(IndexWriter iw, String irmngExport, RankType rank) throws Exception {
        this.log.info((Object)"Creating IRMNG index ...");
        File file = new File(irmngExport);
        if (file.exists()) {
            CSVReader reader = new CSVReader((Reader)new FileReader(file), '\t', '\"', '~');
            int count = 0;
            String[] values = null;
            while ((values = reader.readNext()) != null) {
                Document doc = new Document();
                if (values == null || values.length < 7) continue;
                doc.add((IndexableField)new TextField(RankType.KINGDOM.getRank(), values[0], Field.Store.YES));
                doc.add((IndexableField)new TextField(RankType.PHYLUM.getRank(), values[1], Field.Store.YES));
                doc.add((IndexableField)new TextField(RankType.CLASS.getRank(), values[2], Field.Store.YES));
                doc.add((IndexableField)new TextField(RankType.ORDER.getRank(), values[3], Field.Store.YES));
                doc.add((IndexableField)new TextField(RankType.FAMILY.getRank(), values[4], Field.Store.YES));
                doc.add((IndexableField)new TextField(RankType.GENUS.getRank(), values[5], Field.Store.YES));
                if (rank == RankType.GENUS) {
                    doc.add((IndexableField)new TextField(IndexField.ID.toString(), values[6], Field.Store.YES));
                    doc.add((IndexableField)new TextField(IndexField.ACCEPTED.toString(), values[8], Field.Store.YES));
                    doc.add((IndexableField)new TextField(IndexField.HOMONYM.toString(), values[10], Field.Store.YES));
                } else if (rank == RankType.SPECIES) {
                    doc.add((IndexableField)new TextField(RankType.SPECIES.getRank(), values[6], Field.Store.YES));
                }
                doc.add((IndexableField)new TextField(IndexField.RANK.toString(), rank.getRank(), Field.Store.YES));
                iw.addDocument((Iterable)doc);
                ++count;
            }
            iw.commit();
            this.log.info((Object)("Finished indexing " + count + " IRMNG " + (Object)((Object)rank) + " taxa."));
        } else {
            this.log.warn((Object)("Unable to create IRMNG index.  Can't locate " + irmngExport));
        }
    }

    private void indexCommonNames(IndexWriter iw, String exportDir, String indexDir) throws Exception {
        this.log.info((Object)"Creating Common Names Index ...");
        IndexSearcher currentNameSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexDir + File.separator + "cb"))));
        IndexSearcher extraSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)new File(indexDir + File.separator + "id"))));
        this.addCoLCommonNames(iw, currentNameSearcher);
        this.addAnbgCommonNames(this.afdFile, iw, currentNameSearcher, extraSearcher, '\t');
        this.addAnbgCommonNames(this.apniFile, iw, currentNameSearcher, extraSearcher, ',');
        iw.commit();
        iw.forceMerge(1);
        iw.close();
    }

    private void addCoLCommonNames(IndexWriter iw, IndexSearcher currentSearcher) throws Exception {
        File fileCol = new File(this.colFile);
        if (fileCol.exists()) {
            CSVReader reader = new CSVReader((Reader)new FileReader(fileCol), ',', '\"', '~');
            int count = 0;
            String[] values = null;
            while ((values = reader.readNext()) != null) {
                if (values.length != 3) continue;
                if (this.doesTaxonConceptExist(currentSearcher, values[2])) {
                    iw.addDocument((Iterable)this.getCommonNameDocument(values[0], values[1], values[2], 1.0f));
                    ++count;
                    continue;
                }
                System.out.println("Unable to locate LSID " + values[2] + " in current dump");
            }
            this.log.info((Object)("Finished indexing " + count + " common names from " + fileCol));
        } else {
            this.log.warn((Object)("Unable to index common names. Unable to locate : " + fileCol));
        }
    }

    private void addAnbgCommonNames(String fileName, IndexWriter iw, IndexSearcher currentSearcher, IndexSearcher idSearcher, char recordSep) throws Exception {
        File namesFile = new File(fileName);
        Pattern p = Pattern.compile(",");
        if (namesFile.exists()) {
            CSVReader reader = new CSVReader((Reader)new FileReader(namesFile), recordSep, '\"', '\\');
            int count = 0;
            String[] values = reader.readNext();
            while ((values = reader.readNext()) != null) {
                if (values == null || values.length < 4) continue;
                if (this.doesTaxonConceptExist(currentSearcher, values[3]) || this.doesTaxonConceptExist(idSearcher, values[3])) {
                    String[] names;
                    if (!values[2].contains(",") || values[2].toLowerCase().contains(" and ")) {
                        iw.addDocument((Iterable)this.getCommonNameDocument(values[2], null, values[3], 2.0f));
                        ++count;
                        continue;
                    }
                    for (String name : names = p.split(values[2])) {
                        iw.addDocument((Iterable)this.getCommonNameDocument(name, null, values[3], 2.0f));
                        ++count;
                    }
                    continue;
                }
                System.out.println("Unable to locate LSID " + values[3] + " in current dump");
            }
            this.log.info((Object)("Finished indexing " + count + " common names from " + fileName));
        } else {
            this.log.warn((Object)("Unable to index common names. Unable to locate : " + fileName));
        }
    }

    private void createExtraIdIndex(String idxLocation, File idFile) throws Exception {
        CSVReader reader = new CSVReader((Reader)new FileReader(idFile), '\t', '\"', '~');
        File indexDir = new File(idxLocation);
        IndexWriter iw = this.createIndexWriter(indexDir, (Analyzer)new KeywordAnalyzer(), true);
        String[] values = null;
        while ((values = reader.readNext()) != null) {
            if (values == null || values.length < 3) continue;
            Document doc = new Document();
            doc.add((IndexableField)new StringField("lsid", values[2], Field.Store.NO));
            doc.add((IndexableField)new StoredField("reallsid", values[1]));
            iw.addDocument((Iterable)doc);
        }
        iw.commit();
        iw.forceMerge(1);
        iw.close();
        this.idSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)indexDir)));
    }

    private IndexSearcher createTmpIndex(String tcFileName) throws Exception {
        CSVReader reader = new CSVReader((Reader)new FileReader(new File(tcFileName)), '\t', '\"', '~');
        File indexDir = new File("/tmp/taxonConcept");
        IndexWriter iw = this.createIndexWriter(indexDir, (Analyzer)new KeywordAnalyzer(), true);
        String[] values = null;
        while ((values = reader.readNext()) != null) {
            if (values == null || values.length <= 1) continue;
            Document doc = new Document();
            doc.add((IndexableField)new StringField("lsid", values[0], Field.Store.NO));
            iw.addDocument((Iterable)doc);
        }
        iw.commit();
        iw.forceMerge(1);
        iw.close();
        return new IndexSearcher((IndexReader)DirectoryReader.open((Directory)FSDirectory.open((File)indexDir)));
    }

    private boolean doesTaxonConceptExist(IndexSearcher is, String lsid) {
        TermQuery query = new TermQuery(new Term("lsid", lsid));
        try {
            TopDocs results = is.search((Query)query, 1);
            return results.totalHits > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getAcceptedLSID(String value) {
        TermQuery tq = new TermQuery(new Term("lsid", value));
        try {
            TopDocs results = this.idSearcher.search((Query)tq, 1);
            if (results.totalHits > 0) {
                return this.idSearcher.doc(results.scoreDocs[0].doc).get("reallsid");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    protected Document getCommonNameDocument(String cn, String sn, String lsid, float boost) {
        return this.getCommonNameDocument(cn, sn, lsid, boost, true);
    }

    protected Document getCommonNameDocument(String cn, String sn, String lsid, float boost, boolean checkAccepted) {
        Document doc = new Document();
        TextField tf = new TextField(IndexField.COMMON_NAME.toString(), cn.toUpperCase().replaceAll("[^A-Z0-9\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152]", ""), Field.Store.YES);
        tf.setBoost(boost);
        doc.add((IndexableField)tf);
        if (sn != null) {
            doc.add((IndexableField)new TextField(IndexField.NAME.toString(), sn, Field.Store.YES));
        }
        String newLsid = this.getAcceptedLSID(lsid);
        doc.add((IndexableField)new StoredField(IndexField.LSID.toString(), newLsid));
        return doc;
    }

    public Document createALAIndexDocument(String name, String id, String lsid, String author, LinnaeanRankClassification cl) {
        return this.createALAIndexDocument(name, id, lsid, author, null, null, null, null, cl);
    }

    public Document createALAIndexDocument(String name, String id, String lsid, String author, String rank, String rankId, String left, String right, LinnaeanRankClassification cl) {
        if (cl == null) {
            cl = new LinnaeanRankClassification();
        }
        return this.createALAIndexDocument(name, id, lsid, rankId, rank, cl.getKingdom(), cl.getKid(), cl.getPhylum(), cl.getPid(), cl.getKlass(), cl.getCid(), cl.getOrder(), cl.getOid(), cl.getFamily(), cl.getFid(), cl.getGenus(), cl.getGid(), cl.getSpecies(), cl.getSid(), left, right, null, null, null, author, 1.0f);
    }

    protected Document createALASynonymDocument(String scientificName, String author, String id, String lsid, String nameLsid, String acceptedLsid, String acceptedId, float boost, String synonymType) {
        Document doc = this.createALAIndexDocument(scientificName, id, lsid = StringUtils.isBlank((String)lsid) ? nameLsid : lsid, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, acceptedLsid, null, null, author, boost);
        if (doc != null && synonymType != null) {
            try {
                doc.add((IndexableField)new TextField(NameIndexField.SYNONYM_TYPE.toString(), synonymType, Field.Store.YES));
            }
            catch (Exception e) {
                System.out.println("Error on " + scientificName + " " + author + " " + id + ".  " + e.getMessage());
            }
        }
        return doc;
    }

    private boolean isBlacklisted(String scientificName) {
        return this.blacklist.contains(scientificName.trim());
    }

    private Document createALAIndexDocument(String name, String id, String lsid, String rank, String rankString, String kingdom, String kid, String phylum, String pid, String clazz, String cid, String order, String oid, String family, String fid, String genus, String gid, String species, String sid, String left, String right, String acceptedConcept, String specificEpithet, String infraspecificEpithet, String author, float boost) {
        if (this.isBlacklisted(name)) {
            System.out.println(name + " has been blacklisted");
            return null;
        }
        Document doc = new Document();
        doc.add((IndexableField)new StringField(NameIndexField.ID.toString(), id, Field.Store.YES));
        doc.add((IndexableField)new StringField(NameIndexField.LSID.toString(), lsid, Field.Store.YES));
        if (lsid.startsWith("ALA")) {
            doc.add((IndexableField)new TextField(NameIndexField.ALA.toString(), "T", Field.Store.NO));
        }
        TextField f = new TextField(NameIndexField.NAME.toString(), name, Field.Store.YES);
        f.setBoost(boost);
        doc.add((IndexableField)f);
        if (StringUtils.isNotEmpty((String)rank)) {
            doc.add((IndexableField)new StringField(NameIndexField.RANK_ID.toString(), rank, Field.Store.YES));
        }
        if (StringUtils.isNotEmpty((String)rankString)) {
            doc.add((IndexableField)new StringField(NameIndexField.RANK.toString(), rankString, Field.Store.YES));
        }
        if (StringUtils.isNotEmpty((String)acceptedConcept)) {
            doc.add((IndexableField)new StringField(NameIndexField.ACCEPTED.toString(), acceptedConcept, Field.Store.YES));
            doc.add((IndexableField)new TextField(NameIndexField.iS_SYNONYM.toString(), "T", Field.Store.NO));
        } else {
            doc.add((IndexableField)new TextField(NameIndexField.iS_SYNONYM.toString(), "F", Field.Store.NO));
        }
        if (StringUtils.trimToNull((String)kingdom) != null) {
            doc.add((IndexableField)new TextField(RankType.KINGDOM.getRank(), kingdom, Field.Store.YES));
            if (StringUtils.isNotBlank((String)kid)) {
                doc.add((IndexableField)new StoredField("kid", kid));
            }
        }
        if (StringUtils.trimToNull((String)phylum) != null) {
            doc.add((IndexableField)new TextField(RankType.PHYLUM.getRank(), phylum, Field.Store.YES));
            if (StringUtils.isNotBlank((String)pid)) {
                doc.add((IndexableField)new StoredField("pid", pid));
            }
        }
        if (StringUtils.trimToNull((String)clazz) != null) {
            doc.add((IndexableField)new TextField(RankType.CLASS.getRank(), clazz, Field.Store.YES));
            if (StringUtils.isNotBlank((String)cid)) {
                doc.add((IndexableField)new StoredField("cid", cid));
            }
        }
        if (StringUtils.trimToNull((String)order) != null) {
            doc.add((IndexableField)new TextField(RankType.ORDER.getRank(), order, Field.Store.YES));
            if (StringUtils.isNotBlank((String)oid)) {
                doc.add((IndexableField)new StoredField("oid", oid));
            }
        }
        if (StringUtils.trimToNull((String)family) != null) {
            doc.add((IndexableField)new TextField(RankType.FAMILY.getRank(), family, Field.Store.YES));
            if (StringUtils.isNotBlank((String)fid)) {
                doc.add((IndexableField)new StoredField("fid", fid));
            }
        }
        if (StringUtils.trimToNull((String)genus) != null) {
            doc.add((IndexableField)new TextField(RankType.GENUS.getRank(), genus, Field.Store.YES));
            if (StringUtils.isNotBlank((String)gid)) {
                doc.add((IndexableField)new StoredField("gid", gid));
            }
        }
        if (StringUtils.trimToNull((String)species) != null) {
            doc.add((IndexableField)new TextField(RankType.SPECIES.getRank(), species, Field.Store.YES));
            if (StringUtils.isNotBlank((String)sid)) {
                doc.add((IndexableField)new StoredField("sid", sid));
            }
        }
        if (StringUtils.trimToNull((String)left) != null) {
            doc.add((IndexableField)new StringField("left", left, Field.Store.YES));
        }
        if (StringUtils.trimToNull((String)right) != null) {
            doc.add((IndexableField)new StringField("right", right, Field.Store.YES));
        }
        if (StringUtils.isNotEmpty((String)author)) {
            doc.add((IndexableField)new TextField(NameIndexField.AUTHOR.toString(), author, Field.Store.YES));
        }
        try {
            ParsedName cn = this.parser.parse(name);
            if (cn != null && cn.isParsableType() && !cn.isIndetermined() && cn.getType() != NameType.informal && !"6500".equals(rank) && cn.getType() != NameType.doubtful) {
                TextField f2 = new TextField(NameIndexField.NAME.toString(), cn.canonicalName(), Field.Store.YES);
                f2.setBoost(boost);
                doc.add((IndexableField)f2);
                if (specificEpithet == null && cn.isBinomial()) {
                    genus = cn.getGenusOrAbove();
                    if (specificEpithet == null) {
                        specificEpithet = cn.getSpecificEpithet();
                    }
                    if (infraspecificEpithet == null) {
                        infraspecificEpithet = cn.getInfraSpecificEpithet();
                    }
                }
            }
            if (cn instanceof ALAParsedName) {
                FieldType ft = new FieldType(TextField.TYPE_STORED);
                ft.setOmitNorms(true);
                ALAParsedName alapn = (ALAParsedName)cn;
                if (!"sp.".equals(alapn.rank) && alapn.specificEpithet != null) {
                    doc.add((IndexableField)new Field(NameIndexField.SPECIFIC.toString(), alapn.getSpecificEpithet(), ft));
                } else if (!"sp.".equals(alapn.rank) && alapn.specificEpithet == null) {
                    this.log.warn((Object)(lsid + " " + name + " has an empty specific for non sp. phrase"));
                }
                if (StringUtils.trimToNull((String)alapn.getLocationPhraseDesciption()) != null) {
                    doc.add((IndexableField)new Field(NameIndexField.PHRASE.toString(), alapn.cleanPhrase, ft));
                }
                if (alapn.getPhraseVoucher() != null) {
                    doc.add((IndexableField)new Field(NameIndexField.VOUCHER.toString(), alapn.cleanVoucher, ft));
                }
                if (StringUtils.isBlank((String)genus) && StringUtils.isNotBlank((String)alapn.getGenusOrAbove())) {
                    doc.add((IndexableField)new TextField(RankType.GENUS.getRank(), alapn.getGenusOrAbove(), Field.Store.YES));
                }
            }
        }
        catch (UnparsableException e) {
            if (e.type == NameType.virus) {
                doc.add((IndexableField)new TextField(NameIndexField.NAME.toString(), ALANameSearcher.virusStopPattern.matcher(name).replaceAll(" "), Field.Store.YES));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (StringUtils.isNotBlank((String)genus)) {
                doc.add((IndexableField)new TextField(NameIndexField.GENUS_EX.toString(), TaxonNameSoundEx.treatWord(genus, "genus"), Field.Store.YES));
            }
            if (StringUtils.isNotBlank((String)specificEpithet)) {
                doc.add((IndexableField)new TextField(NameIndexField.SPECIES_EX.toString(), TaxonNameSoundEx.treatWord(specificEpithet, "species"), Field.Store.YES));
            } else if (StringUtils.isNotBlank((String)genus)) {
                doc.add((IndexableField)new TextField(NameIndexField.SPECIES_EX.toString(), "<null>", Field.Store.YES));
            }
            if (StringUtils.isNotBlank((String)infraspecificEpithet)) {
                doc.add((IndexableField)new TextField(NameIndexField.INFRA_EX.toString(), TaxonNameSoundEx.treatWord(infraspecificEpithet, "species"), Field.Store.YES));
            } else if (StringUtils.isNotBlank((String)specificEpithet)) {
                doc.add((IndexableField)new TextField(NameIndexField.INFRA_EX.toString(), "<null>", Field.Store.YES));
            }
        }
        catch (Exception e) {
            this.log.warn((Object)(lsid + " " + name + " has issues creating a soundex: " + e.getMessage()));
        }
        return doc;
    }

    private String getPhraseName(String specificEpithet, String infraspecificEpithet) {
        return null;
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public static void main(String[] args) throws Exception {
        ALANameIndexer indexer = new ALANameIndexer();
        indexer.init();
        for (String arg : args) {
            System.out.println(arg);
        }
        if (args.length >= 2) {
            boolean sn = true;
            boolean cn = true;
            if (args.length == 3) {
                sn = args[2].equals("-sn");
                cn = args[2].equals("-cn");
            }
            if (args.length == 5) {
                indexer.createIndex(args[0], args[1], args[2], args[3], args[4], sn, cn);
            } else {
                indexer.createIndex(args[0], args[1], sn, cn);
            }
        } else {
            System.out.println("au.org.ala.names.search.ALANameIndexer <directory with export files> <directory in which to create indexes> [<accepted name file>] [<synonym name file>][-cn OR -sn]");
        }
    }

    public static enum IndexField {
        NAME("name"),
        NAMES("names"),
        ID("id"),
        RANK("rank"),
        SEARCHABLE_NAME("searchcan"),
        LSID("lsid"),
        HOMONYM("homonym"),
        ACCEPTED("synonym"),
        LEFT("left"),
        RIGHT("right"),
        COMMON_NAME("common");

        String name;

        private IndexField(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

