/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.nameparser;

import au.org.ala.names.model.ALAParsedName;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.gbif.api.exception.UnparsableException;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.Rank;
import org.gbif.nameparser.GBIFNameParser;
import org.gbif.nameparser.RankUtils;

public class PhraseNameParser
extends GBIFNameParser {
    public static final HashMap<String, Rank> VALID_PHRASE_RANKS;
    public static final String ALL_LETTERS_NUMBERS = "A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u01530-9";
    protected static final String LOCATION_OR_DESCR = "(?:[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u01530-9 -'\"_\\.]+|\\.)";
    protected static final String VOUCHER = "(\\([A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u01530-9- \\./&,']+\\))";
    protected static final String COMMENTARY = "(\\[[^\\]]*\\])";
    protected static final String SOURCE_AUTHORITY = "([A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u01530-9'\" -,\\.]+|\\.)";
    protected static final String PHRASE_RANKS;
    private static final String RANK_MARKER_ALL;
    public static final Pattern RANK_MARKER;
    protected static final Pattern SPECIES_PATTERN;
    protected static final Pattern POTENTIAL_SPECIES_PATTERN;
    protected static final Pattern PHRASE_PATTERN;
    protected static final Pattern WRONG_CASE_INFRAGENERIC;
    protected static final String RANK_MARKER_INFRAGENERIC;
    protected static final String NUMBER_PLACEHOLDER = "\\d+\\.?";
    protected static final Pattern NUMBERED_PLACEHOLDER;
    protected static final Pattern IGNORE_MARKERS;

    public ParsedName parse(String scientificName, Rank rank) throws UnparsableException {
        ParsedName pn = super.parse(scientificName, rank);
        Matcher m = NUMBERED_PLACEHOLDER.matcher(scientificName);
        if (m.matches()) {
            String author;
            String nameRank = m.group(3);
            String genus = m.group(1);
            String epithet = m.group(2);
            String string = author = m.group(4) == null ? null : m.group(4).trim();
            if (StringUtils.isNotBlank((CharSequence)genus) && StringUtils.isNotBlank((CharSequence)epithet) && StringUtils.isNotBlank((CharSequence)nameRank)) {
                if (StringUtils.isNotBlank((CharSequence)author)) {
                    pn.setAuthorship(author);
                }
                pn.setAuthorsParsed(true);
                pn.setGenusOrAbove(genus);
                pn.setRank(rank != null ? rank : RankUtils.inferRank((String)nameRank));
                pn.setSpecificEpithet(epithet.replaceAll("[ _-]+", "-"));
                pn.setType(NameType.PLACEHOLDER);
                return pn;
            }
        }
        if (pn.getType() != NameType.SCIENTIFIC && this.isPhraseRank(pn.getRank()) && (!pn.isAuthorsParsed() || pn.getSpecificEpithet() == null || SPECIES_PATTERN.matcher(pn.getSpecificEpithet()).matches())) {
            String newName;
            Matcher m1;
            if (SPECIES_PATTERN.matcher(scientificName).find() && (m1 = POTENTIAL_SPECIES_PATTERN.matcher(scientificName)).find() && (pn = super.parse(newName = m1.group(1) + m1.group(3) + StringUtils.defaultString((String)m1.group(4), (String)""), rank)).getType() == NameType.SCIENTIFIC) {
                return pn;
            }
            m = PHRASE_PATTERN.matcher(scientificName);
            if (m.find()) {
                ALAParsedName alapn = new ALAParsedName(pn);
                alapn.setInfraGeneric(null);
                alapn.setSpecificEpithet(null);
                alapn.setInfraSpecificEpithet(null);
                alapn.setAuthorship(null);
                alapn.setAuthorsParsed(false);
                alapn.setLocationPhraseDescription(StringUtils.trimToNull((String)m.group(3)));
                alapn.setPhraseVoucher(StringUtils.trimToNull((String)m.group(4)));
                alapn.setPhraseNominatingParty(StringUtils.trimToNull((String)m.group(6)));
                return alapn;
            }
        } else {
            m = WRONG_CASE_INFRAGENERIC.matcher(scientificName);
            if (m.find()) {
                scientificName = WordUtils.capitalize((String)scientificName, (char[])new char[]{'('});
                pn = super.parse(scientificName, rank);
            }
        }
        return pn;
    }

    private boolean isPhraseRank(Rank rank) {
        if (rank == null) {
            return false;
        }
        return VALID_PHRASE_RANKS.containsValue(rank);
    }

    static {
        HashMap<String, Rank> ranks = new HashMap<String, Rank>();
        ranks.put("f", Rank.FORM);
        ranks.put("subsp", Rank.SUBSPECIES);
        ranks.put("ssp", Rank.SUBSPECIES);
        ranks.put("var", Rank.VARIETY);
        ranks.put("sp", Rank.SPECIES);
        ranks.put("cv", Rank.CULTIVAR);
        VALID_PHRASE_RANKS = ranks;
        PHRASE_RANKS = "(?:" + StringUtils.join(VALID_PHRASE_RANKS.keySet(), (String)"|") + ")\\.? ";
        RANK_MARKER_ALL = "(notho)? *(" + StringUtils.join(RankUtils.RANK_MARKER_MAP.keySet(), (String)"|") + ")\\.?";
        RANK_MARKER = Pattern.compile("^" + RANK_MARKER_ALL + "$");
        SPECIES_PATTERN = Pattern.compile("sp\\.?");
        POTENTIAL_SPECIES_PATTERN = Pattern.compile("^([\\x00-\\x7F\\s]*)(" + SPECIES_PATTERN.pattern() + " )([" + "a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153" + "]{3,})(?: *)([\\x00-\\x7F\\s]*)");
        PHRASE_PATTERN = Pattern.compile("^([\\x00-\\x7F\\s]*)(?: *)(" + PHRASE_RANKS + ")(?: *)(" + LOCATION_OR_DESCR + ")" + VOUCHER + "?(?: *)" + COMMENTARY + "?(?: *)" + SOURCE_AUTHORITY + "?$");
        WRONG_CASE_INFRAGENERIC = Pattern.compile("(?:\\( ?([a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153-]+) ?\\)|(" + StringUtils.join(RankUtils.RANK_MARKER_MAP_INFRAGENERIC.keySet(), (String)"|") + ")\\.? ?([" + "A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152" + "][" + "a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153" + "-]+))");
        RANK_MARKER_INFRAGENERIC = "(?:" + StringUtils.join(RankUtils.RANK_MARKER_MAP_INFRAGENERIC.keySet(), (String)"|") + ")\\.?";
        NUMBERED_PLACEHOLDER = Pattern.compile("([A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152](?:\\.|[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153]+)(?:-[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152]?[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153]+)?)\\s+((" + RANK_MARKER_INFRAGENERIC + "|[Gg]roup|[Ss]ub[Gg]roup)[\\s_\\-]*" + NUMBER_PLACEHOLDER + ")(\\s+" + "(?:(?:(?:[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]{1,3}\\.?[ -]?){0,3}|[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}][a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]{3,} )?(?:[vV](?:an)(?:[ -](?:den|der) )? ?|von[ -](?:den |der |dem )?|(?:del|de|di|da)[`' _]|(?:Des|De|Di|N)[`' _]?|(?:de )?(?:la|le) |d'|D'|Mac|Mc|Le|St\\.? ?|Ou|O')?(?:v\\. )?[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?(?:(?:[- ](?:de|da|du)?[- ]?)[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?)?(?: ?(?:f|fil|j|jr|jun|junior|sr|sen|senior|ms)\\.?)?(?: *: *(?:Pers|Fr)\\.?)?)?(?:(?: ?ex\\.? | & | et | in |, ?|; ?|\\.)(?:(?:(?:(?:[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]{1,3}\\.?[ -]?){0,3}|[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}][a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]{3,} )?(?:[vV](?:an)(?:[ -](?:den|der) )? ?|von[ -](?:den |der |dem )?|(?:del|de|di|da)[`' _]|(?:Des|De|Di|N)[`' _]?|(?:de )?(?:la|le) |d'|D'|Mac|Mc|Le|St\\.? ?|Ou|O')?(?:v\\. )?[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?(?:(?:[- ](?:de|da|du)?[- ]?)[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152\\p{Lu}]+[a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153\\p{Ll}-?]*\\.?)?(?: ?(?:f|fil|j|jr|jun|junior|sr|sen|senior|ms)\\.?)?(?: *: *(?:Pers|Fr)\\.?)?)|al\\.?))*" + "(\\s*,\\s*" + "[12][0-9][0-9][0-9?][abcdh?]?(?:[/-][0-9]{1,4})?" + ")?)?");
        IGNORE_MARKERS = Pattern.compile("s[\\.| ]+str[\\. ]+");
    }
}

