/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.vocab;

import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;

public enum ALATerm implements Term
{
    verbatimNomenclaturalCode,
    verbatimTaxonomicStatus,
    verbatimNomenclaturalStatus,
    verbatimTaxonRemarks,
    nameComplete,
    nameFormatted,
    nameID,
    status,
    priority,
    kingdomID,
    phylumID,
    classID,
    orderID,
    familyID,
    genusID,
    speciesID,
    subphylum,
    subclass,
    suborder,
    infraorder,
    labels,
    value,
    principalTaxonID,
    principalScientificName,
    taxonomicFlags,
    parentLocationID,
    geographyType,
    distribution,
    doi,
    UnplacedVernacularName,
    UnplacedReference,
    TaxonVariant,
    TaxonomicIssue,
    Location("dwc:", "http://rs.tdwg.org/dwc/terms/");

    public static final String NS = "http://ala.org.au/terms/1.0/";
    public static final String PREFIX = "ala:";
    private String prefix;
    private String namespace;

    private ALATerm(String prefix, String namespace) {
        this.prefix = prefix;
        this.namespace = namespace;
    }

    private ALATerm() {
        this(PREFIX, NS);
    }

    public String qualifiedName() {
        return this.namespace + this.simpleName();
    }

    public String simpleName() {
        return this.name();
    }

    public String toString() {
        return this.prefix + this.name();
    }

    static {
        TermFactory factory = TermFactory.instance();
        for (ALATerm term : ALATerm.values()) {
            factory.addTerm(term.simpleName(), (Term)term, true);
            factory.addTerm(term.qualifiedName(), (Term)term);
            factory.addTerm(((Object)((Object)term)).toString(), (Term)term);
        }
    }
}

