/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.model;

import java.util.HashMap;
import java.util.Map;

public enum VernacularType {
    STANDARD("standard", 900, false, new String[0]),
    PREFERRED("preferred", 800, false, new String[0]),
    COMMON("common", 700, false, "vernacular"),
    TRADITIONAL_KNOWLEDGE("traditionalKnowledge", 600, false, "traditional knowledge", "traditional"),
    LEGISLATIVE("legislated", 500, true, "legislative"),
    MISCELLANEOUS_LITERATURE("miscellaneousLiterature", 400, true, "miscellaneous literature", "misc lit"),
    LOCAL("local", 300, false, new String[0]);

    private static Map<String, VernacularType> nameMap;
    private String term;
    private String[] altTerms;
    private boolean pseudoScientific;
    private int priority;

    private VernacularType(String term, int priority, boolean pseudoScientific, String ... altTerms) {
        this.term = term;
        this.priority = priority;
        this.pseudoScientific = pseudoScientific;
        this.altTerms = altTerms;
    }

    public String getTerm() {
        return this.term;
    }

    public boolean isPseudoScientific() {
        return this.pseudoScientific;
    }

    public int getPriority() {
        return this.priority;
    }

    public static VernacularType forTerm(String term, VernacularType dft) {
        return nameMap.getOrDefault(term, dft);
    }

    static {
        nameMap = new HashMap<String, VernacularType>();
        for (VernacularType type : VernacularType.values()) {
            nameMap.put(type.term, type);
            for (String alt : type.altTerms) {
                nameMap.put(alt, type);
            }
        }
    }
}

