/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.model;

import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.MatchMetrics;
import au.org.ala.names.model.MatchType;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.SynonymType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NameSearchResult {
    private String id;
    private String lsid;
    private String cleanName;
    private boolean isHomonym;
    private String acceptedLsid;
    private String kingdom;
    private String left;
    private String right;
    private LinnaeanRankClassification rankClass;
    private RankType rank;
    private MatchType matchType;
    private SynonymType synonymType;
    private MatchMetrics matchMetrics;

    public NameSearchResult(String id, String lsid, MatchType type) {
        this.id = id;
        this.lsid = StringUtils.trimToNull((String)lsid) == null ? id : StringUtils.trimToNull((String)lsid);
        this.matchType = type;
        this.isHomonym = false;
        this.matchMetrics = new MatchMetrics();
    }

    public NameSearchResult(String id, String lsid, String acceptedLsid, String left, String right, LinnaeanRankClassification rankClass, RankType rank, MatchType type, SynonymType synonymType, Integer priority) {
        this(id, lsid, type);
        this.acceptedLsid = acceptedLsid;
        this.left = left;
        this.right = right;
        this.rankClass = rankClass;
        this.rank = rank;
        this.synonymType = synonymType;
        if (priority != null) {
            this.matchMetrics.setPriority(priority);
        }
    }

    public SynonymType getSynonymType() {
        return this.synonymType;
    }

    public LinnaeanRankClassification getRankClassification() {
        return this.rankClass;
    }

    @Deprecated
    public String getKingdom() {
        return this.kingdom;
    }

    public String getLsid() {
        return this.lsid;
    }

    public String getId() {
        return this.id;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType type) {
        this.matchType = type;
    }

    @Deprecated
    public String getCleanName() {
        return this.cleanName;
    }

    @Deprecated
    public void setCleanName(String name) {
        this.cleanName = name;
    }

    @Deprecated
    public boolean hasBeenCleaned() {
        return this.cleanName != null;
    }

    public boolean isHomonym() {
        return this.isHomonym;
    }

    public boolean isSynonym() {
        return this.acceptedLsid != null;
    }

    @Deprecated
    public String getSynonymLsid() {
        return this.getAcceptedLsid();
    }

    public String getAcceptedLsid() {
        return this.acceptedLsid;
    }

    public String toString() {
        return "Match: " + (Object)((Object)this.matchType) + " id: " + this.id + " lsid: " + this.lsid + " classification: " + this.rankClass + " synonym: " + this.acceptedLsid + " rank: " + (Object)((Object)this.rank);
    }

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("ID", this.id);
        map.put("GUID", this.lsid);
        if (this.rankClass != null) {
            map.put("Classification", this.rankClass.toCSV(','));
            map.put("Scientific name", this.rankClass.getScientificName());
            map.put("Authorship", this.rankClass.getAuthorship());
        }
        if (this.rank != null) {
            map.put("Rank", this.rank.toString());
        }
        map.put("Synonym", this.acceptedLsid);
        if (this.matchType != null) {
            map.put("Match type", this.matchType.toString());
        }
        return map;
    }

    public RankType getRank() {
        return this.rank;
    }

    public void setRank(RankType rank) {
        this.rank = rank;
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public MatchMetrics getMatchMetrics() {
        return this.matchMetrics;
    }

    public void computeMatch(LinnaeanRankClassification query) {
        if (query == null) {
            return;
        }
        this.matchMetrics.computeMatch(query, this.rankClass, this.synonymType != null);
    }
}

