/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.model;

import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.RankType;
import org.apache.commons.lang3.StringUtils;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.SmithWatermanGotoh;

public class MatchMetrics
implements Comparable<MatchMetrics> {
    public static final float MATCH_PROXIMITY = 0.1f;
    public static final int DEFAULT_PRIORITY = 1000;
    public static final float DEFAULT_MATCH = 1.0f;
    final float[] WEIGHTS = new float[]{4.0f, 1.0f, 1.0f, 1.0f, 1.5f, 2.0f, 1.0f, 1.0f, 5.0f, 0.5f};
    final float[] SYNONYM_WEIGHTS = new float[]{2.0f, 1.0f, 1.0f, 1.0f, 1.5f, 0.5f, 1.0f, 1.0f, 5.0f, 0.5f};
    private int priority = 1000;
    private float match = 1.0f;

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public float getMatch() {
        return this.match;
    }

    public void setMatch(float match) {
        this.match = match;
    }

    public void computeMatch(LinnaeanRankClassification query, LinnaeanRankClassification result, boolean synonym) {
        float weight;
        float[] weightVector = synonym ? this.SYNONYM_WEIGHTS : this.WEIGHTS;
        Float[] matchVector = new Float[10];
        SmithWatermanGotoh similarity = new SmithWatermanGotoh();
        float score = weight = synonym ? 1.0f : 0.1f;
        matchVector[0] = this.compareTerm(query.kingdom, result.kingdom, true, (AbstractStringMetric)similarity);
        matchVector[1] = this.compareTerm(query.phylum, result.phylum, false, (AbstractStringMetric)similarity);
        matchVector[2] = this.compareTerm(query.klass, result.klass, false, (AbstractStringMetric)similarity);
        matchVector[3] = this.compareTerm(query.order, result.order, false, (AbstractStringMetric)similarity);
        matchVector[4] = this.compareTerm(query.family, result.family, false, (AbstractStringMetric)similarity);
        matchVector[5] = this.compareTerm(query.genus, result.genus, false, (AbstractStringMetric)similarity);
        matchVector[6] = this.compareTerm(query.specificEpithet, result.specificEpithet, false, (AbstractStringMetric)similarity);
        matchVector[7] = this.compareTerm(query.infraspecificEpithet, result.infraspecificEpithet, false, (AbstractStringMetric)similarity);
        matchVector[8] = this.compareTerm(query.authorship, result.authorship, false, (AbstractStringMetric)similarity);
        if (StringUtils.isNotEmpty((CharSequence)query.rank) && StringUtils.isNotEmpty((CharSequence)result.rank)) {
            RankType r1 = RankType.getForStrRank(query.rank);
            RankType r2 = RankType.getForStrRank(result.rank);
            if (!r1.isLoose() && !r2.isLoose()) {
                matchVector[9] = Float.valueOf(Math.max(0.01f, 1.0f - 0.8f * (float)Math.abs(r1.getId() - r2.getId()) / (float)(RankType.PHYLUM.getId() - RankType.KINGDOM.getId())));
            }
        }
        for (int i = 0; i < matchVector.length; ++i) {
            if (matchVector[i] == null) continue;
            weight += weightVector[i];
            score += matchVector[i].floatValue() * weightVector[i];
        }
        this.match = score / weight;
    }

    private Float compareTerm(String expected, String actual, boolean required, AbstractStringMetric similarity) {
        if (StringUtils.isEmpty((CharSequence)expected)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)actual)) {
            return Float.valueOf(required ? 0.01f : 0.5f);
        }
        if (expected.equalsIgnoreCase(actual)) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf(similarity.getSimilarity(expected.toUpperCase(), actual.toUpperCase()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchMetrics that = (MatchMetrics)o;
        if (this.priority != that.priority) {
            return false;
        }
        return Float.compare(that.match, this.match) == 0;
    }

    public int hashCode() {
        int result = this.priority;
        result = 31 * result + (this.match != 0.0f ? Float.floatToIntBits(this.match) : 0);
        return result;
    }

    @Override
    public int compareTo(MatchMetrics metric) {
        if (Math.abs(this.match - metric.match) > 0.1f) {
            return this.match < metric.match ? -10000 : 10000;
        }
        return this.priority - metric.priority;
    }
}

