/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.gbif.common.parsers.date.DateFormatHint;
import org.gbif.common.parsers.date.DateTimeSeparatorNormalizer;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.Year;
import org.threeten.bp.YearMonth;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalQuery;

public class DateTimeParser {
    private final DateTimeFormatter formatter;
    private final DateTimeSeparatorNormalizer normalizer;
    private final DateFormatHint hint;
    private final TemporalQuery<?>[] types;
    private final int minLength;

    DateTimeParser(@NotNull DateTimeFormatter formatter, @Nullable DateTimeSeparatorNormalizer normalizer, @NotNull DateFormatHint hint, int minLength) {
        Preconditions.checkNotNull(formatter, "DateTimeFormatter can not be null");
        Preconditions.checkNotNull(hint, "DateFormatHint can not be null");
        Preconditions.checkArgument(minLength > 0, "minLength must be greater than 0");
        this.formatter = formatter;
        this.hint = hint;
        this.normalizer = normalizer;
        this.minLength = minLength;
        this.types = this.getTypesFromHint(hint);
    }

    private TemporalQuery<?>[] getTypesFromHint(DateFormatHint hint) {
        switch (hint) {
            case YMDT: {
                return new TemporalQuery[]{ZonedDateTime.FROM, LocalDateTime.FROM, LocalDate.FROM, YearMonth.FROM, Year.FROM};
            }
            case YMD: {
                return new TemporalQuery[]{LocalDate.FROM, YearMonth.FROM, Year.FROM};
            }
            case YM: {
                return new TemporalQuery[]{YearMonth.FROM, Year.FROM};
            }
            case Y: {
                return new TemporalQuery[]{Year.FROM};
            }
            case DMY: 
            case MDY: 
            case HAN: {
                return new TemporalQuery[]{LocalDate.FROM, YearMonth.FROM, Year.FROM};
            }
        }
        return new TemporalQuery[]{LocalDateTime.FROM, LocalDate.FROM, YearMonth.FROM, Year.FROM};
    }

    public DateFormatHint getHint() {
        return this.hint;
    }

    public TemporalAccessor parse(String input) {
        if (input.length() < this.minLength) {
            return null;
        }
        if (this.normalizer != null) {
            input = this.normalizer.normalize(input);
        }
        try {
            if (this.types.length > 1) {
                return this.formatter.parseBest((CharSequence)input, this.types);
            }
            return (TemporalAccessor)this.formatter.parse((CharSequence)input, this.types[0]);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return null;
        }
    }
}

