/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.gbif.common.parsers.date.AtomizedLocalDate;
import org.threeten.bp.Duration;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalField;

public class AtomizedLocalDateTime {
    private final AtomizedLocalDate localDate;
    private final Integer hour;
    private final Integer minute;
    private final Integer second;
    private final Integer millisecond;
    private final int resolution;

    private AtomizedLocalDateTime(AtomizedLocalDate localDate, Integer hour, Integer minute, Integer second, Integer millisecond) {
        int res = 0;
        this.localDate = localDate;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
        if (localDate != null) {
            res += localDate.getResolution();
        }
        if (hour != null) {
            ++res;
        }
        if (minute != null) {
            ++res;
        }
        if (second != null) {
            ++res;
        }
        if (millisecond != null) {
            ++res;
        }
        this.resolution = res;
    }

    public Integer getYear() {
        if (this.localDate == null) {
            return null;
        }
        return this.localDate.getYear();
    }

    public Integer getMonth() {
        if (this.localDate == null) {
            return null;
        }
        return this.localDate.getMonth();
    }

    public Integer getDay() {
        if (this.localDate == null) {
            return null;
        }
        return this.localDate.getDay();
    }

    public Integer getHour() {
        return this.hour;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public Integer getSecond() {
        return this.second;
    }

    public Integer getMillisecond() {
        return this.millisecond;
    }

    public int getResolution() {
        return this.resolution;
    }

    public static AtomizedLocalDateTime fromTemporalAccessor(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        AtomizedLocalDate localDate = AtomizedLocalDate.fromTemporalAccessor(temporalAccessor);
        Integer h = null;
        Integer m = null;
        Integer s = null;
        Integer ms = null;
        if (temporalAccessor.isSupported((TemporalField)ChronoField.HOUR_OF_DAY)) {
            h = temporalAccessor.get((TemporalField)ChronoField.HOUR_OF_DAY);
        }
        if (temporalAccessor.isSupported((TemporalField)ChronoField.MINUTE_OF_HOUR)) {
            m = temporalAccessor.get((TemporalField)ChronoField.MINUTE_OF_HOUR);
        }
        if (temporalAccessor.isSupported((TemporalField)ChronoField.SECOND_OF_MINUTE)) {
            s = temporalAccessor.get((TemporalField)ChronoField.SECOND_OF_MINUTE);
        }
        if (temporalAccessor.isSupported((TemporalField)ChronoField.MILLI_OF_SECOND)) {
            ms = temporalAccessor.get((TemporalField)ChronoField.MILLI_OF_SECOND);
        } else if (temporalAccessor.isSupported((TemporalField)ChronoField.NANO_OF_SECOND)) {
            ms = Long.valueOf(Duration.ofNanos((long)temporalAccessor.get((TemporalField)ChronoField.NANO_OF_SECOND)).toMillis()).intValue();
        }
        return new AtomizedLocalDateTime(localDate, h, m, s, ms);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.localDate).append((Object)this.hour).append((Object)this.minute).append((Object)this.second).append((Object)this.millisecond).append(this.resolution).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AtomizedLocalDateTime)) {
            return false;
        }
        AtomizedLocalDateTime that = (AtomizedLocalDateTime)obj;
        return Objects.equal(this.localDate, that.localDate) && Objects.equal(this.hour, that.hour) && Objects.equal(this.minute, that.minute) && Objects.equal(this.second, that.second) && Objects.equal(this.millisecond, that.millisecond) && Objects.equal(this.resolution, that.resolution);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("localDate", (Object)this.localDate).append("hour", (Object)this.hour).append("minute", (Object)this.minute).append("second", (Object)this.second).append("millisecond", (Object)this.millisecond).append("resolution", this.resolution).toString();
    }
}

