/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.gbif.api.model.common.MediaObject;
import org.gbif.api.vocabulary.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaParser {
    private static final Logger LOG = LoggerFactory.getLogger(MediaParser.class);
    private static final Tika TIKA = new Tika();
    private static final MimeTypes MIME_TYPES = MimeTypes.getDefaultMimeTypes();
    private static final String HTML_TYPE = "text/html";
    private static final Set<String> HTML_MIME_TYPES;
    private static MediaParser instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaParser getInstance() {
        Class<MediaParser> clazz = MediaParser.class;
        synchronized (MediaParser.class) {
            if (instance == null) {
                instance = new MediaParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public MediaObject detectType(MediaObject mo) {
        if (Strings.isNullOrEmpty(mo.getFormat())) {
            mo.setFormat(this.parseMimeType(mo.getIdentifier()));
        }
        if (HTML_TYPE.equalsIgnoreCase(mo.getFormat()) && mo.getIdentifier() != null) {
            mo.setReferences(mo.getIdentifier());
            mo.setIdentifier(null);
            mo.setFormat(null);
        }
        if (!Strings.isNullOrEmpty(mo.getFormat())) {
            if (mo.getFormat().startsWith("image")) {
                mo.setType(MediaType.StillImage);
            } else if (mo.getFormat().startsWith("audio")) {
                mo.setType(MediaType.Sound);
            } else if (mo.getFormat().startsWith("video")) {
                mo.setType(MediaType.MovingImage);
            } else {
                LOG.debug("Unsupported media format {}", (Object)mo.getFormat());
            }
        }
        return mo;
    }

    public String parseMimeType(@Nullable String format) {
        if (format != null) {
            format = Strings.emptyToNull(format.trim().toLowerCase());
        }
        try {
            MimeType mime = MIME_TYPES.getRegisteredMimeType(format);
            if (mime != null) {
                return mime.getName();
            }
        }
        catch (MimeTypeException mimeTypeException) {
            // empty catch block
        }
        return format == null || MimeType.isValid((String)format) ? format : null;
    }

    public String parseMimeType(@Nullable URI uri) {
        if (uri != null) {
            String mime = TIKA.detect(uri.toString());
            if (mime != null && HTML_MIME_TYPES.contains(mime.toLowerCase())) {
                return HTML_TYPE;
            }
            return mime;
        }
        return null;
    }

    static {
        String[] stringArray = new String[3];
        stringArray[0] = "text/x-perl";
        stringArray[1] = HTML_TYPE;
        stringArray[2] = "application/octet-stream";
        HTML_MIME_TYPES = ImmutableSet.of("text/x-coldfusion", "text/x-php", "text/asp", "text/aspdotnet", "text/x-cgi", "text/x-jsp", stringArray);
        instance = null;
    }
}

