/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gbif.api.vocabulary.Language;
import org.gbif.common.parsers.core.EnumParser;
import org.gbif.utils.file.csv.CSVReader;
import org.gbif.utils.file.csv.CSVReaderFactory;

public class LanguageParser
extends EnumParser<Language> {
    private static LanguageParser singletonObject = null;
    private static final Pattern LOCALE = Pattern.compile("^[a-zA-Z]{2,3}_[a-zA-Z]");
    private static final List<Pattern> REMOVE_FROM_NAME_PATTERNS = ImmutableList.of(Pattern.compile("\\(.\\)"), Pattern.compile(", ?langues"), Pattern.compile(" languages"));

    private LanguageParser() {
        super(Language.class, false, LanguageParser.class.getResourceAsStream("/dictionaries/parse/language.txt"));
        for (Language language : Language.values()) {
            this.add(language.name(), language);
            this.add(language.getTitleEnglish(), language);
            this.add(language.getTitleNative(), language);
            this.add(language.getIso2LetterCode(), language);
            this.add(language.getIso3LetterCode(), language);
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            Language lang2 = Language.fromIsoCode((String)locale.getISO3Language());
            if (lang2 == null) {
                this.log.warn("ISO code {} not part of our language enumeration", (Object)lang2);
                continue;
            }
            this.add(locale.getISO3Language(), lang2);
            this.add(locale.getDisplayLanguage(), lang2);
            this.add(locale.getLanguage(), lang2);
            for (Locale l2 : Locale.getAvailableLocales()) {
                this.add(locale.getDisplayLanguage(l2), lang2);
            }
        }
        try {
            CSVReader cSVReader = CSVReaderFactory.build((InputStream)LanguageParser.class.getResourceAsStream("/dictionaries/parse/ISO-639-2_utf-8.txt"), (String)"UTF8", (String)"|", null, (Integer)0);
            while (cSVReader.hasNext()) {
                String alpha2;
                String[] row = cSVReader.next();
                if (row.length <= 2 || StringUtils.isBlank((CharSequence)(alpha2 = row[2]))) continue;
                Language language = Language.fromIsoCode((String)alpha2);
                if (language == null || language == Language.UNKNOWN) {
                    this.log.warn("ISO code {} not part of our language enumeration", (Object)alpha2);
                    continue;
                }
                this.add(row[0], language);
                this.add(row[1], language);
                for (String l : this.mutateLanguageName(row[3])) {
                    this.add(l, language);
                }
                for (String l : this.mutateLanguageName(row[4])) {
                    this.add(l, language);
                }
            }
        }
        catch (Exception exception) {
            this.log.error("Cannot initiate language parser: {}", (Object)exception.getMessage());
            throw new IllegalStateException("Cannot initiate language parser", exception);
        }
        try {
            CSVReader cSVReader = CSVReaderFactory.buildTabReader((InputStream)LanguageParser.class.getResourceAsStream("/dictionaries/parse/iso-639-3-sil.tab"), (String)"UTF8", (Integer)1);
            while (cSVReader.hasNext()) {
                String alpha2;
                String[] row = cSVReader.next();
                if (row.length <= 2 || StringUtils.isBlank((CharSequence)(alpha2 = row[3]))) continue;
                Language language = Language.fromIsoCode((String)alpha2);
                if (language == null || language == Language.UNKNOWN) {
                    this.log.warn("ISO code {} not part of our language enumeration", (Object)alpha2);
                    continue;
                }
                this.add(row[0], language);
                this.add(row[1], language);
                this.add(row[2], language);
                this.add(row[6], language);
            }
        }
        catch (Exception exception) {
            this.log.error("Cannot initiate language parser: {}", (Object)exception.getMessage());
            throw new IllegalStateException("Cannot initiate language parser", exception);
        }
    }

    private Set<String> mutateLanguageName(String lang) {
        HashSet<String> langs = Sets.newHashSet();
        for (String l : lang.split(";")) {
            langs.add(l);
            for (Pattern p : REMOVE_FROM_NAME_PATTERNS) {
                langs.add(p.matcher(l).replaceAll(""));
            }
        }
        return langs;
    }

    @Override
    protected String normalize(String value) {
        if (value != null) {
            int index;
            if (LOCALE.matcher(value).find() && (index = value.indexOf("_")) > 1 && index < 4) {
                return super.normalize(value.substring(0, index));
            }
            return super.normalize(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanguageParser getInstance() {
        Class<LanguageParser> clazz = LanguageParser.class;
        synchronized (LanguageParser.class) {
            if (singletonObject == null) {
                singletonObject = new LanguageParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonObject;
        }
    }
}

