/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gbif.api.vocabulary.InterpretationRemark;
import org.gbif.api.vocabulary.InterpretationRemarkSeverity;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.utils.AnnotationUtils;

public enum OccurrenceIssue implements InterpretationRemark
{
    ZERO_COORDINATE(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS_NO_DATUM),
    COORDINATE_OUT_OF_RANGE(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS_NO_DATUM),
    COORDINATE_INVALID(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS_NO_DATUM),
    COORDINATE_ROUNDED(InterpretationRemarkSeverity.INFO, TermsGroup.COORDINATES_TERMS_NO_DATUM),
    GEODETIC_DATUM_INVALID(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.geodeticDatum}),
    GEODETIC_DATUM_ASSUMED_WGS84(InterpretationRemarkSeverity.INFO, new Term[]{DwcTerm.geodeticDatum}),
    COORDINATE_REPROJECTED(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS),
    COORDINATE_REPROJECTION_FAILED(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS),
    COORDINATE_REPROJECTION_SUSPICIOUS(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS),
    COORDINATE_ACCURACY_INVALID(InterpretationRemarkSeverity.WARNING),
    COORDINATE_PRECISION_INVALID(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.coordinatePrecision}),
    COORDINATE_UNCERTAINTY_METERS_INVALID(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.coordinateUncertaintyInMeters}),
    COORDINATE_PRECISION_UNCERTAINTY_MISMATCH(InterpretationRemarkSeverity.WARNING),
    COUNTRY_COORDINATE_MISMATCH(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_COUNTRY_TERMS),
    COUNTRY_MISMATCH(InterpretationRemarkSeverity.WARNING, TermsGroup.COUNTRY_TERMS),
    COUNTRY_INVALID(InterpretationRemarkSeverity.WARNING, TermsGroup.COUNTRY_TERMS),
    COUNTRY_DERIVED_FROM_COORDINATES(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_COUNTRY_TERMS),
    CONTINENT_COUNTRY_MISMATCH(InterpretationRemarkSeverity.WARNING),
    CONTINENT_INVALID(InterpretationRemarkSeverity.WARNING),
    CONTINENT_DERIVED_FROM_COORDINATES(InterpretationRemarkSeverity.WARNING),
    PRESUMED_SWAPPED_COORDINATE(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS_NO_DATUM),
    PRESUMED_NEGATED_LONGITUDE(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS_NO_DATUM),
    PRESUMED_NEGATED_LATITUDE(InterpretationRemarkSeverity.WARNING, TermsGroup.COORDINATES_TERMS_NO_DATUM),
    RECORDED_DATE_MISMATCH(InterpretationRemarkSeverity.WARNING, TermsGroup.RECORDED_DATE_TERMS),
    RECORDED_DATE_INVALID(InterpretationRemarkSeverity.WARNING, TermsGroup.RECORDED_DATE_TERMS),
    RECORDED_DATE_UNLIKELY(InterpretationRemarkSeverity.WARNING, TermsGroup.RECORDED_DATE_TERMS),
    TAXON_MATCH_FUZZY(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_MATCH_HIGHERRANK(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    TAXON_MATCH_NONE(InterpretationRemarkSeverity.WARNING, TermsGroup.TAXONOMY_TERMS),
    DEPTH_NOT_METRIC(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.minimumDepthInMeters, DwcTerm.maximumDepthInMeters}),
    DEPTH_UNLIKELY(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.minimumDepthInMeters, DwcTerm.maximumDepthInMeters}),
    DEPTH_MIN_MAX_SWAPPED(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.minimumDepthInMeters, DwcTerm.maximumDepthInMeters}),
    DEPTH_NON_NUMERIC(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.minimumDepthInMeters, DwcTerm.maximumDepthInMeters}),
    ELEVATION_UNLIKELY(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.minimumElevationInMeters, DwcTerm.maximumElevationInMeters}),
    ELEVATION_MIN_MAX_SWAPPED(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.minimumElevationInMeters, DwcTerm.maximumElevationInMeters}),
    ELEVATION_NOT_METRIC(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.minimumElevationInMeters, DwcTerm.maximumElevationInMeters}),
    ELEVATION_NON_NUMERIC(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.minimumElevationInMeters, DwcTerm.maximumElevationInMeters}),
    MODIFIED_DATE_INVALID(InterpretationRemarkSeverity.WARNING, new Term[]{DcTerm.modified}),
    MODIFIED_DATE_UNLIKELY(InterpretationRemarkSeverity.WARNING, new Term[]{DcTerm.modified}),
    IDENTIFIED_DATE_UNLIKELY(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.dateIdentified}),
    IDENTIFIED_DATE_INVALID(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.dateIdentified}),
    BASIS_OF_RECORD_INVALID(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.basisOfRecord}),
    TYPE_STATUS_INVALID(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.typeStatus}),
    MULTIMEDIA_DATE_INVALID(InterpretationRemarkSeverity.WARNING),
    MULTIMEDIA_URI_INVALID(InterpretationRemarkSeverity.WARNING),
    REFERENCES_URI_INVALID(InterpretationRemarkSeverity.WARNING, new Term[]{DcTerm.references}),
    INTERPRETATION_ERROR(InterpretationRemarkSeverity.ERROR),
    INDIVIDUAL_COUNT_INVALID(InterpretationRemarkSeverity.WARNING, new Term[]{DwcTerm.individualCount});

    private final Set<Term> relatedTerms;
    private final InterpretationRemarkSeverity severity;
    private final boolean isDeprecated;
    public static final List<OccurrenceIssue> GEOSPATIAL_RULES;
    public static final List<OccurrenceIssue> TAXONOMIC_RULES;

    private OccurrenceIssue(InterpretationRemarkSeverity severity) {
        this.severity = severity;
        this.relatedTerms = Collections.emptySet();
        this.isDeprecated = AnnotationUtils.isFieldDeprecated(OccurrenceIssue.class, (String)this.name());
    }

    private OccurrenceIssue(InterpretationRemarkSeverity severity, Term ... relatedTerms) {
        this.severity = severity;
        this.relatedTerms = ImmutableSet.builder().add((Object[])relatedTerms).build();
        this.isDeprecated = AnnotationUtils.isFieldDeprecated(OccurrenceIssue.class, (String)this.name());
    }

    @Override
    public String getId() {
        return this.name();
    }

    @Override
    public Set<Term> getRelatedTerms() {
        return this.relatedTerms;
    }

    @Override
    public InterpretationRemarkSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    static {
        GEOSPATIAL_RULES = ImmutableList.of((Object)ZERO_COORDINATE, (Object)COORDINATE_INVALID, (Object)COORDINATE_OUT_OF_RANGE, (Object)COUNTRY_COORDINATE_MISMATCH);
        TAXONOMIC_RULES = ImmutableList.of((Object)TAXON_MATCH_FUZZY, (Object)TAXON_MATCH_HIGHERRANK, (Object)TAXON_MATCH_NONE);
    }

    private static class TermsGroup {
        static final Term[] COORDINATES_TERMS_NO_DATUM = new Term[]{DwcTerm.decimalLatitude, DwcTerm.decimalLongitude, DwcTerm.verbatimLatitude, DwcTerm.verbatimLatitude, DwcTerm.verbatimCoordinates};
        static final Term[] COORDINATES_TERMS = new Term[]{DwcTerm.decimalLatitude, DwcTerm.decimalLongitude, DwcTerm.verbatimLatitude, DwcTerm.verbatimLatitude, DwcTerm.verbatimCoordinates, DwcTerm.geodeticDatum};
        static final Term[] COUNTRY_TERMS = new Term[]{DwcTerm.country, DwcTerm.countryCode};
        static final Term[] COORDINATES_COUNTRY_TERMS = new Term[]{DwcTerm.decimalLatitude, DwcTerm.decimalLongitude, DwcTerm.verbatimLatitude, DwcTerm.verbatimLatitude, DwcTerm.verbatimCoordinates, DwcTerm.geodeticDatum, DwcTerm.country, DwcTerm.countryCode};
        static final Term[] RECORDED_DATE_TERMS = new Term[]{DwcTerm.eventDate, DwcTerm.year, DwcTerm.month, DwcTerm.day};
        static final Term[] TAXONOMY_TERMS = new Term[]{DwcTerm.kingdom, DwcTerm.phylum, DwcTerm.class_, DwcTerm.order, DwcTerm.family, DwcTerm.genus, DwcTerm.scientificName, DwcTerm.scientificNameAuthorship, GbifTerm.genericName, DwcTerm.specificEpithet, DwcTerm.infraspecificEpithet};

        private TermsGroup() {
        }
    }
}

