/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gbif.api.vocabulary.InterpretationRemark;
import org.gbif.api.vocabulary.InterpretationRemarkSeverity;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.utils.AnnotationUtils;

public enum NameUsageIssue implements InterpretationRemark
{
    PARENT_NAME_USAGE_ID_INVALID(InterpretationRemarkSeverity.ERROR, new Term[]{DwcTerm.parentNameUsageID}),
    ACCEPTED_NAME_USAGE_ID_INVALID(InterpretationRemarkSeverity.ERROR, new Term[]{DwcTerm.acceptedNameUsageID}),
    ORIGINAL_NAME_USAGE_ID_INVALID(InterpretationRemarkSeverity.ERROR, new Term[]{DwcTerm.originalNameUsageID}),
    ACCEPTED_NAME_MISSING(new Term[]{DwcTerm.taxonomicStatus, DwcTerm.acceptedNameUsageID, DwcTerm.acceptedNameUsage}),
    RANK_INVALID(new Term[]{DwcTerm.taxonRank}),
    NOMENCLATURAL_STATUS_INVALID(new Term[]{DwcTerm.nomenclaturalStatus}),
    TAXONOMIC_STATUS_INVALID(new Term[]{DwcTerm.taxonomicStatus}),
    SCIENTIFIC_NAME_ASSEMBLED(InterpretationRemarkSeverity.INFO, new Term[]{DwcTerm.scientificName, DwcTerm.genus, DwcTerm.specificEpithet, DwcTerm.infraspecificEpithet, DwcTerm.taxonRank, DwcTerm.scientificNameAuthorship, DwcTerm.namePublishedInYear}),
    CHAINED_SYNOYM(new Term[]{DwcTerm.acceptedNameUsageID, DwcTerm.acceptedNameUsage}),
    BASIONYM_AUTHOR_MISMATCH(new Term[]{DwcTerm.scientificName, DwcTerm.scientificNameAuthorship, DwcTerm.originalNameUsageID, DwcTerm.originalNameUsage}),
    TAXONOMIC_STATUS_MISMATCH(new Term[]{DwcTerm.taxonomicStatus, DwcTerm.acceptedNameUsageID, DwcTerm.acceptedNameUsage}),
    PARENT_CYCLE(InterpretationRemarkSeverity.ERROR, new Term[]{DwcTerm.parentNameUsageID, DwcTerm.parentNameUsage}),
    CLASSIFICATION_RANK_ORDER_INVALID(InterpretationRemarkSeverity.ERROR, new Term[]{DwcTerm.parentNameUsageID, DwcTerm.parentNameUsage, DwcTerm.taxonRank}),
    CLASSIFICATION_NOT_APPLIED(new Term[]{DwcTerm.kingdom, DwcTerm.phylum, DwcTerm.class_, DwcTerm.order, DwcTerm.family, DwcTerm.genus}),
    VERNACULAR_NAME_INVALID(new Term[]{DwcTerm.vernacularName}),
    DESCRIPTION_INVALID(new Term[]{GbifTerm.Description}),
    DISTRIBUTION_INVALID(new Term[]{GbifTerm.Distribution}),
    SPECIES_PROFILE_INVALID(new Term[]{GbifTerm.SpeciesProfile}),
    MULTIMEDIA_INVALID(new Term[]{GbifTerm.Multimedia}),
    BIB_REFERENCE_INVALID(new Term[]{GbifTerm.Reference}),
    ALT_IDENTIFIER_INVALID(new Term[]{GbifTerm.Identifier}),
    BACKBONE_MATCH_NONE(InterpretationRemarkSeverity.INFO, new Term[]{DwcTerm.scientificName, DwcTerm.scientificNameAuthorship, DwcTerm.kingdom, DwcTerm.taxonRank}),
    BACKBONE_MATCH_FUZZY(new Term[]{DwcTerm.scientificName, DwcTerm.scientificNameAuthorship, DwcTerm.kingdom, DwcTerm.taxonRank}),
    ACCEPTED_NAME_NOT_UNIQUE(new Term[]{DwcTerm.acceptedNameUsage}),
    PARENT_NAME_NOT_UNIQUE(new Term[]{DwcTerm.parentNameUsage}),
    ORIGINAL_NAME_NOT_UNIQUE(new Term[]{DwcTerm.originalNameUsage}),
    RELATIONSHIP_MISSING(new Term[]{DwcTerm.parentNameUsageID, DwcTerm.acceptedNameUsageID, DwcTerm.originalNameUsageID, DwcTerm.parentNameUsage, DwcTerm.acceptedNameUsage, DwcTerm.originalNameUsage}),
    ORIGINAL_NAME_DERIVED(InterpretationRemarkSeverity.INFO, new Term[0]),
    CONFLICTING_BASIONYM_COMBINATION(new Term[0]),
    NO_SPECIES(InterpretationRemarkSeverity.INFO, new Term[0]),
    NAME_PARENT_MISMATCH(new Term[0]),
    ORTHOGRAPHIC_VARIANT(InterpretationRemarkSeverity.INFO, new Term[0]),
    HOMONYM(InterpretationRemarkSeverity.INFO, new Term[]{DwcTerm.scientificName}),
    PUBLISHED_BEFORE_GENUS(new Term[]{DwcTerm.scientificName, DwcTerm.scientificNameAuthorship, DwcTerm.namePublishedInYear, DwcTerm.genus, DwcTerm.parentNameUsageID, DwcTerm.parentNameUsage});

    private final Set<Term> related;
    private final InterpretationRemarkSeverity severity;
    private final boolean isDeprecated;

    private NameUsageIssue(Term ... related) {
        this(InterpretationRemarkSeverity.WARNING, related);
    }

    private NameUsageIssue(InterpretationRemarkSeverity severity, Term ... related) {
        this.related = related == null ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])related);
        this.severity = severity;
        this.isDeprecated = AnnotationUtils.isFieldDeprecated(NameUsageIssue.class, (String)this.name());
    }

    @Override
    public String getId() {
        return this.name();
    }

    @Override
    public Set<Term> getRelatedTerms() {
        return this.related;
    }

    @Override
    public InterpretationRemarkSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }
}

