/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

public enum Kingdom {
    INCERTAE_SEDIS,
    ANIMALIA,
    ARCHAEA,
    BACTERIA,
    CHROMISTA,
    FUNGI,
    PLANTAE,
    PROTOZOA,
    VIRUSES;


    public static Kingdom byNubUsageKey(int usageKey) {
        try {
            return Kingdom.values()[usageKey];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("There is no kingdom with usage key " + usageKey);
        }
    }

    public String scientificName() {
        String lower = this.name().replaceAll("_", " ").toLowerCase();
        return this == INCERTAE_SEDIS ? lower : Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    public int nubUsageKey() {
        return this.ordinal();
    }

    @Deprecated
    public Integer nubUsageID() {
        return this.nubUsageKey();
    }

    @Deprecated
    public static Kingdom byNubUsageId(int usageKey) {
        return Kingdom.byNubUsageKey(usageKey);
    }
}

