/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util.iterables;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.gbif.api.model.common.paging.PagingRequest;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.registry.NetworkEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class EntityPager<T extends NetworkEntity>
implements Iterable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityPager.class);
    private final int pageSize;

    public EntityPager(int pageSize) {
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"pageSize must at least be 1");
        this.pageSize = pageSize;
    }

    abstract PagingResponse<T> nextPage(PagingRequest var1);

    protected boolean exclude(T entity) {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new ResponseIterator();
    }

    class ResponseIterator
    implements Iterator<T> {
        private final PagingRequest page;
        private PagingResponse<T> resp;
        private Iterator<T> iter;
        private T next;

        public ResponseIterator() {
            this.page = new PagingRequest(0L, EntityPager.this.pageSize);
            this.resp = null;
            this.loadPage();
            this.next = this.nextEntity();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object entity = this.next;
            this.next = this.nextEntity();
            return entity;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private T nextEntity() {
            NetworkEntity entity;
            while (true) {
                if (!this.iter.hasNext()) {
                    if (this.resp.isEndOfRecords()) {
                        return null;
                    }
                    this.loadPage();
                }
                if ((entity = (NetworkEntity)this.iter.next()).getDeleted() != null) {
                    LOG.debug("Ignore deleted entity {}: {}", (Object)entity.getKey(), (Object)entity.getTitle().replaceAll("\n", " "));
                    continue;
                }
                if (!EntityPager.this.exclude(entity)) break;
            }
            return entity;
        }

        private void loadPage() {
            LOG.debug("Loading page {}-{}", (Object)this.page.getOffset(), (Object)(this.page.getOffset() + (long)this.page.getLimit()));
            this.resp = EntityPager.this.nextPage(this.page);
            this.iter = this.resp.getResults().iterator();
            this.page.nextPage();
        }
    }
}

