/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util;

import com.google.common.base.Strings;
import com.google.common.collect.Range;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.gbif.api.util.SearchTypeValidator;

public class IsoDateParsingUtils {
    private static Pattern SIMPLE_ISO_PATTERN = Pattern.compile("\\d{4}(?:-\\d{2}(?:-\\d{2})?)?");

    private IsoDateParsingUtils() {
    }

    public static IsoDateFormat getFirstDateFormatMatch(String value) throws IllegalArgumentException {
        if (SIMPLE_ISO_PATTERN.matcher(value).find()) {
            for (IsoDateFormat dateFormat : IsoDateFormat.values()) {
                if (!dateFormat.isValidDate(value)) continue;
                return dateFormat;
            }
        }
        throw new IllegalArgumentException(value + " is not a valid date");
    }

    public static Date parseDate(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Date parameter can't be null or empty");
        }
        try {
            return IsoDateParsingUtils.getFirstDateFormatMatch(value).parseDate(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("{} is not a valid date parameter", value));
        }
        catch (IllegalArgumentException e) {
            if ("*".equals(value)) {
                return null;
            }
            throw e;
        }
    }

    public static Range<Date> parseDateRange(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Date parameter can't be null or empty");
        }
        String[] dateValues = value.split(",");
        if (dateValues.length != 2) {
            throw new IllegalArgumentException("Date value must be a single value or a range");
        }
        Date lowerDate = IsoDateParsingUtils.parseDate(dateValues[0]);
        Date upperDate = IsoDateParsingUtils.parseDate(dateValues[1]);
        if (upperDate != null) {
            IsoDateFormat upperDateFormat = IsoDateParsingUtils.getFirstDateFormatMatch(dateValues[1]);
            if (upperDateFormat == IsoDateFormat.YEAR_MONTH) {
                upperDate = IsoDateParsingUtils.toLastDayOfMonth(upperDate);
            } else if (upperDateFormat == IsoDateFormat.YEAR) {
                upperDate = IsoDateParsingUtils.toLastDayOfYear(upperDate);
            }
        }
        return SearchTypeValidator.buildRange(lowerDate, upperDate);
    }

    public static Date toLastDayOfMonth(Date value) {
        return IsoDateParsingUtils.toLastDayOf(value, 5);
    }

    public static Date toLastDayOfYear(Date value) {
        return IsoDateParsingUtils.toLastDayOf(value, 6);
    }

    public static Date toLastDayOf(Date value, IsoDateFormat isoDateFormat) {
        if (IsoDateFormat.YEAR_MONTH == isoDateFormat) {
            return IsoDateParsingUtils.toLastDayOf(value, 5);
        }
        if (IsoDateFormat.YEAR == isoDateFormat) {
            return IsoDateParsingUtils.toLastDayOf(value, 6);
        }
        return value;
    }

    private static Date toLastDayOf(Date value, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        calendar.set(field, calendar.getActualMaximum(field));
        return calendar.getTime();
    }

    public static enum IsoDateFormat {
        FULL("yyyy-MM-dd"),
        YEAR_MONTH("yyyy-MM"),
        YEAR("yyyy");

        private final String datePattern;

        private IsoDateFormat(String datePattern) {
            this.datePattern = datePattern;
        }

        public DateFormat getDateFormat() {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.datePattern);
            dateFormat.setLenient(false);
            return dateFormat;
        }

        public boolean isValidDate(String value) {
            try {
                return this.parseDate(value) != null;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public Date parseDate(String value) throws ParseException {
            ParsePosition position = new ParsePosition(0);
            Date date = this.getDateFormat().parse(value, position);
            if (position.getIndex() != value.length()) {
                throw new ParseException(value + " is not a valid date", position.getIndex());
            }
            return date;
        }
    }
}

