/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Comment;
import org.gbif.api.model.registry.Commentable;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Contactable;
import org.gbif.api.model.registry.Endpoint;
import org.gbif.api.model.registry.Endpointable;
import org.gbif.api.model.registry.Identifiable;
import org.gbif.api.model.registry.Identifier;
import org.gbif.api.model.registry.LenientEquals;
import org.gbif.api.model.registry.MachineTag;
import org.gbif.api.model.registry.MachineTaggable;
import org.gbif.api.model.registry.NetworkEntity;
import org.gbif.api.model.registry.Tag;
import org.gbif.api.model.registry.Taggable;
import org.gbif.api.model.registry.eml.Collection;
import org.gbif.api.model.registry.eml.DataDescription;
import org.gbif.api.model.registry.eml.KeywordCollection;
import org.gbif.api.model.registry.eml.Project;
import org.gbif.api.model.registry.eml.SamplingDescription;
import org.gbif.api.model.registry.eml.TaxonomicCoverages;
import org.gbif.api.model.registry.eml.curatorial.CuratorialUnitComposite;
import org.gbif.api.model.registry.eml.geospatial.GeospatialCoverage;
import org.gbif.api.model.registry.eml.temporal.TemporalCoverage;
import org.gbif.api.util.HttpURI;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.DatasetSubtype;
import org.gbif.api.vocabulary.DatasetType;
import org.gbif.api.vocabulary.Language;
import org.gbif.api.vocabulary.License;
import org.gbif.api.vocabulary.MaintenanceUpdateFrequency;

public class Dataset
implements NetworkEntity,
Contactable,
Endpointable,
MachineTaggable,
Taggable,
Identifiable,
Commentable,
LenientEquals<Dataset> {
    private UUID key;
    private UUID parentDatasetKey;
    private UUID duplicateOfDatasetKey;
    private UUID installationKey;
    private UUID publishingOrganizationKey;
    private DOI doi;
    private String version;
    private boolean external;
    private int numConstituents;
    private DatasetType type;
    private DatasetSubtype subtype;
    private String title;
    private String alias;
    private String abbreviation;
    private String description;
    private Language language = Language.ENGLISH;
    private URI homepage;
    private URI logoUrl;
    private Citation citation = new Citation();
    private String rights;
    private boolean lockedForAutoUpdate;
    private String createdBy;
    private String modifiedBy;
    private Date created;
    private Date modified;
    private Date deleted;
    private List<Contact> contacts = Lists.newArrayList();
    private List<Endpoint> endpoints = Lists.newArrayList();
    private List<MachineTag> machineTags = Lists.newArrayList();
    private List<Tag> tags = Lists.newArrayList();
    private List<Identifier> identifiers = Lists.newArrayList();
    private List<Comment> comments = Lists.newArrayList();
    private List<Citation> bibliographicCitations = Lists.newArrayList();
    private List<CuratorialUnitComposite> curatorialUnits = Lists.newArrayList();
    private List<TaxonomicCoverages> taxonomicCoverages = Lists.newArrayList();
    private String geographicCoverageDescription;
    private List<GeospatialCoverage> geographicCoverages = Lists.newArrayList();
    private List<TemporalCoverage> temporalCoverages = Lists.newArrayList();
    private List<KeywordCollection> keywordCollections = Lists.newArrayList();
    private Project project;
    private SamplingDescription samplingDescription;
    private Set<Country> countryCoverage = Sets.newHashSet();
    private List<Collection> collections = Lists.newArrayList();
    private List<DataDescription> dataDescriptions = Lists.newArrayList();
    private Language dataLanguage;
    private String purpose;
    private String additionalInfo;
    private Date pubDate;
    private MaintenanceUpdateFrequency maintenanceUpdateFrequency;
    private String maintenanceDescription;
    private License license;

    @Override
    public UUID getKey() {
        return this.key;
    }

    @Override
    public void setKey(UUID key) {
        this.key = key;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    @Nullable
    public Date getDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(Date deleted) {
        this.deleted = deleted;
    }

    @Nullable
    public UUID getParentDatasetKey() {
        return this.parentDatasetKey;
    }

    public void setParentDatasetKey(UUID parentDatasetKey) {
        this.parentDatasetKey = parentDatasetKey;
    }

    @Nullable
    public UUID getDuplicateOfDatasetKey() {
        return this.duplicateOfDatasetKey;
    }

    public void setDuplicateOfDatasetKey(UUID duplicateOfDatasetKey) {
        this.duplicateOfDatasetKey = duplicateOfDatasetKey;
    }

    @NotNull
    public UUID getInstallationKey() {
        return this.installationKey;
    }

    public void setInstallationKey(UUID installationKey) {
        this.installationKey = installationKey;
    }

    @NotNull
    public UUID getPublishingOrganizationKey() {
        return this.publishingOrganizationKey;
    }

    public void setPublishingOrganizationKey(UUID publishingOrganizationKey) {
        this.publishingOrganizationKey = publishingOrganizationKey;
    }

    @Nullable
    public MaintenanceUpdateFrequency getMaintenanceUpdateFrequency() {
        return this.maintenanceUpdateFrequency;
    }

    public void setMaintenanceUpdateFrequency(MaintenanceUpdateFrequency maintenanceUpdateFrequency) {
        this.maintenanceUpdateFrequency = maintenanceUpdateFrequency;
    }

    public String getMaintenanceDescription() {
        return this.maintenanceDescription;
    }

    public void setMaintenanceDescription(String maintenanceDescription) {
        this.maintenanceDescription = maintenanceDescription;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public DOI getDoi() {
        return this.doi;
    }

    public void setDoi(DOI doi) {
        this.doi = doi;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    @Min(value=0L)
    public int getNumConstituents() {
        return this.numConstituents;
    }

    public void setNumConstituents(int numConstituents) {
        this.numConstituents = numConstituents;
    }

    @NotNull
    public DatasetType getType() {
        return this.type;
    }

    public void setType(DatasetType type) {
        this.type = type;
    }

    @Nullable
    public DatasetSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(DatasetSubtype subtype) {
        this.subtype = subtype;
    }

    @Nullable
    @Size(min=2, max=50)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Nullable
    @Size(min=1, max=50)
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @NotNull
    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    @HttpURI
    @Nullable
    public URI getHomepage() {
        return this.homepage;
    }

    public void setHomepage(URI homepage) {
        this.homepage = homepage;
    }

    @HttpURI
    @Nullable
    public URI getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(URI logoUrl) {
        this.logoUrl = logoUrl;
    }

    @Nullable
    @Valid
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation citation) {
        this.citation = citation;
    }

    @Nullable
    @Size(min=1)
    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public boolean isLockedForAutoUpdate() {
        return this.lockedForAutoUpdate;
    }

    public void setLockedForAutoUpdate(boolean lockedForAutoUpdate) {
        this.lockedForAutoUpdate = lockedForAutoUpdate;
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Override
    public List<Contact> getContacts() {
        return this.contacts;
    }

    @Override
    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    @Override
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    @Override
    public List<MachineTag> getMachineTags() {
        return this.machineTags;
    }

    @Override
    public void setMachineTags(List<MachineTag> machineTags) {
        this.machineTags = machineTags;
    }

    @Override
    public void addMachineTag(MachineTag machineTag) {
        this.machineTags.add(machineTag);
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    @Override
    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public List<Citation> getBibliographicCitations() {
        return this.bibliographicCitations;
    }

    public void setBibliographicCitations(List<Citation> bibliographicCitations) {
        this.bibliographicCitations = bibliographicCitations;
    }

    public List<CuratorialUnitComposite> getCuratorialUnits() {
        return this.curatorialUnits;
    }

    public void setCuratorialUnits(List<CuratorialUnitComposite> curatorialUnits) {
        this.curatorialUnits = curatorialUnits;
    }

    public List<TaxonomicCoverages> getTaxonomicCoverages() {
        return this.taxonomicCoverages;
    }

    public void setTaxonomicCoverages(List<TaxonomicCoverages> taxonomicCoverages) {
        this.taxonomicCoverages = taxonomicCoverages;
    }

    public String getGeographicCoverageDescription() {
        return this.geographicCoverageDescription;
    }

    public void setGeographicCoverageDescription(String geographicCoverageDescription) {
        this.geographicCoverageDescription = geographicCoverageDescription;
    }

    public List<GeospatialCoverage> getGeographicCoverages() {
        return this.geographicCoverages;
    }

    public void setGeographicCoverages(List<GeospatialCoverage> geographicCoverages) {
        this.geographicCoverages = geographicCoverages;
    }

    public List<TemporalCoverage> getTemporalCoverages() {
        return this.temporalCoverages;
    }

    public void setTemporalCoverages(List<TemporalCoverage> temporalCoverages) {
        this.temporalCoverages = temporalCoverages;
    }

    public List<KeywordCollection> getKeywordCollections() {
        return this.keywordCollections;
    }

    public void setKeywordCollections(List<KeywordCollection> keywordCollections) {
        this.keywordCollections = keywordCollections;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public SamplingDescription getSamplingDescription() {
        return this.samplingDescription;
    }

    public void setSamplingDescription(SamplingDescription samplingDescription) {
        this.samplingDescription = samplingDescription;
    }

    public Set<Country> getCountryCoverage() {
        return this.countryCoverage;
    }

    public void setCountryCoverage(Set<Country> countryCoverage) {
        this.countryCoverage = countryCoverage;
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    public void setCollections(List<Collection> collections) {
        this.collections = collections;
    }

    public List<DataDescription> getDataDescriptions() {
        return this.dataDescriptions;
    }

    public void setDataDescriptions(List<DataDescription> dataDescriptions) {
        this.dataDescriptions = dataDescriptions;
    }

    public Language getDataLanguage() {
        return this.dataLanguage;
    }

    public void setDataLanguage(Language dataLanguage) {
        this.dataLanguage = dataLanguage;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public Date getPubDate() {
        return this.pubDate;
    }

    public void setPubDate(Date pubDate) {
        this.pubDate = pubDate;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.doi, this.version, this.parentDatasetKey, this.duplicateOfDatasetKey, this.installationKey, this.publishingOrganizationKey, this.external, this.numConstituents, this.type, this.subtype, this.title, this.alias, this.abbreviation, this.description, this.language, this.homepage, this.logoUrl, this.citation, this.rights, this.lockedForAutoUpdate, this.createdBy, this.modifiedBy, this.created, this.modified, this.deleted, this.contacts, this.endpoints, this.machineTags, this.tags, this.identifiers, this.comments, this.bibliographicCitations, this.curatorialUnits, this.taxonomicCoverages, this.geographicCoverageDescription, this.geographicCoverages, this.temporalCoverages, this.keywordCollections, this.project, this.samplingDescription, this.countryCoverage, this.collections, this.dataDescriptions, this.dataLanguage, this.purpose, this.additionalInfo, this.pubDate, this.maintenanceUpdateFrequency, this.maintenanceDescription, this.license});
    }

    public boolean equals(Object object) {
        if (object instanceof Dataset) {
            Dataset that = (Dataset)object;
            return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.doi, (Object)that.doi) && Objects.equal((Object)this.parentDatasetKey, (Object)that.parentDatasetKey) && Objects.equal((Object)this.duplicateOfDatasetKey, (Object)that.duplicateOfDatasetKey) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.installationKey, (Object)that.installationKey) && Objects.equal((Object)this.publishingOrganizationKey, (Object)that.publishingOrganizationKey) && Objects.equal((Object)this.external, (Object)that.external) && Objects.equal((Object)this.numConstituents, (Object)that.numConstituents) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)((Object)this.subtype), (Object)((Object)that.subtype)) && Objects.equal((Object)this.title, (Object)that.title) && Objects.equal((Object)this.alias, (Object)that.alias) && Objects.equal((Object)this.abbreviation, (Object)that.abbreviation) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)((Object)this.language), (Object)((Object)that.language)) && Objects.equal((Object)this.homepage, (Object)that.homepage) && Objects.equal((Object)this.logoUrl, (Object)that.logoUrl) && Objects.equal((Object)this.citation, (Object)that.citation) && Objects.equal((Object)this.rights, (Object)that.rights) && Objects.equal((Object)this.lockedForAutoUpdate, (Object)that.lockedForAutoUpdate) && Objects.equal((Object)this.createdBy, (Object)that.createdBy) && Objects.equal((Object)this.modifiedBy, (Object)that.modifiedBy) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.modified, (Object)that.modified) && Objects.equal((Object)this.deleted, (Object)that.deleted) && Objects.equal(this.contacts, that.contacts) && Objects.equal(this.endpoints, that.endpoints) && Objects.equal(this.machineTags, that.machineTags) && Objects.equal(this.tags, that.tags) && Objects.equal(this.identifiers, that.identifiers) && Objects.equal(this.comments, that.comments) && Objects.equal(this.bibliographicCitations, that.bibliographicCitations) && Objects.equal(this.curatorialUnits, that.curatorialUnits) && Objects.equal(this.taxonomicCoverages, that.taxonomicCoverages) && Objects.equal((Object)this.geographicCoverageDescription, (Object)that.geographicCoverageDescription) && Objects.equal(this.geographicCoverages, that.geographicCoverages) && Objects.equal(this.temporalCoverages, that.temporalCoverages) && Objects.equal(this.keywordCollections, that.keywordCollections) && Objects.equal((Object)this.project, (Object)that.project) && Objects.equal((Object)this.samplingDescription, (Object)that.samplingDescription) && Objects.equal(this.countryCoverage, that.countryCoverage) && Objects.equal(this.collections, that.collections) && Objects.equal(this.dataDescriptions, that.dataDescriptions) && Objects.equal((Object)((Object)this.dataLanguage), (Object)((Object)that.dataLanguage)) && Objects.equal((Object)this.purpose, (Object)that.purpose) && Objects.equal((Object)this.additionalInfo, (Object)that.additionalInfo) && Objects.equal((Object)this.pubDate, (Object)that.pubDate) && Objects.equal((Object)((Object)this.maintenanceUpdateFrequency), (Object)((Object)that.maintenanceUpdateFrequency)) && Objects.equal((Object)this.maintenanceDescription, (Object)that.maintenanceDescription) && Objects.equal((Object)((Object)this.license), (Object)((Object)that.license));
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("doi", (Object)this.doi).add("version", (Object)this.version).add("parentDatasetKey", (Object)this.parentDatasetKey).add("duplicateOfDatasetKey", (Object)this.duplicateOfDatasetKey).add("installationKey", (Object)this.installationKey).add("publishingOrganizationKey", (Object)this.publishingOrganizationKey).add("numConstituents", this.numConstituents).add("type", (Object)this.type).add("subtype", (Object)this.subtype).add("title", (Object)this.title).add("alias", (Object)this.alias).add("abbreviation", (Object)this.abbreviation).add("description", (Object)this.description).add("language", (Object)this.language).add("homepage", (Object)this.homepage).add("logoUrl", (Object)this.logoUrl).add("citation", (Object)this.citation).add("rights", (Object)this.rights).add("lockedForAutoUpdate", this.lockedForAutoUpdate).add("createdBy", (Object)this.createdBy).add("modifiedBy", (Object)this.modifiedBy).add("created", (Object)this.created).add("modified", (Object)this.modified).add("deleted", (Object)this.deleted).add("contacts", this.contacts).add("endpoints", this.endpoints).add("machineTags", this.machineTags).add("tags", this.tags).add("identifiers", this.identifiers).add("comments", this.comments).add("bibliographicCitations", this.bibliographicCitations).add("curatorialUnits", this.curatorialUnits).add("taxonomicCoverages", this.taxonomicCoverages).add("geographicCoverageDescription", (Object)this.geographicCoverageDescription).add("geographicCoverages", this.geographicCoverages).add("temporalCoverages", this.temporalCoverages).add("keywordCollections", this.keywordCollections).add("project", (Object)this.project).add("samplingDescription", (Object)this.samplingDescription).add("countryCoverage", this.countryCoverage).add("collections", this.collections).add("dataDescriptions", this.dataDescriptions).add("dataLanguage", (Object)this.dataLanguage).add("purpose", (Object)this.purpose).add("additionalInfo", (Object)this.additionalInfo).add("pubDate", (Object)this.pubDate).add("maintenanceUpdateFrequency", (Object)this.maintenanceUpdateFrequency).add("maintenanceDescription", (Object)this.maintenanceDescription).add("license", (Object)this.license).toString();
    }

    @Override
    public boolean lenientEquals(Dataset other) {
        if (this == other) {
            return true;
        }
        return Objects.equal((Object)this.parentDatasetKey, (Object)other.parentDatasetKey) && Objects.equal((Object)this.duplicateOfDatasetKey, (Object)other.duplicateOfDatasetKey) && Objects.equal((Object)this.installationKey, (Object)other.installationKey) && Objects.equal((Object)this.publishingOrganizationKey, (Object)other.publishingOrganizationKey) && Objects.equal((Object)this.doi, (Object)other.doi) && Objects.equal((Object)this.external, (Object)other.external) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)((Object)this.subtype), (Object)((Object)other.subtype)) && Objects.equal((Object)this.title, (Object)other.title) && Objects.equal((Object)this.alias, (Object)other.alias) && Objects.equal((Object)this.abbreviation, (Object)other.abbreviation) && Objects.equal((Object)this.description, (Object)other.description) && Objects.equal((Object)((Object)this.language), (Object)((Object)other.language)) && Objects.equal((Object)this.homepage, (Object)other.homepage) && Objects.equal((Object)this.logoUrl, (Object)other.logoUrl) && Objects.equal((Object)this.citation, (Object)other.citation) && Objects.equal((Object)this.rights, (Object)other.rights) && Objects.equal((Object)this.lockedForAutoUpdate, (Object)other.lockedForAutoUpdate) && Objects.equal((Object)this.deleted, (Object)other.deleted) && Objects.equal((Object)((Object)this.maintenanceUpdateFrequency), (Object)((Object)other.maintenanceUpdateFrequency)) && Objects.equal((Object)this.maintenanceDescription, (Object)other.maintenanceDescription);
    }
}

