/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonAnyGetter;
import org.codehaus.jackson.annotate.JsonAnySetter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.gbif.api.jackson.ExtensionKeyDeserializer;
import org.gbif.api.jackson.ExtensionSerializer;
import org.gbif.api.jackson.TermMapListDeserializer;
import org.gbif.api.jackson.TermMapListSerializer;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.EndpointType;
import org.gbif.api.vocabulary.Extension;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;

public class VerbatimOccurrence {
    private Integer key;
    private UUID datasetKey;
    private UUID publishingOrgKey;
    private Country publishingCountry;
    private EndpointType protocol;
    private Date lastCrawled;
    private Date lastParsed;
    private Integer crawlId;
    private Map<Term, String> verbatimFields = Maps.newHashMap();
    private Map<Extension, List<Map<Term, String>>> extensions = Maps.newHashMap();

    @Nullable
    public String getVerbatimField(Term term) {
        Preconditions.checkNotNull((Object)term, (Object)"term can't be null");
        return this.verbatimFields.get(term);
    }

    public boolean hasVerbatimField(Term term) {
        Preconditions.checkNotNull((Object)term, (Object)"term can't be null");
        return !Strings.isNullOrEmpty((String)this.verbatimFields.get(term));
    }

    public void setVerbatimField(Term term, @Nullable String fieldValue) {
        Preconditions.checkNotNull((Object)term, (Object)"term can't be null");
        this.verbatimFields.put(term, fieldValue);
    }

    @NotNull
    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    @NotNull
    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    public void setDatasetKey(UUID datasetKey) {
        this.datasetKey = datasetKey;
    }

    @NotNull
    public UUID getPublishingOrgKey() {
        return this.publishingOrgKey;
    }

    public void setPublishingOrgKey(UUID publishingOrgKey) {
        this.publishingOrgKey = publishingOrgKey;
    }

    @Nullable
    public Country getPublishingCountry() {
        return this.publishingCountry;
    }

    public void setPublishingCountry(Country publishingCountry) {
        this.publishingCountry = publishingCountry;
    }

    @NotNull
    public EndpointType getProtocol() {
        return this.protocol;
    }

    public void setProtocol(EndpointType protocol) {
        this.protocol = protocol;
    }

    @Nullable
    public Date getLastCrawled() {
        return this.lastCrawled == null ? null : new Date(this.lastCrawled.getTime());
    }

    public void setLastCrawled(@Nullable Date lastCrawled) {
        this.lastCrawled = lastCrawled == null ? null : new Date(lastCrawled.getTime());
    }

    @Nullable
    public Date getLastParsed() {
        return this.lastParsed;
    }

    public void setLastParsed(@Nullable Date lastParsed) {
        this.lastParsed = lastParsed == null ? null : new Date(lastParsed.getTime());
    }

    @Nullable
    public Integer getCrawlId() {
        return this.crawlId;
    }

    public void setCrawlId(Integer crawlId) {
        this.crawlId = crawlId;
    }

    @NotNull
    @JsonIgnore
    public Map<Term, String> getVerbatimFields() {
        return this.verbatimFields;
    }

    public void setVerbatimFields(Map<Term, String> verbatimFields) {
        this.verbatimFields = verbatimFields;
    }

    @NotNull
    @JsonSerialize(keyUsing=ExtensionSerializer.class, contentUsing=TermMapListSerializer.class)
    @JsonDeserialize(keyUsing=ExtensionKeyDeserializer.class, contentUsing=TermMapListDeserializer.class)
    public Map<Extension, List<Map<Term, String>>> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<Extension, List<Map<Term, String>>> extensions) {
        this.extensions = extensions;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("lastParsed", (Object)this.lastParsed).add("key", (Object)this.key).add("datasetKey", (Object)this.datasetKey).add("publishingOrgKey", (Object)this.publishingOrgKey).add("publishingCountry", (Object)this.publishingCountry).add("protocol", (Object)this.protocol).add("crawlId", (Object)this.crawlId).add("lastCrawled", (Object)this.lastCrawled).add("extensions", this.extensions).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.datasetKey, this.publishingOrgKey, this.publishingCountry, this.protocol, this.lastCrawled, this.lastParsed, this.crawlId, this.verbatimFields, this.extensions});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VerbatimOccurrence other = (VerbatimOccurrence)obj;
        return Objects.equal((Object)this.key, (Object)other.key) && Objects.equal((Object)this.datasetKey, (Object)other.datasetKey) && Objects.equal((Object)this.publishingOrgKey, (Object)other.publishingOrgKey) && Objects.equal((Object)((Object)this.publishingCountry), (Object)((Object)other.publishingCountry)) && Objects.equal((Object)((Object)this.protocol), (Object)((Object)other.protocol)) && Objects.equal((Object)this.lastCrawled, (Object)other.lastCrawled) && Objects.equal((Object)this.lastParsed, (Object)other.lastParsed) && Objects.equal(this.verbatimFields, other.verbatimFields) && Objects.equal(this.extensions, other.extensions) && Objects.equal((Object)this.crawlId, (Object)other.crawlId);
    }

    @JsonAnySetter
    private void addJsonVerbatimField(String key, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            Term t = TermFactory.instance().findTerm(key);
            this.verbatimFields.put(t, value);
        }
    }

    @JsonAnyGetter
    private Map<String, String> jsonVerbatimFields() {
        HashMap extendedProps = Maps.newHashMap();
        for (Map.Entry<Term, String> prop : this.verbatimFields.entrySet()) {
            extendedProps.put(prop.getKey().qualifiedName(), prop.getValue());
        }
        return extendedProps;
    }
}

