/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence;

import com.google.common.base.Objects;
import java.util.Date;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.occurrence.DownloadRequest;
import org.gbif.api.model.registry.PostPersist;
import org.gbif.api.model.registry.PrePersist;
import org.gbif.api.vocabulary.License;

public class Download {
    private String key;
    private DOI doi;
    private License license;
    private DownloadRequest request;
    private Date created;
    private Date modified;
    private Status status;
    private String downloadLink;
    private long size;
    private long totalRecords;
    private long numberDatasets;

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDownloadLink() {
        return this.downloadLink;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @Null(groups={PrePersist.class})
    @NotNull(groups={PostPersist.class})
    @Nullable
    public Date getModified() {
        return this.modified;
    }

    @NotNull
    public DownloadRequest getRequest() {
        return this.request;
    }

    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @JsonIgnore
    public boolean isAvailable() {
        return this.status == Status.SUCCEEDED;
    }

    @Nullable
    public long getSize() {
        return this.size;
    }

    @Nullable
    public long getTotalRecords() {
        return this.totalRecords;
    }

    @Nullable
    public long getNumberDatasets() {
        return this.numberDatasets;
    }

    @Nullable
    public DOI getDoi() {
        return this.doi;
    }

    public License getLicense() {
        return this.license;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setDownloadLink(String downloadLink) {
        this.downloadLink = downloadLink;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDoi(DOI doi) {
        this.doi = doi;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setRequest(DownloadRequest request) {
        this.request = request;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public void setNumberDatasets(long numberDatasets) {
        this.numberDatasets = numberDatasets;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("doi", (Object)this.doi).add("status", (Object)this.status).add("downloadLink", (Object)this.downloadLink).add("request", (Object)this.request).add("created", (Object)this.created).add("license", (Object)this.license).add("modified", (Object)this.modified).add("size", this.size).add("totalRecords", this.totalRecords).add("numberDatasets", this.numberDatasets).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Download)) {
            return false;
        }
        Download that = (Download)obj;
        return Objects.equal((Object)this.request, (Object)that.request) && Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.doi, (Object)that.doi) && Objects.equal((Object)((Object)this.license), (Object)((Object)that.license)) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.modified, (Object)that.modified) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)this.downloadLink, (Object)that.downloadLink) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.totalRecords, (Object)that.totalRecords) && Objects.equal((Object)this.numberDatasets, (Object)that.numberDatasets);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.doi, this.license, this.request, this.created, this.modified, this.status, this.downloadLink, this.size, this.totalRecords, this.numberDatasets});
    }

    public static enum Status {
        PREPARING,
        RUNNING,
        SUCCEEDED,
        CANCELLED,
        KILLED,
        FAILED,
        SUSPENDED;

        public static final EnumSet<Status> EXECUTING_STATUSES;
        public static final EnumSet<Status> FINISH_STATUSES;

        static {
            EXECUTING_STATUSES = EnumSet.of(PREPARING, RUNNING, SUSPENDED);
            FINISH_STATUSES = EnumSet.of(SUCCEEDED, CANCELLED, KILLED, FAILED);
        }
    }
}

