/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.jackson;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.gbif.dwc.terms.Term;

public class TermMapListSerializer
extends JsonSerializer<List<Map<Term, String>>> {
    public void serialize(List<Map<Term, String>> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if ((value == null || value.isEmpty()) && provider.getConfig().isEnabled(SerializationConfig.Feature.WRITE_EMPTY_JSON_ARRAYS)) {
            jgen.writeStartArray();
            jgen.writeEndArray();
        } else {
            jgen.writeStartArray();
            for (Map<Term, String> extension : value) {
                jgen.writeStartObject();
                for (Map.Entry<Term, String> entry : extension.entrySet()) {
                    jgen.writeStringField(entry.getKey().qualifiedName(), entry.getValue());
                }
                jgen.writeEndObject();
            }
            jgen.writeEndArray();
        }
    }
}

