/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.jackson;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.gbif.api.vocabulary.License;

public class LicenseSerde {

    public static class LicenseJsonDeserializer
    extends JsonDeserializer<License> {
        public License deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.VALUE_STRING) {
                if (Strings.isNullOrEmpty((String)jp.getText())) {
                    return License.UNSPECIFIED;
                }
                Optional<License> license = License.fromLicenseUrl(jp.getText());
                if (license.isPresent()) {
                    return (License)((Object)license.get());
                }
                license = License.fromString(jp.getText());
                return (License)((Object)license.or((Object)License.UNSUPPORTED));
            }
            throw ctxt.mappingException("Expected String");
        }
    }

    public static class LicenseJsonSerializer
    extends JsonSerializer<License> {
        public void serialize(License value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
                return;
            }
            if (value.getLicenseUrl() != null) {
                jgen.writeString(value.getLicenseUrl());
                return;
            }
            jgen.writeString(value.name().toLowerCase());
        }
    }
}

