/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class SymmetricIdentityMatrix<T> {
    private Map<T, Set<T>> matches = Maps.newHashMap();

    private SymmetricIdentityMatrix() {
    }

    public static <T> SymmetricIdentityMatrix<T> create() {
        return new SymmetricIdentityMatrix<T>();
    }

    public void add(T val1, T val2) {
        if (!this.matches.containsKey(val1)) {
            this.matches.put(val1, Sets.newHashSet());
        }
        this.matches.get(val1).add(val2);
    }

    public void remove(T val) {
        this.matches.remove(val);
        for (Set<T> vals : this.matches.values()) {
            vals.remove(val);
        }
    }

    public boolean contains(T val1, T val2) {
        return val1.equals(val2) || this.matches.containsKey(val1) && this.matches.get(val1).contains(val2) || this.matches.containsKey(val2) && this.matches.get(val2).contains(val1);
    }
}

