/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.utils;

import java.util.regex.Pattern;
import org.gbif.utils.text.StringUtils;

public class SciNameNormalizer {
    private static final Pattern suffix_a = Pattern.compile("(?:on|um|us|a)$");
    private static final Pattern suffix_i = Pattern.compile("ei$");
    private static final Pattern i = Pattern.compile("(?<!\\b)[jyi]+");
    private static final Pattern trh = Pattern.compile("([tr])h", 2);
    private static final Pattern white = Pattern.compile("\\s{2,}");
    private static final Pattern empty = Pattern.compile("['_-]");
    private static final Pattern removeRepeatedLetter = Pattern.compile("(\\p{L})\\1+");
    private static final Pattern removeHybridSignGenus = Pattern.compile("^\\s*[\u00d7xX]\\s*([A-Z])");
    private static final Pattern removeHybridSignEpithet = Pattern.compile("(?:^|\\s)(?:\u00d7\\s*|[xX]\\s+)([^A-Z])");

    public static boolean hasContent(String s) {
        return s != null && !s.trim().isEmpty();
    }

    public static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    public static String normalize(String s) {
        return SciNameNormalizer.normalize(s, false, true);
    }

    public static String normalize(String s, boolean stemming) {
        return SciNameNormalizer.normalize(s, false, stemming);
    }

    public static String normalizeAll(String s) {
        return SciNameNormalizer.normalize(s, true, true);
    }

    public static String normalizeAll(String s, boolean stemming) {
        return SciNameNormalizer.normalize(s, true, stemming);
    }

    private static String normalize(String s, boolean normMonomials, boolean stemming) {
        if (!SciNameNormalizer.hasContent(s)) {
            return "";
        }
        s = s.trim();
        s = removeHybridSignGenus.matcher(s).replaceAll("$1");
        s = removeHybridSignEpithet.matcher(s).replaceAll(" $1");
        s = StringUtils.foldToAscii((String)s);
        s = empty.matcher(s).replaceAll("");
        s = white.matcher(s).replaceAll(" ");
        if (normMonomials) {
            s = SciNameNormalizer.normStrongly(s, stemming);
        } else if (s.indexOf(32) > 2) {
            String[] parts = s.split(" ", 2);
            s = parts[0] + " " + SciNameNormalizer.normStrongly(parts[1], stemming);
        }
        return s.trim();
    }

    private static String normStrongly(String s, boolean stemming) {
        s = removeRepeatedLetter.matcher(s).replaceAll("$1");
        if (stemming) {
            s = SciNameNormalizer.stemEpithet(s);
        }
        s = i.matcher(s).replaceAll("i");
        if (stemming) {
            s = suffix_i.matcher(s).replaceAll("i");
        }
        return trh.matcher(s).replaceAll("$1");
    }

    public static String stemEpithet(String epithet) {
        if (!SciNameNormalizer.hasContent(epithet)) {
            return "";
        }
        return suffix_a.matcher(epithet).replaceFirst("a");
    }
}

