/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.utils;

import com.google.common.base.Throwables;
import java.lang.management.ManagementFactory;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ResourcesMonitor
extends TimerTask {
    private MBeanServer jmx;
    private ObjectName osMBean;

    public ResourcesMonitor() {
        try {
            this.osMBean = ObjectName.getInstance("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            Throwables.propagate(e);
        }
        this.jmx = ManagementFactory.getPlatformMBeanServer();
    }

    @Override
    public void run() {
        System.out.println("OPEN FILES: " + this.getOpenFileDescriptorCount());
        System.out.println("NUMBER OF THREADS: " + Thread.getAllStackTraces().size());
    }

    public long getOpenFileDescriptorCount() {
        try {
            return (Long)this.jmx.getAttribute(this.osMBean, "OpenFileDescriptorCount");
        }
        catch (Exception e) {
            Throwables.propagate(e);
            return -1L;
        }
    }
}

