/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.postgres;

import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabMapperBase
extends Writer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TabMapperBase.class);
    private final int ROW_SIZE;
    private int idx;
    private String[] row;
    private String lastPartialString;

    public TabMapperBase(int ROW_SIZE) {
        this.ROW_SIZE = ROW_SIZE;
        this.row = new String[ROW_SIZE];
    }

    protected abstract void addRow(String[] var1);

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int b;
        int t = off + len;
        int bufStart = b;
        for (b = off; b < t; ++b) {
            char c = cbuf[b];
            if (c == '\n' || c == '\t') {
                if (this.lastPartialString != null) {
                    this.row[this.idx] = this.lastPartialString + new String(cbuf, bufStart, b - bufStart);
                    this.lastPartialString = null;
                } else {
                    this.row[this.idx] = new String(cbuf, bufStart, b - bufStart);
                    if (this.row[this.idx].equals("\\N") || this.row[this.idx].equals("")) {
                        this.row[this.idx] = null;
                    }
                }
                bufStart = b + 1;
                ++this.idx;
            }
            if (c != '\n') continue;
            if (this.idx > 1) {
                this.addRow(this.row);
            }
            this.idx = 0;
            this.row = new String[this.ROW_SIZE];
        }
        if (bufStart <= t) {
            this.lastPartialString = String.copyValueOf(cbuf, bufStart, b - bufStart);
        }
    }
}

