/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.model;

import java.util.Objects;
import java.util.UUID;
import org.gbif.api.model.registry.Dataset;

public class DatasetCore {
    private UUID key;
    private String title;
    private UUID parent;
    private UUID publisher;

    public DatasetCore() {
    }

    public DatasetCore(Dataset d) {
        this.key = d.getKey();
        this.title = d.getTitle();
        this.parent = d.getParentDatasetKey();
        this.publisher = d.getPublishingOrganizationKey();
    }

    public DatasetCore(UUID key, String title) {
        this.key = key;
        this.title = title;
    }

    public DatasetCore(UUID key, String title, UUID parent, UUID publisher) {
        this.key = key;
        this.title = title;
        this.parent = parent;
        this.publisher = publisher;
    }

    public UUID getKey() {
        return this.key;
    }

    public void setKey(UUID key) {
        this.key = key;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UUID getParent() {
        return this.parent;
    }

    public void setParent(UUID parent) {
        this.parent = parent;
    }

    public UUID getPublisher() {
        return this.publisher;
    }

    public void setPublisher(UUID publisher) {
        this.publisher = publisher;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.title, this.parent, this.publisher);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DatasetCore other = (DatasetCore)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.title, other.title) && Objects.equals(this.parent, other.parent) && Objects.equals(this.publisher, other.publisher);
    }
}

