/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.config;

import com.beust.jcommander.Parameter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.google.common.base.MoreObjects;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GangliaConfiguration.class);
    @Parameter(names={"--ganglia-host"})
    public String host;
    @Parameter(names={"--ganglia-port"})
    public int port = 8649;

    @JsonIgnore
    public void start(MetricRegistry registry) {
        if (this.host != null && this.port > 0) {
            try {
                GMetric ganglia = new GMetric(this.host, this.port, GMetric.UDPAddressingMode.MULTICAST, 1);
                GangliaReporter reporter = GangliaReporter.forRegistry((MetricRegistry)registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(ganglia);
                reporter.start(1L, TimeUnit.MINUTES);
                LOG.info("Reporting to ganglia at {}:{}", (Object)this.host, (Object)this.port);
            }
            catch (IOException e) {
                LOG.warn("Failed to setup ganglia reporting at {}:{}", new Object[]{this.host, this.port, e});
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("host", this.host).add("port", this.port).toString();
    }
}

