/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.config;

import com.beust.jcommander.Parameter;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.gbif.checklistbank.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClbConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ClbConfiguration.class);
    private static final String PROPERTY_PREFIX = "checklistbank.db.";
    private static final Set<String> DATASOURCE_SET = Sets.newHashSet("serverName", "databaseName", "user", "password");
    private static final Set<String> IGNORE = Sets.newHashSet("parserTimeout", "syncThreads", "workMem");
    private static final String CONNECTION_INIT_SQL_PROP = "connectionInitSql";
    public static final String PARSER_TIMEOUT_PROP = "checklistbank.parser.timeout";
    public static final String IMPORT_THREADS_PROP = "checklistbank.import.threads";
    private static final String WORK_MEM_PROP = "checklistbank.pg.workMem";
    @NotNull
    @Parameter(names={"--clb-host"})
    public String serverName = "localhost";
    @NotNull
    @Parameter(names={"--clb-db"})
    public String databaseName;
    @NotNull
    @Parameter(names={"--clb-user"})
    public String user;
    @NotNull
    @Parameter(names={"--clb-password"}, password=true)
    public String password;
    @Parameter(names={"--clb-maximum-pool-size"})
    @Min(value=1L)
    public int maximumPoolSize = 8;
    @Parameter(names={"--clb-minimum-idle"})
    @Min(value=0L)
    public int minimumIdle = 1;
    @Parameter(names={"--clb-idle-timeout"})
    @Min(value=0L)
    public int idleTimeout = ClbConfiguration.min(1);
    @Parameter(names={"--clb-max-lifetime"})
    @Min(value=0L)
    public int maxLifetime = ClbConfiguration.min(15);
    @Parameter(names={"--clb-work-mem"})
    public int workMem = 0;
    @Parameter(names={"--clb-connection-timeout"})
    @Min(value=1000L)
    public int connectionTimeout = ClbConfiguration.sec(5);
    @Parameter(names={"--parser-timeout"})
    @Min(value=100L)
    public int parserTimeout = ClbConfiguration.sec(1);
    @Parameter(names={"--sync-threads"})
    @Min(value=0L)
    public int syncThreads = 1;

    private static int min(int minutes) {
        return minutes * 60000;
    }

    private static int sec(int seconds) {
        return seconds * 1000;
    }

    public Properties toProps(boolean withPrefix) {
        String prefix = withPrefix ? PROPERTY_PREFIX : "";
        Properties props = new Properties();
        props.put(prefix + "dataSourceClassName", "org.postgresql.ds.PGSimpleDataSource");
        if (withPrefix) {
            props.put(PARSER_TIMEOUT_PROP, String.valueOf(this.parserTimeout));
            props.put(IMPORT_THREADS_PROP, String.valueOf(this.syncThreads));
            props.put(WORK_MEM_PROP, String.valueOf(this.workMem));
        }
        if (this.workMem > 0) {
            props.put(prefix + CONNECTION_INIT_SQL_PROP, "SET work_mem='" + this.workMem + "MB'");
        }
        for (Field field : ClbConfiguration.class.getDeclaredFields()) {
            if (field.isSynthetic() || !Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            try {
                if (IGNORE.contains(field.getName())) continue;
                if (DATASOURCE_SET.contains(field.getName())) {
                    props.put(prefix + "dataSource." + field.getName(), String.valueOf(field.get(this)));
                    continue;
                }
                props.put(prefix + field.getName(), String.valueOf(field.get(this)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return props;
    }

    public static ClbConfiguration fromProperties(Properties props) {
        ClbConfiguration cfg = new ClbConfiguration();
        cfg.parserTimeout = PropertiesUtils.getIntProp(props, PARSER_TIMEOUT_PROP, cfg.parserTimeout);
        cfg.syncThreads = PropertiesUtils.getIntProp(props, IMPORT_THREADS_PROP, cfg.syncThreads);
        cfg.workMem = PropertiesUtils.getIntProp(props, WORK_MEM_PROP, cfg.workMem);
        for (Field field : ClbConfiguration.class.getDeclaredFields()) {
            if (field.isSynthetic() || !Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            try {
                if (IGNORE.contains(field.getName())) continue;
                String prefix = DATASOURCE_SET.contains(field.getName()) ? "checklistbank.db.dataSource." : PROPERTY_PREFIX;
                Class<?> clazz = field.getType();
                if (Integer.TYPE == clazz) {
                    field.setInt(cfg, Integer.parseInt(props.getProperty(prefix + field.getName(), String.valueOf(field.get(cfg)))));
                    continue;
                }
                field.set(cfg, props.getProperty(prefix + field.getName(), String.valueOf(field.get(cfg))));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return cfg;
    }

    public Connection connect() throws SQLException {
        String url = "jdbc:postgresql://" + this.serverName + "/" + this.databaseName;
        return DriverManager.getConnection(url, this.user, this.password);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("serverName", this.serverName).add("databaseName", this.databaseName).add("user", this.user).add("password", this.password).add("connectionTimeout", this.connectionTimeout).add("maximumPoolSize", this.maximumPoolSize).add("minimumIdle", this.minimumIdle).add("idleTimeout", this.idleTimeout).add("maxLifetime", this.maxLifetime).add("workMem", this.workMem).add("parserTimeout", this.parserTimeout).add("syncThreads", this.syncThreads).toString();
    }

    public int hashCode() {
        return Objects.hash(this.serverName, this.databaseName, this.user, this.password, this.maximumPoolSize, this.minimumIdle, this.idleTimeout, this.maxLifetime, this.workMem, this.connectionTimeout, this.parserTimeout, this.syncThreads);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClbConfiguration other = (ClbConfiguration)obj;
        return Objects.equals(this.serverName, other.serverName) && Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.user, other.user) && Objects.equals(this.password, other.password) && Objects.equals(this.maximumPoolSize, other.maximumPoolSize) && Objects.equals(this.minimumIdle, other.minimumIdle) && Objects.equals(this.idleTimeout, other.idleTimeout) && Objects.equals(this.maxLifetime, other.maxLifetime) && Objects.equals(this.workMem, other.workMem) && Objects.equals(this.connectionTimeout, other.connectionTimeout) && Objects.equals(this.parserTimeout, other.parserTimeout) && Objects.equals(this.syncThreads, other.syncThreads);
    }
}

