/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.authorship;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

public class BasionymGroup<T> {
    private static final Joiner joiner = Joiner.on("; ").skipNulls();
    private String epithet;
    private String authorship;
    private String year;
    private T basionym;
    private List<T> recombinations = Lists.newArrayList();

    public T getBasionym() {
        return this.basionym;
    }

    public void setBasionym(T basionym) {
        this.basionym = basionym;
    }

    public List<T> getRecombinations() {
        return this.recombinations;
    }

    public boolean hasBasionym() {
        return this.basionym != null;
    }

    public boolean hasRecombinations() {
        return !this.recombinations.isEmpty();
    }

    public String getAuthorship() {
        return this.authorship;
    }

    public String getEpithet() {
        return this.epithet;
    }

    public String getYear() {
        return this.year;
    }

    public void setName(String epithet, String authorship, String year) {
        this.epithet = epithet;
        this.authorship = authorship;
        this.year = year;
    }

    public int hashCode() {
        return Objects.hash(this.basionym, this.recombinations, this.epithet, this.authorship, this.year);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BasionymGroup other = (BasionymGroup)obj;
        return Objects.equals(this.basionym, other.basionym) && Objects.equals(this.recombinations, other.recombinations) && Objects.equals(this.epithet, other.epithet) && Objects.equals(this.authorship, other.authorship) && Objects.equals(this.year, other.year);
    }

    public String toString() {
        return "BasionymGroup{" + this.epithet + ' ' + this.authorship + ' ' + this.year + " | " + this.basionym + ": " + joiner.join(this.recombinations) + '}';
    }
}

