/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.checklistbank.authorship;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.checklistbank.authorship.YearComparator;
import org.gbif.checklistbank.model.Equality;
import org.gbif.utils.ObjectUtils;
import org.gbif.utils.file.FileUtils;
import org.gbif.utils.text.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorComparator {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorComparator.class);
    private static final Pattern AND = Pattern.compile("( et | and |&|&amp;)", 2);
    private static final Pattern IN = Pattern.compile(" in .+$", 2);
    private static final Pattern EX = Pattern.compile("^.+ ex ", 2);
    private static final Pattern FIL = Pattern.compile("([A-Z][a-z]*)[\\. ]\\s*f(:?il)?\\.?\\b");
    private static final Pattern TRANSLITERATIONS = Pattern.compile("([auo])e", 2);
    private static final Pattern SURNAME = Pattern.compile("([a-z]+)(:? filius)?$");
    private static final Pattern FIRST_INITIALS = Pattern.compile("^([a-z]\\s)+");
    private static final String AUTHOR_MAP_FILENAME = "/authorship/authormap.txt";
    private static final Pattern PUNCTUATION = Pattern.compile("[\\p{Punct}&&[^,]]+");
    private static final Pattern COMMA = Pattern.compile("\\s*,\\s*");
    private static final Splitter AUTHOR_SPLITTER = Splitter.on(",").omitEmptyStrings();
    private final Map<String, String> authorMap;
    private static final int MIN_AUTHOR_LENGTH_WITHOUT_LOOKUP = 4;
    private final int minCommonSubstring;

    private AuthorComparator(Map<String, String> authors) {
        HashMap<String, String> map = Maps.newHashMap();
        this.minCommonSubstring = 4;
        int counter = 0;
        for (Map.Entry<String, String> entry : authors.entrySet()) {
            String key = AuthorComparator.normalize(entry.getKey());
            String val = AuthorComparator.normalize(entry.getValue());
            if (key == null || val == null) continue;
            map.put(key, val);
            ++counter;
        }
        this.authorMap = ImmutableMap.copyOf(map);
        LOG.info("Created author comparator with {} abbreviation entries", (Object)counter);
    }

    public static AuthorComparator createWithoutAuthormap() {
        return new AuthorComparator(Maps.newHashMap());
    }

    public static AuthorComparator createWithAuthormap() {
        try {
            AuthorComparator ac = new AuthorComparator(FileUtils.streamToMap((InputStream)Resources.asByteSource(AuthorComparator.class.getResource(AUTHOR_MAP_FILENAME)).openStream(), Maps.newHashMap(), (int)0, (int)2, (boolean)true));
            return ac;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load author map from classpath", e);
        }
    }

    public static AuthorComparator createWithAuthormap(Map<String, String> authorMap) {
        return new AuthorComparator(authorMap);
    }

    public Equality compare(@Nullable String authors1, @Nullable String year1, @Nullable String authors2, @Nullable String year2) {
        Equality yresult;
        Equality result = this.compareAuthorteam(authors1, authors2, this.minCommonSubstring, 4);
        if (result != Equality.EQUAL && (yresult = new YearComparator(year1, year2).compare()) != Equality.UNKNOWN) {
            result = yresult;
        }
        return result;
    }

    public Equality compare(ParsedName n1, ParsedName n2) {
        Equality recomb;
        if (!n1.isAuthorsParsed()) {
            n1 = this.clone(n1);
            this.parseAuthorship(n1);
        }
        if (!n2.isAuthorsParsed()) {
            n2 = this.clone(n2);
            this.parseAuthorship(n2);
        }
        if ((recomb = this.compare(n1.getAuthorship(), n1.getYear(), n2.getAuthorship(), n2.getYear())) == Equality.DIFFERENT) {
            return recomb;
        }
        Equality original = this.compare(n1.getBracketAuthorship(), n1.getBracketYear(), n2.getBracketAuthorship(), n2.getBracketYear());
        if (recomb == Equality.UNKNOWN && original == Equality.UNKNOWN) {
            Equality across = Equality.UNKNOWN;
            if (Strings.isNullOrEmpty(n1.getAuthorship()) && Strings.isNullOrEmpty(n1.getYear())) {
                across = this.compare(n1.getBracketAuthorship(), n1.getBracketYear(), n2.getAuthorship(), n2.getYear());
            } else if (Strings.isNullOrEmpty(n1.getBracketAuthorship()) && Strings.isNullOrEmpty(n1.getBracketYear())) {
                across = this.compare(n1.getAuthorship(), n1.getYear(), n2.getBracketAuthorship(), n2.getBracketYear());
            }
            return across == Equality.EQUAL ? Equality.EQUAL : Equality.UNKNOWN;
        }
        return recomb.and(original);
    }

    public boolean compareStrict(String author1, @Nullable String year1, String author2, @Nullable String year2) {
        Equality result = this.compareAuthorteam(author1, author2, this.minCommonSubstring, Integer.MAX_VALUE);
        if (result != Equality.EQUAL) {
            return false;
        }
        if (year1 == null && year2 == null) {
            return true;
        }
        return Equality.EQUAL == new YearComparator(year1, year2).compare();
    }

    @VisibleForTesting
    protected static String normalize(String x) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)x)) {
            return null;
        }
        x = IN.matcher(x).replaceFirst("");
        x = EX.matcher(x).replaceFirst("");
        x = FIL.matcher(x).replaceAll("$1 filius");
        x = AND.matcher(x).replaceAll(", ");
        x = TRANSLITERATIONS.matcher(x).replaceAll("$1");
        x = StringUtils.foldToAscii((String)x);
        x = PUNCTUATION.matcher(x).replaceAll(" ");
        x = COMMA.matcher(x).replaceAll(",");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(x = org.apache.commons.lang3.StringUtils.normalizeSpace((String)x)))) {
            return null;
        }
        return x.toLowerCase();
    }

    @VisibleForTesting
    protected String lookup(String normalizedAuthor) {
        if (normalizedAuthor != null && this.authorMap.containsKey(normalizedAuthor)) {
            return this.authorMap.get(normalizedAuthor);
        }
        return normalizedAuthor;
    }

    private List<String> lookup(List<String> authorTeam) {
        ArrayList<String> authors = Lists.newArrayList();
        for (String author : authorTeam) {
            authors.add(this.lookup(author));
        }
        return authors;
    }

    private List<String> splitAndLookup(String normalizedAuthorTeam, int minAuthorLengthWithoutLookup) {
        ArrayList<String> authors = Lists.newArrayList();
        if (normalizedAuthorTeam != null) {
            for (String author : AUTHOR_SPLITTER.split(normalizedAuthorTeam)) {
                if (minAuthorLengthWithoutLookup > 0 && author.length() < minAuthorLengthWithoutLookup) {
                    authors.add(this.lookup(author));
                    continue;
                }
                authors.add(author);
            }
        }
        return authors;
    }

    private ParsedName clone(ParsedName pn) {
        ParsedName pn2 = new ParsedName();
        try {
            BeanUtils.copyProperties((Object)pn2, (Object)pn);
        }
        catch (IllegalAccessException e) {
            Throwables.propagate(e);
        }
        catch (InvocationTargetException e) {
            Throwables.propagate(e);
        }
        return pn2;
    }

    private void parseAuthorship(ParsedName pn) {
        int idx;
        String lastEpithet = (String)ObjectUtils.coalesce((Object[])new String[]{pn.getInfraSpecificEpithet(), pn.getSpecificEpithet(), pn.getGenusOrAbove()});
        if (lastEpithet != null && pn.getScientificName() != null && (idx = pn.getScientificName().lastIndexOf(lastEpithet)) >= 0) {
            pn.setAuthorship(pn.getScientificName().substring(idx + lastEpithet.length()));
        }
        pn.setYear(pn.getScientificName());
        pn.setAuthorsParsed(true);
    }

    private Equality compareAuthorteam(@Nullable String a1, @Nullable String a2, int minCommonSubstring, int maxAuthorLengthWithoutLookup) {
        List<String> authorTeam1 = this.splitAndLookup(AuthorComparator.normalize(a1), maxAuthorLengthWithoutLookup);
        List<String> authorTeam2 = this.splitAndLookup(AuthorComparator.normalize(a2), maxAuthorLengthWithoutLookup);
        if (!authorTeam1.isEmpty() && !authorTeam2.isEmpty()) {
            Equality equality = this.compareNormalizedAuthorteam(authorTeam1, authorTeam2, minCommonSubstring);
            if (equality != Equality.EQUAL) {
                List<String> authorTeam1l = this.lookup(authorTeam1);
                List<String> authorTeam2l = this.lookup(authorTeam2);
                if (!authorTeam1.equals(authorTeam1l) || !authorTeam2.equals(authorTeam2l)) {
                    equality = this.compareNormalizedAuthorteam(authorTeam1l, authorTeam2l, minCommonSubstring);
                }
            }
            return equality;
        }
        return Equality.UNKNOWN;
    }

    private int lengthWithoutWhitespace(String x) {
        return org.apache.commons.lang3.StringUtils.deleteWhitespace((String)x).length();
    }

    private Equality compareNormalizedAuthorteam(List<String> authorTeam1, List<String> authorTeam2, int minCommonStart) {
        if (authorTeam1.equals(authorTeam2)) {
            return Equality.EQUAL;
        }
        for (String author1 : authorTeam1) {
            for (String author2 : authorTeam2) {
                if (Equality.EQUAL != this.compareNormalizedAuthor(author1, author2, minCommonStart)) continue;
                return Equality.EQUAL;
            }
        }
        return Equality.DIFFERENT;
    }

    @VisibleForTesting
    protected String extractSurname(String name) {
        Matcher m = SURNAME.matcher(name);
        if (m.find()) {
            return m.group(1);
        }
        return name;
    }

    private Equality compareNormalizedAuthor(String a1, String a2, int minCommonStart) {
        if (a1.equals(a2)) {
            return Equality.EQUAL;
        }
        String surname1 = this.extractSurname(a1);
        String surname2 = this.extractSurname(a2);
        String common = org.apache.commons.lang3.StringUtils.getCommonPrefix((String[])new String[]{surname1, surname2});
        if (surname1.equals(surname2) || common.length() >= minCommonStart) {
            if (this.firstInitialsDiffer(a1, a2)) {
                return Equality.DIFFERENT;
            }
            return Equality.EQUAL;
        }
        if (a1.equals(common) && surname2.startsWith(common) || a2.equals(common) && surname1.startsWith(common)) {
            return Equality.EQUAL;
        }
        if (this.lengthWithoutWhitespace(org.apache.commons.lang3.StringUtils.getCommonPrefix((String[])new String[]{a1, a2})) > minCommonStart) {
            return Equality.EQUAL;
        }
        return Equality.DIFFERENT;
    }

    @VisibleForTesting
    protected boolean firstInitialsDiffer(String a1, String a2) {
        Matcher m1 = FIRST_INITIALS.matcher(a1);
        Matcher m2 = FIRST_INITIALS.matcher(a2);
        if (m1.find() && m2.find()) {
            String i2;
            String i1 = m1.group(0);
            if (i1.equals(i2 = m2.group(0))) {
                return false;
            }
            ImmutableList<Character> smaller = Lists.charactersOf(org.apache.commons.lang3.StringUtils.deleteWhitespace((String)i1));
            ImmutableList<Character> larger = Lists.charactersOf(org.apache.commons.lang3.StringUtils.deleteWhitespace((String)i2));
            if (smaller.size() > larger.size()) {
                ImmutableList<Character> tmp = smaller;
                smaller = larger;
                larger = tmp;
            }
            return !CollectionUtils.isSubCollection(smaller, larger);
        }
        return false;
    }
}

