/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata.parse;

import java.net.URI;
import java.util.Date;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.digester3.AbstractObjectCreationFactory;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.ObjectCreationFactory;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.RuleSetBase;
import org.apache.commons.digester3.SetNextRule;
import org.apache.commons.digester3.SetRootRule;
import org.gbif.api.model.common.InterpretedEnum;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Identifier;
import org.gbif.api.model.registry.eml.Collection;
import org.gbif.api.model.registry.eml.DataDescription;
import org.gbif.api.model.registry.eml.KeywordCollection;
import org.gbif.api.model.registry.eml.Project;
import org.gbif.api.model.registry.eml.SamplingDescription;
import org.gbif.api.model.registry.eml.TaxonomicCoverage;
import org.gbif.api.model.registry.eml.TaxonomicCoverages;
import org.gbif.api.model.registry.eml.curatorial.CuratorialUnitComposite;
import org.gbif.api.model.registry.eml.geospatial.BoundingBox;
import org.gbif.api.model.registry.eml.geospatial.GeospatialCoverage;
import org.gbif.api.model.registry.eml.temporal.DateRange;
import org.gbif.api.model.registry.eml.temporal.SingleDate;
import org.gbif.api.model.registry.eml.temporal.VerbatimTimePeriod;
import org.gbif.api.model.registry.eml.temporal.VerbatimTimePeriodType;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.IdentifierType;
import org.gbif.api.vocabulary.Language;
import org.gbif.api.vocabulary.MaintenanceUpdateFrequency;
import org.gbif.api.vocabulary.PreservationMethodType;
import org.gbif.registry.metadata.parse.ParagraphContainer;
import org.gbif.registry.metadata.parse.converter.ContactTypeConverter;
import org.gbif.registry.metadata.parse.converter.CountryTypeConverter;
import org.gbif.registry.metadata.parse.converter.DateConverter;
import org.gbif.registry.metadata.parse.converter.GreedyUriConverter;
import org.gbif.registry.metadata.parse.converter.IdentifierTypeConverter;
import org.gbif.registry.metadata.parse.converter.LanguageTypeConverter;
import org.gbif.registry.metadata.parse.converter.MaintenanceUpdateFrequencyConverter;
import org.gbif.registry.metadata.parse.converter.PreservationMethodTypeConverter;
import org.xml.sax.Attributes;

public class EMLRuleSet
extends RuleSetBase {
    private void setupTypeConverters() {
        GreedyUriConverter uriConverter = new GreedyUriConverter();
        ConvertUtils.register((Converter)uriConverter, URI.class);
        LanguageTypeConverter langConverter = new LanguageTypeConverter();
        ConvertUtils.register((Converter)langConverter, Language.class);
        IdentifierTypeConverter identifierTypeConverter = new IdentifierTypeConverter(IdentifierType.UNKNOWN);
        ConvertUtils.register((Converter)identifierTypeConverter, IdentifierType.class);
        DateConverter dateConverter = new DateConverter();
        ConvertUtils.register((Converter)dateConverter, Date.class);
        CountryTypeConverter countryTypeConverter = new CountryTypeConverter();
        ConvertUtils.register((Converter)countryTypeConverter, Country.class);
        ContactTypeConverter typeConverter = new ContactTypeConverter(ContactType.ADMINISTRATIVE_POINT_OF_CONTACT);
        ConvertUtils.register((Converter)typeConverter, ContactType.class);
        IntegerConverter intConverter = new IntegerConverter();
        ConvertUtils.register((Converter)intConverter, Integer.class);
        PreservationMethodTypeConverter preservationMethodTypeConverter = new PreservationMethodTypeConverter(PreservationMethodType.OTHER);
        ConvertUtils.register((Converter)preservationMethodTypeConverter, PreservationMethodType.class);
        MaintenanceUpdateFrequencyConverter frequencyConverter = new MaintenanceUpdateFrequencyConverter();
        ConvertUtils.register((Converter)frequencyConverter, MaintenanceUpdateFrequency.class);
    }

    public void addRuleInstances(Digester digester) {
        this.setupTypeConverters();
        digester.addCallMethod("eml", "setLanguage", 1, new Class[]{Language.class});
        digester.addCallParam("eml", 0, "xml:lang");
        digester.addCallMethod("eml", "setPackageId", 1);
        digester.addCallParam("eml", 0, "packageId");
        digester.addObjectCreate("eml/dataset/alternateIdentifier", Identifier.class);
        digester.addBeanPropertySetter("eml/dataset/alternateIdentifier", "identifier");
        digester.addBeanPropertySetter("eml/dataset/alternateIdentifier", "type");
        digester.addSetNext("eml/dataset/alternateIdentifier", "addIdentifier");
        digester.addBeanPropertySetter("eml/dataset/title", "title");
        this.addSamplingDescriptionRules(digester, "eml/dataset/methods", "setSamplingDescription");
        digester.addBeanPropertySetter("eml/dataset/language", "dataLanguage");
        digester.addBeanPropertySetter("eml/dataset/distribution/online/url", "homepage");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/resourceLogoUrl", "logoURL");
        digester.addObjectCreate("eml/dataset/abstract", ParagraphContainer.class);
        digester.addCallMethod("eml/dataset/abstract/para", "appendParagraph", 0);
        digester.addRule("eml/dataset/abstract", (Rule)new SetRootRule("addDescription", ParagraphContainer.class));
        this.addCitationRules(digester, "eml/additionalMetadata/metadata/gbif/citation", "setCitation");
        digester.addCallMethod("eml/dataset/pubDate", "setPubDateAsString", 1);
        digester.addCallParam("eml/dataset/pubDate", 0);
        this.addContactRules(digester, "eml/dataset/creator", "addPreferredOriginatorContact");
        this.addContactRules(digester, "eml/dataset/metadataProvider", "addPreferredMetadataContact");
        this.addContactRules(digester, "eml/dataset/associatedParty", "addContact");
        this.addContactRules(digester, "eml/dataset/contact", "addPreferredAdministrativeContact");
        digester.addBeanPropertySetter("eml/dataset/purpose/para", "purpose");
        digester.addBeanPropertySetter("eml/dataset/maintenance/description/para", "maintenanceDescription");
        digester.addBeanPropertySetter("eml/dataset/maintenance/maintenanceUpdateFrequency", "maintenanceUpdateFrequency");
        digester.addBeanPropertySetter("eml/dataset/additionalInfo/para", "additionalInfo");
        digester.addCallMethod("eml/dataset/intellectualRights/para", "setLicense", 2);
        digester.addCallParam("eml/dataset/intellectualRights/para/ulink/citetitle", 1);
        digester.addCallParam("eml/dataset/intellectualRights/para/ulink", 0, "url");
        this.addKeywordCollectionRules(digester, "eml/dataset/keywordSet", "addKeywordCollection");
        this.addCitationRules(digester, "eml/additionalMetadata/metadata/gbif/bibliography/citation", "addBibliographicCitation");
        this.addDataDescriptionRules(digester, "eml/additionalMetadata/metadata/gbif/physical", "addDataDescription");
        this.addGeographicCoverageRules(digester, "eml/dataset/coverage/geographicCoverage", "addGeographicCoverage");
        this.addTemporalCoverageRules(digester);
        this.addTaxonomicCoverageRules(digester);
        this.addProjectRules(digester, "eml/dataset/project", "setProject");
        this.addCollectionRules(digester, "eml/additionalMetadata/metadata/gbif/collection", "addCollection");
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/specimenPreservationMethod", "specimenPreservationMethod");
    }

    private void addTaxonomicCoverageRules(Digester digester) {
        String prefix = "eml/dataset/coverage/taxonomicCoverage";
        digester.addObjectCreate("eml/dataset/coverage/taxonomicCoverage", TaxonomicCoverages.class);
        digester.addBeanPropertySetter("eml/dataset/coverage/taxonomicCoverage/generalTaxonomicCoverage", "description");
        digester.addObjectCreate("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification", TaxonomicCoverage.class);
        digester.addBeanPropertySetter("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification/taxonRankValue", "scientificName");
        digester.addBeanPropertySetter("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification/commonName", "commonName");
        digester.addFactoryCreate("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification/taxonRankName", (ObjectCreationFactory)new InterpretedRankEnumFactory());
        digester.addBeanPropertySetter("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification/taxonRankName", "verbatim");
        digester.addSetNext("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification/taxonRankName", "setRank");
        digester.addSetNext("eml/dataset/coverage/taxonomicCoverage/taxonomicClassification", "addCoverages");
        digester.addSetNext("eml/dataset/coverage/taxonomicCoverage", "addTaxonomicCoverages");
    }

    private void addCitationRules(Digester digester, String path, String parentMethod) {
        digester.addObjectCreate(path, Citation.class);
        digester.addBeanPropertySetter(path, "text");
        digester.addCallMethod(path, "setIdentifier", 1);
        digester.addCallParam(path, 0, "identifier");
        digester.addSetNext(path, parentMethod);
    }

    private void addCollectionRules(Digester digester, String prefix, String parentMethod) {
        digester.addObjectCreate(prefix, Collection.class);
        digester.addBeanPropertySetter(prefix + "/parentCollectionIdentifier", "parentIdentifier");
        digester.addBeanPropertySetter(prefix + "/collectionIdentifier", "identifier");
        digester.addBeanPropertySetter(prefix + "/collectionName", "name");
        this.addCuratorialUnit(digester, "eml/additionalMetadata/metadata/gbif/jgtiCuratorialUnit", "addCuratorial");
        digester.addSetNext(prefix, parentMethod);
    }

    private void addContactRules(Digester digester, String prefix, String parentMethod) {
        digester.addObjectCreate(prefix, Contact.class);
        digester.addCallMethod(prefix + "/userId", "addUserId", 2);
        digester.addCallParam(prefix + "/userId", 0, "directory");
        digester.addCallParam(prefix + "/userId", 1);
        digester.addBeanPropertySetter(prefix + "/individualName/givenName", "firstName");
        digester.addBeanPropertySetter(prefix + "/individualName/surName", "lastName");
        digester.addBeanPropertySetter(prefix + "/organizationName", "organization");
        digester.addCallMethod(prefix + "/positionName", "addPosition", 0);
        digester.addCallMethod(prefix + "/phone", "addPhone", 0);
        digester.addCallMethod(prefix + "/electronicMailAddress", "addEmail", 0);
        digester.addCallMethod(prefix + "/onlineUrl", "addHomepage", 0, new Class[]{URI.class});
        digester.addBeanPropertySetter(prefix + "/role", "type");
        digester.addBeanPropertySetter(prefix + "/address/city", "city");
        digester.addBeanPropertySetter(prefix + "/address/administrativeArea", "province");
        digester.addBeanPropertySetter(prefix + "/address/postalCode", "postalCode");
        digester.addBeanPropertySetter(prefix + "/address/country", "country");
        digester.addCallMethod(prefix + "/address/deliveryPoint", "addAddress", 0);
        digester.addSetNext(prefix, parentMethod);
    }

    private void addCuratorialUnit(Digester digester, String prefix, String parentMethod) {
        digester.addObjectCreate(prefix, CuratorialUnitComposite.class);
        digester.addCallMethod(prefix + "/jgtiUnits", "addDeviation", 1);
        digester.addCallParam(prefix + "/jgtiUnits", 0, "uncertaintyMeasure");
        digester.addBeanPropertySetter(prefix + "/jgtiUnitType", "typeVerbatim");
        digester.addBeanPropertySetter(prefix + "/jgtiUnits", "count");
        digester.addBeanPropertySetter(prefix + "/jgtiUnitRange/beginRange", "lower");
        digester.addBeanPropertySetter(prefix + "/jgtiUnitRange/endRange", "upper");
        digester.addSetNext(prefix + "/jgtiUnitType", parentMethod);
    }

    private void addDataDescriptionRules(Digester digester, String prefix, String parentMethod) {
        digester.addObjectCreate(prefix, DataDescription.class);
        digester.addBeanPropertySetter(prefix + "/objectName", "name");
        digester.addBeanPropertySetter(prefix + "/characterEncoding", "charset");
        digester.addBeanPropertySetter(prefix + "/dataFormat/externallyDefinedFormat/formatName", "format");
        digester.addBeanPropertySetter(prefix + "/dataFormat/externallyDefinedFormat/formatVersion", "formatVersion");
        digester.addBeanPropertySetter(prefix + "/distribution/online/url", "url");
        digester.addSetNext(prefix, parentMethod);
    }

    private void addGeographicCoverageRules(Digester digester, String prefix, String parentMethod) {
        digester.addObjectCreate(prefix, GeospatialCoverage.class);
        digester.addBeanPropertySetter(prefix + "/geographicDescription", "description");
        digester.addObjectCreate(prefix + "/boundingCoordinates", BoundingBox.class);
        digester.addBeanPropertySetter(prefix + "/boundingCoordinates/westBoundingCoordinate", "minLongitude");
        digester.addBeanPropertySetter(prefix + "/boundingCoordinates/eastBoundingCoordinate", "maxLongitude");
        digester.addBeanPropertySetter(prefix + "/boundingCoordinates/northBoundingCoordinate", "maxLatitude");
        digester.addBeanPropertySetter(prefix + "/boundingCoordinates/southBoundingCoordinate", "minLatitude");
        digester.addSetNext(prefix + "/boundingCoordinates", "setBoundingBox");
        digester.addSetNext(prefix, parentMethod);
    }

    private void addKeywordCollectionRules(Digester digester, String prefix, String parentMethod) {
        digester.addObjectCreate(prefix, KeywordCollection.class);
        digester.addCallMethod(prefix + "/keyword", "addKeyword", 1);
        digester.addCallParam(prefix + "/keyword", 0);
        digester.addBeanPropertySetter(prefix + "/keywordThesaurus", "thesaurus");
        digester.addSetNext(prefix, parentMethod);
    }

    private void addProjectRules(Digester digester, String prefix, String parentMethod) {
        digester.addObjectCreate(prefix, Project.class);
        digester.addCallMethod(prefix, "setIdentifier", 1);
        digester.addCallParam(prefix, 0, "id");
        digester.addBeanPropertySetter(prefix + "/title", "title");
        this.addContactRules(digester, prefix + "/personnel", "addContact");
        digester.addBeanPropertySetter(prefix + "/funding/para", "funding");
        digester.addBeanPropertySetter(prefix + "/studyAreaDescription/descriptor/descriptorValue", "studyAreaDescription");
        digester.addBeanPropertySetter(prefix + "/designDescription/description/para", "designDescription");
        digester.addSetNext(prefix, parentMethod);
    }

    private void addSamplingDescriptionRules(Digester digester, String prefix, String parentMethod) {
        digester.addObjectCreate(prefix, SamplingDescription.class);
        digester.addBeanPropertySetter(prefix + "/sampling/studyExtent/description/para", "studyExtent");
        digester.addBeanPropertySetter(prefix + "/sampling/studyExtent/description/para", "studyExtent");
        digester.addBeanPropertySetter(prefix + "/sampling/samplingDescription/para", "sampling");
        digester.addBeanPropertySetter(prefix + "/qualityControl/description/para", "qualityControl");
        digester.addObjectCreate(prefix + "/methodStep", ParagraphContainer.class);
        digester.addCallMethod(prefix + "/methodStep/description/para", "appendParagraph", 0);
        digester.addRule(prefix + "/methodStep/description", (Rule)new SetRootRule("addMethodStep", ParagraphContainer.class));
        SetNextRule nextRule = new SetNextRule(parentMethod);
        nextRule.setFireOnBegin(true);
        digester.addRule(prefix, (Rule)nextRule);
    }

    private void addTemporalCoverageRules(Digester digester) {
        digester.addObjectCreate("eml/dataset/coverage/temporalCoverage/singleDateTime", SingleDate.class);
        digester.addBeanPropertySetter("eml/dataset/coverage/temporalCoverage/singleDateTime/calendarDate", "date");
        digester.addSetNext("eml/dataset/coverage/temporalCoverage/singleDateTime", "addTemporalCoverage");
        digester.addObjectCreate("eml/dataset/coverage/temporalCoverage/rangeOfDates", DateRange.class);
        digester.addBeanPropertySetter("eml/dataset/coverage/temporalCoverage/rangeOfDates/beginDate/calendarDate", "start");
        digester.addBeanPropertySetter("eml/dataset/coverage/temporalCoverage/rangeOfDates/endDate/calendarDate", "end");
        digester.addSetNext("eml/dataset/coverage/temporalCoverage/rangeOfDates", "addTemporalCoverage");
        digester.addObjectCreate("eml/additionalMetadata/metadata/gbif/livingTimePeriod", VerbatimTimePeriod.class);
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/livingTimePeriod", "period");
        digester.addCallMethod("eml/additionalMetadata/metadata/gbif/livingTimePeriod", "setType", 1, new Class[]{VerbatimTimePeriodType.class});
        digester.addObjectParam("eml/additionalMetadata/metadata/gbif/livingTimePeriod", 0, (Object)VerbatimTimePeriodType.LIVING_TIME_PERIOD);
        digester.addSetNext("eml/additionalMetadata/metadata/gbif/livingTimePeriod", "addTemporalCoverage");
        digester.addObjectCreate("eml/additionalMetadata/metadata/gbif/formationPeriod", VerbatimTimePeriod.class);
        digester.addBeanPropertySetter("eml/additionalMetadata/metadata/gbif/formationPeriod", "period");
        digester.addCallMethod("eml/additionalMetadata/metadata/gbif/formationPeriod", "setType", 1, new Class[]{VerbatimTimePeriodType.class});
        digester.addObjectParam("eml/additionalMetadata/metadata/gbif/formationPeriod", 0, (Object)VerbatimTimePeriodType.FORMATION_PERIOD);
        digester.addSetNext("eml/additionalMetadata/metadata/gbif/formationPeriod", "addTemporalCoverage");
    }

    public class InterpretedRankEnumFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) throws Exception {
            return new InterpretedEnum();
        }
    }
}

